/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.primitives.Ints;
import java.io.File;
import java.util.ArrayList;
import net.maizegenetics.analysis.imputation.FILLINFindHaplotypesPlugin;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class FILLINDonorGenotypeUtils {
    public static GenotypeTable[] loadDonors(String donorFile, GenotypeTable unimpAlign, int minTestSites, boolean verboseOutput, int appoxSitesPerDonorGenotypeTable) {
        try {
            if (donorFile.contains(".gX")) {
                return FILLINDonorGenotypeUtils.loadDonors(donorFile, unimpAlign, minTestSites, verboseOutput);
            }
            return FILLINDonorGenotypeUtils.loadDonors(donorFile, appoxSitesPerDonorGenotypeTable, verboseOutput);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Incorrect donor file supplied. Must contain '.gX' within the file name,\nand match a set of files output from FILLINFindHaplotypesPlugin()");
        }
    }

    public static GenotypeTable[] loadDonors(String donorFileRoot, GenotypeTable unimpAlign, int minTestSites, boolean verboseOutput) {
        File theDF = new File(donorFileRoot);
        String prefilter = theDF.getName().split(".gX.")[0] + ".gc";
        String prefilterOld = theDF.getName().split("s\\+")[0] + "s";
        ArrayList<File> d = new ArrayList<File>();
        for (File file : theDF.getParentFile().listFiles()) {
            if (file.getName().equals(theDF.getName())) {
                d.add(file);
            }
            if (file.getName().startsWith(prefilter)) {
                d.add(file);
            }
            if (!file.getName().startsWith(prefilterOld)) continue;
            d.add(file);
        }
        PositionList targetPositions = unimpAlign.positions();
        ArrayList<GenotypeTable> donorList = new ArrayList<GenotypeTable>();
        for (int i = 0; i < d.size(); ++i) {
            if (verboseOutput) {
                System.out.println("Starting Read");
            }
            GenotypeTable donorAlign = ImportUtils.readFromHapmap(((File)d.get(i)).getPath());
            ArrayList<Integer> subSites = new ArrayList<Integer>();
            PositionList donorPositions = donorAlign.positions();
            for (int j = 0; j < donorAlign.numberOfSites(); ++j) {
                if (targetPositions.siteOfPhysicalPosition(donorPositions.physicalPositions()[j], donorPositions.chromosome(j)) <= -1) continue;
                subSites.add(j);
            }
            if (subSites.size() == donorAlign.numberOfSites()) {
                donorList.add(donorAlign);
                if (!verboseOutput) continue;
                System.out.printf("Donor file shares all sites with target:%s taxa:%d sites:%d %n", ((File)d.get(i)).getPath(), donorAlign.numberOfTaxa(), donorAlign.numberOfSites());
                continue;
            }
            if (subSites.size() < 2) {
                if (!verboseOutput) continue;
                System.out.printf("Donor file contains <2 matching sites and will not be used:%s", ((File)d.get(i)).getPath());
                continue;
            }
            donorAlign = GenotypeTableBuilder.getGenotypeCopyInstance(FilterGenotypeTable.getInstance(donorAlign, Ints.toArray(subSites)));
            donorList.add(donorAlign);
            if (verboseOutput) {
                System.out.printf("Donor file sites filtered to match target:%s taxa:%d sites:%d %n", ((File)d.get(i)).getPath(), donorAlign.numberOfTaxa(), donorAlign.numberOfSites());
            }
            if (subSites.size() >= minTestSites * 2 || !verboseOutput) continue;
            System.out.println("This donor alignment contains marginally sufficient matching snp positions. Region unlikely to impute well.");
        }
        return donorList.toArray(new GenotypeTable[0]);
    }

    public static GenotypeTable[] loadDonors(String donorFile, int appoxSitesPerHaplotype, boolean verboseOutput) {
        GenotypeTable donorMasterGT = ImportUtils.readGuessFormat(donorFile);
        donorMasterGT = GenotypeTableBuilder.getHomozygousInstance(donorMasterGT);
        int[][] donorFirstLastSites = FILLINFindHaplotypesPlugin.divideChromosome(donorMasterGT, appoxSitesPerHaplotype, verboseOutput);
        GenotypeTable[] donorAlign = new GenotypeTable[donorFirstLastSites.length];
        for (int i = 0; i < donorAlign.length; ++i) {
            if (verboseOutput) {
                System.out.println("Starting Read");
            }
            donorAlign[i] = GenotypeTableBuilder.getGenotypeCopyInstance(FilterGenotypeTable.getInstance(donorMasterGT, donorFirstLastSites[i][0], donorFirstLastSites[i][1]));
        }
        return donorAlign;
    }

    public static OpenBitSet[][] createMaskForAlignmentConflicts(GenotypeTable unimpAlign, GenotypeTable[] donorAlign, boolean print) {
        OpenBitSet[][] result = new OpenBitSet[donorAlign.length][4];
        for (int da = 0; da < result.length; ++da) {
            int donorOffset = unimpAlign.positions().siteOfPhysicalPosition(donorAlign[da].positions().physicalPositions()[0], donorAlign[da].positions().chromosome(0));
            OpenBitSet goodMask = new OpenBitSet(donorAlign[da].numberOfSites());
            OpenBitSet swapMjMnMask = new OpenBitSet(donorAlign[da].numberOfSites());
            OpenBitSet errorMask = new OpenBitSet(donorAlign[da].numberOfSites());
            OpenBitSet invariantMask = new OpenBitSet(donorAlign[da].numberOfSites());
            int siteConflicts = 0;
            int swaps = 0;
            int invariant = 0;
            boolean good = false;
            for (int i = 0; i < donorAlign[da].numberOfSites(); ++i) {
                byte tMj = unimpAlign.majorAllele(i + donorOffset);
                byte tMn = unimpAlign.minorAllele(i + donorOffset);
                byte daMj = donorAlign[da].majorAllele(i);
                byte daMn = donorAlign[da].minorAllele(i);
                if (daMn == 15) {
                    ++invariant;
                    invariantMask.set(i);
                    goodMask.set(i);
                    continue;
                }
                if (daMj == tMn && daMn == tMj) {
                    ++swaps;
                    swapMjMnMask.set(i);
                    goodMask.set(i);
                    continue;
                }
                if (daMj == tMj) continue;
                ++siteConflicts;
                errorMask.set(i);
                goodMask.set(i);
            }
            goodMask.not();
            if (print) {
                System.out.println("Donor:" + da + "invariant in donor:" + invariant + " swapConflicts:" + swaps + " errors:" + siteConflicts);
            }
            result[da] = new OpenBitSet[]{goodMask, swapMjMnMask, errorMask, invariantMask};
        }
        return result;
    }

    public static BitSet[] arrangeMajorMinorBtwAlignments(GenotypeTable unimpAlign, int bt, int donorOffset, int donorLength, OpenBitSet goodMask, OpenBitSet swapMjMnMask, boolean isSwapMajorMinor) {
        int unimpAlignStartBlock = donorOffset / 64;
        int shift = donorOffset - unimpAlignStartBlock * 64;
        int unimpAlignEndBlock = unimpAlignStartBlock + (donorLength + shift - 1) / 64;
        OpenBitSet mjUnImp = new OpenBitSet(unimpAlign.allelePresenceForSitesBlock(bt, WHICH_ALLELE.Major, unimpAlignStartBlock, unimpAlignEndBlock + 1));
        OpenBitSet mnUnImp = new OpenBitSet(unimpAlign.allelePresenceForSitesBlock(bt, WHICH_ALLELE.Minor, unimpAlignStartBlock, unimpAlignEndBlock + 1));
        OpenBitSet mjTbs = new OpenBitSet(donorLength);
        OpenBitSet mnTbs = new OpenBitSet(donorLength);
        for (int i = 0; i < donorLength; ++i) {
            if (mjUnImp.fastGet(i + shift)) {
                mjTbs.set(i);
            }
            if (!mnUnImp.fastGet(i + shift)) continue;
            mnTbs.set(i);
        }
        OpenBitSet newmj = new OpenBitSet(mjTbs);
        OpenBitSet newmn = new OpenBitSet(mnTbs);
        mjTbs.and(goodMask);
        mnTbs.and(goodMask);
        if (isSwapMajorMinor) {
            newmj.and(swapMjMnMask);
            newmn.and(swapMjMnMask);
            mjTbs.or(newmn);
            mnTbs.or(newmj);
        }
        BitSet[] result = new BitSet[]{mjTbs, mnTbs};
        return result;
    }
}

