/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;

public class NumericalGenotypePlugin
extends AbstractPlugin {
    private TRANSFORM_TYPE myTransformType = TRANSFORM_TYPE.collapse;

    public NumericalGenotypePlugin() {
        super(null, false);
    }

    @Override
    public DataSet performFunction(DataSet dataSet) {
        List<Datum> data = dataSet.getDataOfType(GenotypeTable.class);
        if (data != null && data.size() == 1) {
            Datum datum = data.get(0);
            if (this.myTransformType == TRANSFORM_TYPE.collapse) {
                GenotypeTable input = (GenotypeTable)datum.getData();
                SimplePhenotype result = NumericalGenotypePlugin.collapseTransform(input);
                DataSet tds = new DataSet(new Datum(datum.getName() + "_Collapse", result, null), (Plugin)this);
                this.fireDataSetReturned(tds);
                return tds;
            }
            if (this.myTransformType == TRANSFORM_TYPE.separated) {
                GenotypeTable input = (GenotypeTable)datum.getData();
                SimplePhenotype result = NumericalGenotypePlugin.separatedTransform(input);
                DataSet tds = new DataSet(new Datum(datum.getName() + "_Separated", result, null), (Plugin)this);
                this.fireDataSetReturned(tds);
                return tds;
            }
            throw new IllegalArgumentException("NumericalGenotypePlugin: performFunction: unknown transform type.");
        }
        return null;
    }

    public static SimplePhenotype separatedTransform(GenotypeTable input) {
        int seqCount = input.numberOfTaxa();
        int siteCount = input.numberOfSites();
        Map[] alleleCounts = new Map[siteCount];
        for (int i = 0; i < siteCount; ++i) {
            HashMap<Byte, Integer> charCount = new HashMap<Byte, Integer>();
            for (int j = 0; j < seqCount; ++j) {
                byte[] current = input.genotypeArray(j, i);
                byte orderedValue = GenotypeTableUtils.getUnphasedDiploidValue(current[0], current[1]);
                if (orderedValue == -1) continue;
                Integer count = (Integer)charCount.get(orderedValue);
                if (count != null) {
                    charCount.put(orderedValue, new Integer(count + 1));
                    continue;
                }
                charCount.put(orderedValue, 1);
            }
            alleleCounts[i] = charCount;
        }
        int columnCount = 0;
        for (int i = 0; i < siteCount; ++i) {
            columnCount += alleleCounts[i].size();
        }
        double[][] pcValues = new double[seqCount][columnCount];
        ArrayList<Trait> traitNames = new ArrayList<Trait>();
        int offset = 0;
        for (int i = 0; i < siteCount; ++i) {
            int k;
            Map currentHash = alleleCounts[i];
            int currentSize = currentHash.size();
            byte[] sortChars = new byte[currentSize];
            Iterator itr = currentHash.keySet().iterator();
            int count = 0;
            while (itr.hasNext()) {
                sortChars[count++] = (Byte)itr.next();
            }
            boolean change = true;
            while (change) {
                change = false;
                for (k = 0; k < currentSize - 1; ++k) {
                    Integer second;
                    Integer first = (Integer)currentHash.get(sortChars[k]);
                    if (first.compareTo(second = (Integer)currentHash.get(sortChars[k + 1])) <= 0) continue;
                    byte temp = sortChars[k];
                    sortChars[k] = sortChars[k + 1];
                    sortChars[k + 1] = temp;
                    change = true;
                }
            }
            for (k = 0; k < currentSize; ++k) {
                traitNames.add(new Trait("S" + i, false, "data"));
                currentHash.put(sortChars[k], k);
            }
            for (int j = 0; j < seqCount; ++j) {
                byte[] current = input.genotypeArray(j, i);
                byte orderedValue = GenotypeTableUtils.getUnphasedDiploidValue(current[0], current[1]);
                if (orderedValue == -1) {
                    for (int k2 = 0; k2 < currentSize; ++k2) {
                        pcValues[j][k2 + offset] = Double.NaN;
                    }
                    continue;
                }
                int position = (Integer)currentHash.get(orderedValue);
                pcValues[j][position + offset] = 1.0;
            }
            offset += currentSize;
        }
        return new SimplePhenotype(input.taxa(), traitNames, pcValues);
    }

    public static SimplePhenotype collapseTransform(GenotypeTable input) {
        int seqCount = input.numberOfTaxa();
        int siteCount = input.numberOfSites();
        double[][] pcValues = new double[seqCount][siteCount];
        ArrayList<Trait> traitNames = new ArrayList<Trait>();
        for (int i = 0; i < siteCount; ++i) {
            traitNames.add(new Trait("S" + i, false, "data"));
            byte[] allelesByFreq = input.alleles(i);
            for (int j = 0; j < seqCount; ++j) {
                byte[] current = input.genotypeArray(j, i);
                if (current[0] == 15 && current[1] == 15) {
                    pcValues[j][i] = Double.NaN;
                    continue;
                }
                pcValues[j][i] = 1.0;
                if (current[0] == allelesByFreq[0]) {
                    double[] dArray = pcValues[j];
                    int n = i;
                    dArray[n] = dArray[n] - 0.5;
                }
                if (current[1] != allelesByFreq[0]) continue;
                double[] dArray = pcValues[j];
                int n = i;
                dArray[n] = dArray[n] - 0.5;
            }
        }
        return new SimplePhenotype(input.taxa(), traitNames, pcValues);
    }

    public void setTransformType(TRANSFORM_TYPE type) {
        this.myTransformType = type;
    }

    public TRANSFORM_TYPE getTransformType() {
        return this.myTransformType;
    }

    @Override
    public String getToolTipText() {
        return "";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "";
    }

    public static enum TRANSFORM_TYPE {
        collapse,
        separated;

    }
}

