/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.maizegenetics.dna.snp.GenotypeTable;

class DiversityDialog
extends JDialog {
    int start = 0;
    int end;
    int step = 100;
    int window = 500;
    boolean runAnalysis = false;
    GenotypeTable theAlignment;
    JPanel panel1 = new JPanel();
    JButton runButton = new JButton();
    JPanel jPanel1 = new JPanel();
    JTextField stepTextField = new JTextField();
    JTextField endTextField = new JTextField();
    JTextField startTextField = new JTextField();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel1 = new JLabel();
    JCheckBox slidingCheckBox = new JCheckBox();
    JCheckBox silentCheckBox = new JCheckBox();
    JCheckBox noncodingCheckBox = new JCheckBox();
    JCheckBox intronCheckBox = new JCheckBox();
    JCheckBox nontranscribedCheckBox = new JCheckBox();
    JCheckBox synonymousCheckBox = new JCheckBox();
    JCheckBox indelNonCodingCheckBox = new JCheckBox();
    JCheckBox codingCheckBox = new JCheckBox();
    JCheckBox codingIndelsCheckBox = new JCheckBox();
    JCheckBox overallCheckBox = new JCheckBox();
    JCheckBox allIndelCheckBox = new JCheckBox();
    JTextField windowTextField = new JTextField();
    JLabel jLabel4 = new JLabel();
    JCheckBox nonSynCheckBox = new JCheckBox();
    JCheckBox transcribedCheckBox = new JCheckBox();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JButton closeButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();

    public DiversityDialog(GenotypeTable aa) {
        super((Frame)null, "Diversity Surveys", true);
        this.theAlignment = aa;
        try {
            this.end = this.theAlignment.numberOfSites() - 1;
            this.jbInit();
            this.turnOffOptionsIfNotAnnotated();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiversityDialog.this.runButton_actionPerformed(e);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiversityDialog.this.closeButton_actionPerformed(e);
            }
        });
        this.stepTextField.setText("" + this.step);
        this.stepTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DiversityDialog.this.stepTextField_focusLost(e);
            }
        });
        this.endTextField.setText("" + this.end);
        this.endTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DiversityDialog.this.endTextField_focusLost(e);
            }
        });
        this.startTextField.setText("" + this.start);
        this.startTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DiversityDialog.this.startTextField_focusLost(e);
            }
        });
        this.jLabel3.setText("Step");
        this.jLabel2.setText("End Base");
        this.jLabel1.setText("Start Base");
        this.slidingCheckBox.setText("Sliding Window");
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.silentCheckBox.setText("Silent");
        this.silentCheckBox.setSelected(false);
        this.noncodingCheckBox.setText("Noncoding");
        this.intronCheckBox.setText("Intron");
        this.nontranscribedCheckBox.setText("Non-transcribed");
        this.synonymousCheckBox.setText("Synonymous");
        this.indelNonCodingCheckBox.setText("Noncoding Indels");
        this.codingCheckBox.setText("Coding");
        this.codingIndelsCheckBox.setText("Coding Indels");
        this.overallCheckBox.setText("Overall");
        this.overallCheckBox.setSelected(true);
        this.allIndelCheckBox.setText("Indels");
        this.windowTextField.setText("" + this.window);
        this.windowTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DiversityDialog.this.windowTextField_focusLost(e);
            }
        });
        this.jLabel4.setText("Window");
        this.nonSynCheckBox.setText("Nonsynonymous");
        this.transcribedCheckBox.setText("Transcribed");
        this.jPanel2.setPreferredSize(new Dimension(200, 300));
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiversityDialog.this.closeButton_actionPerformed(e);
            }
        });
        this.panel1.setMinimumSize(new Dimension(200, 200));
        this.panel1.setPreferredSize(new Dimension(200, 250));
        this.panel1.add((Component)this.silentCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.noncodingCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.intronCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.synonymousCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.nontranscribedCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.indelNonCodingCheckBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.transcribedCheckBox, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.nonSynCheckBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.codingCheckBox, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.codingIndelsCheckBox, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.overallCheckBox, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.allIndelCheckBox, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.slidingCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.stepTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 31, 7, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 8, 62), 20, 0));
        this.jPanel1.add((Component)this.windowTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 15, 8, 15), 0, 0));
        this.getContentPane().add((Component)this.panel1, "West");
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(58, 36, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.startTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(58, 10, 0, 50), 41, 0));
        this.jPanel2.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 36, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.endTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(9, 10, 0, 49), 42, 0));
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.runButton, null);
        this.jPanel3.add((Component)this.closeButton, null);
        this.getContentPane().add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(27, 43, 43, 14), 0, 4));
    }

    private void endTextField_focusLost(FocusEvent e) {
        try {
            this.end = Integer.parseInt(this.endTextField.getText());
            if (this.end <= this.start || this.end > this.theAlignment.numberOfSites() - 1) {
                this.end = this.theAlignment.numberOfSites() - 1;
            }
        }
        catch (Exception ee) {
            this.end = this.theAlignment.numberOfSites() - 1;
        }
        this.endTextField.setText(this.end + "");
    }

    private void turnOffOptionsIfNotAnnotated() {
        boolean annotatedSites = false;
        if (!annotatedSites) {
            this.codingCheckBox.setEnabled(false);
            this.noncodingCheckBox.setEnabled(false);
            this.silentCheckBox.setEnabled(false);
            this.intronCheckBox.setEnabled(false);
            this.nontranscribedCheckBox.setEnabled(false);
            this.codingIndelsCheckBox.setEnabled(false);
            this.synonymousCheckBox.setEnabled(false);
            this.indelNonCodingCheckBox.setEnabled(false);
            this.nonSynCheckBox.setEnabled(false);
            this.transcribedCheckBox.setEnabled(false);
        }
    }

    void startTextField_focusLost(FocusEvent e) {
        try {
            this.start = Integer.parseInt(this.startTextField.getText());
            if (this.end <= this.start || this.start < 0) {
                this.start = 0;
            }
        }
        catch (Exception ee) {
            this.start = 0;
        }
        this.startTextField.setText(this.start + "");
    }

    public boolean isRunAnalysis() {
        return this.runAnalysis;
    }

    public boolean isSlidingWindowAnalysis() {
        return this.slidingCheckBox.isSelected();
    }

    public int getStepSize() {
        return this.step;
    }

    public int getWindowSize() {
        return this.window;
    }

    public int getEndSite() {
        return this.end;
    }

    public int getStartSite() {
        return this.start;
    }

    void runButton_actionPerformed(ActionEvent e) {
        this.runAnalysis = true;
        this.setVisible(false);
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.runAnalysis = false;
        this.setVisible(false);
    }

    boolean isCancel() {
        return !this.runAnalysis;
    }

    void stepTextField_focusLost(FocusEvent e) {
        try {
            this.step = Integer.parseInt(this.stepTextField.getText());
            if (this.step <= 0 || this.step > this.theAlignment.numberOfSites() - 1) {
                this.step = this.theAlignment.numberOfSites() - 1;
            }
        }
        catch (Exception ee) {
            this.step = 100;
        }
        this.stepTextField.setText(this.step + "");
    }

    void windowTextField_focusLost(FocusEvent e) {
        try {
            this.window = Integer.parseInt(this.windowTextField.getText());
            if (this.window <= 0 || this.window > this.theAlignment.numberOfSites() - 1) {
                this.window = this.theAlignment.numberOfSites() - 1;
            }
        }
        catch (Exception ee) {
            this.window = 400;
        }
        this.windowTextField.setText(this.window + "");
    }
}

