/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.AbstractPETagsOnPhysicalMap;
import net.maizegenetics.dna.tag.PETagCounts;
import net.maizegenetics.dna.tag.SAMUtils;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class PETagsOnPhysicalMap
extends AbstractPETagsOnPhysicalMap {
    public PETagsOnPhysicalMap(String infileS, TagsByTaxa.FilePacking format) {
        this.readDistFile(infileS, format);
    }

    public PETagsOnPhysicalMap(PETagCounts ptc, String fSamFileS, String bSamFileS, String contigSamFileS) {
        this.iniMatrix(ptc.getTagSizeInLong(), ptc.getTagCount());
        this.initializeValue(ptc);
        this.readSamFile(fSamFileS, AbstractPETagsOnPhysicalMap.PETagType.Forward);
        this.readSamFile(bSamFileS, AbstractPETagsOnPhysicalMap.PETagType.Backward);
        this.readSamFile(contigSamFileS, AbstractPETagsOnPhysicalMap.PETagType.Contig);
    }

    private void readSamFile(String samFileS, AbstractPETagsOnPhysicalMap.PETagType t) {
        byte[] strand;
        int[] posEnd;
        int[] posStart;
        int[] chromosome;
        if (t == AbstractPETagsOnPhysicalMap.PETagType.Forward) {
            chromosome = this.chrF;
            posStart = this.posStartF;
            posEnd = this.posEndF;
            strand = this.strandF;
        } else if (t == AbstractPETagsOnPhysicalMap.PETagType.Backward) {
            chromosome = this.chrB;
            posStart = this.posStartB;
            posEnd = this.posEndB;
            strand = this.strandB;
        } else {
            chromosome = this.chrContig;
            posStart = this.posStartContig;
            posEnd = this.posEndContig;
            strand = this.strandContig;
        }
        try {
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(samFileS), 65536);
            while ((temp = br.readLine()) != null) {
                if (temp.startsWith("@")) continue;
                this.parseSAMAlignment(temp, chromosome, posStart, posEnd, strand);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseSAMAlignment(String inputStr, int[] chromosome, int[] posStart, int[] posEnd, byte[] strand) {
        String[] temp = inputStr.split("\t");
        int tagIndex = Integer.parseInt(temp[0]);
        if (temp[2].equals("*")) {
            return;
        }
        HashMap<String, Integer> SAMFields = this.parseOptionalFieldsFromSAMAlignment(temp);
        byte bestHits = (byte)Math.min(SAMFields.get("nBestHits"), 127);
        if (bestHits != 1) {
            return;
        }
        chromosome[tagIndex] = Integer.parseInt(temp[2]);
        strand[tagIndex] = Integer.parseInt(temp[1]) == 16 ? -1 : 1;
        this.recordStartEndPostionFromSAMAlign(tagIndex, strand[tagIndex], Integer.parseInt(temp[3]), temp[5], posStart, posEnd);
    }

    private void recordStartEndPostionFromSAMAlign(int tagIndex, byte strand, int pos, String cigar, int[] posStart, int[] posEnd) {
        block4: {
            int[] alignSpan = SAMUtils.adjustCoordinates(cigar, pos);
            try {
                if (strand == 1) {
                    posStart[tagIndex] = alignSpan[0];
                    posEnd[tagIndex] = alignSpan[1];
                    break block4;
                }
                if (strand == -1) {
                    posStart[tagIndex] = alignSpan[1];
                    posEnd[tagIndex] = alignSpan[0];
                    break block4;
                }
                throw new Exception("Unexpected value for strand: " + strand + "(expect 1 or -1)");
            }
            catch (Exception e) {
                System.out.println("Error in recordStartEndPostionFromSAMAlign: " + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private HashMap<String, Integer> parseOptionalFieldsFromSAMAlignment(String[] inputLine) {
        HashMap<String, Integer> SAMFields = new HashMap<String, Integer>();
        for (int field = 11; field < inputLine.length; ++field) {
            if (inputLine[field].regionMatches(0, "AS", 0, 2)) {
                SAMFields.put("bestScore", Integer.parseInt(inputLine[field].split(":")[2]));
                continue;
            }
            if (inputLine[field].regionMatches(0, "XS", 0, 2)) {
                SAMFields.put("nextScore", Integer.parseInt(inputLine[field].split(":")[2]));
                continue;
            }
            if (!inputLine[field].regionMatches(0, "NM", 0, 2)) continue;
            SAMFields.put("editDist", Integer.parseInt(inputLine[field].split(":")[2]));
        }
        if (SAMFields.containsKey("bestScore")) {
            if (SAMFields.containsKey("nextScore")) {
                if (SAMFields.get("bestScore") > SAMFields.get("nextScore")) {
                    SAMFields.put("nBestHits", 1);
                } else {
                    SAMFields.put("nBestHits", 127);
                }
            } else {
                SAMFields.put("nBestHits", 1);
            }
        }
        return SAMFields;
    }

    private void initializeValue(PETagCounts ptc) {
        this.tagLengthInLong = ptc.getTagSizeInLong();
        for (int i = 0; i < this.getTagCount(); ++i) {
            this.tagsF[i] = ptc.getTagF(i);
            this.tagsB[i] = ptc.getTagB(i);
            this.tagFLength[i] = ptc.getTagFLength(i);
            this.tagBLength[i] = ptc.getTagBLength(i);
            this.contigLengthInLong[i] = ptc.getContigLengthInLong(i);
            this.contig[i] = ptc.getContig(i);
            this.contigLength[i] = ptc.getContigLength(i);
            this.chrF[i] = Integer.MIN_VALUE;
            this.chrB[i] = Integer.MIN_VALUE;
            this.chrContig[i] = Integer.MIN_VALUE;
            this.posStartF[i] = Integer.MIN_VALUE;
            this.posStartB[i] = Integer.MIN_VALUE;
            this.posStartContig[i] = Integer.MIN_VALUE;
            this.posEndF[i] = Integer.MIN_VALUE;
            this.posEndB[i] = Integer.MIN_VALUE;
            this.posEndContig[i] = Integer.MIN_VALUE;
            this.strandF[i] = -128;
            this.strandB[i] = -128;
            this.strandContig[i] = -128;
        }
    }

    public void readDistFile(String infileS, TagsByTaxa.FilePacking format) {
        System.out.println("Reading PTOPM file to " + infileS);
        File infile = new File(infileS);
        switch (format) {
            case Text: {
                this.readTextPTOPMFile(infile);
                break;
            }
            default: {
                this.readBinaryPTOPMFile(infile);
            }
        }
        System.out.println("PTOPM file read. Tatol: " + this.getTagCount() + " PETags");
    }

    private void readBinaryPTOPMFile(File infile) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(infile), 65536));
            this.tagLengthInLong = dis.readInt();
            int tagNum = dis.readInt();
            this.iniMatrix(this.tagLengthInLong, tagNum);
            for (int i = 0; i < tagNum; ++i) {
                int j;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsF[i][j] = dis.readLong();
                }
                this.tagFLength[i] = dis.readShort();
                this.chrF[i] = dis.readInt();
                this.posStartF[i] = dis.readInt();
                this.posEndF[i] = dis.readInt();
                this.strandF[i] = dis.readByte();
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsB[i][j] = dis.readLong();
                }
                this.tagBLength[i] = dis.readShort();
                this.chrB[i] = dis.readInt();
                this.posStartB[i] = dis.readInt();
                this.posEndB[i] = dis.readInt();
                this.strandB[i] = dis.readByte();
                this.contigLengthInLong[i] = dis.readByte();
                this.contig[i] = new long[this.contigLengthInLong[i]];
                for (j = 0; j < this.contig[i].length; ++j) {
                    this.contig[i][j] = dis.readLong();
                }
                this.contigLength[i] = dis.readShort();
                this.chrContig[i] = dis.readInt();
                this.posStartContig[i] = dis.readInt();
                this.posEndContig[i] = dis.readInt();
                this.strandContig[i] = dis.readByte();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void readTextPTOPMFile(File infile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(infile), 65536);
            this.tagLengthInLong = Integer.valueOf(br.readLine());
            int tagNum = Integer.valueOf(br.readLine());
            this.iniMatrix(this.tagLengthInLong, tagNum);
            br.readLine();
            for (int i = 0; i < tagNum; ++i) {
                int j;
                String[] temp = br.readLine().split("\t");
                long[] t = BaseEncoder.getLongArrayFromSeq(temp[0]);
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsF[i][j] = t[j];
                }
                this.tagFLength[i] = Short.valueOf(temp[1]);
                this.chrF[i] = Integer.valueOf(temp[2]);
                this.posStartF[i] = Integer.valueOf(temp[3]);
                this.posEndF[i] = Integer.valueOf(temp[4]);
                this.strandF[i] = Byte.valueOf(temp[5]);
                t = BaseEncoder.getLongArrayFromSeq(temp[6]);
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    this.tagsB[i][j] = t[j];
                }
                this.tagBLength[i] = Short.valueOf(temp[7]);
                this.chrB[i] = Integer.valueOf(temp[8]);
                this.posStartB[i] = Integer.valueOf(temp[9]);
                this.posEndB[i] = Integer.valueOf(temp[10]);
                this.strandB[i] = Byte.valueOf(temp[11]);
                this.contigLengthInLong[i] = Byte.valueOf(temp[12]);
                this.contigLength[i] = Short.valueOf(temp[13]);
                this.chrContig[i] = Integer.valueOf(temp[14]);
                this.posStartContig[i] = Integer.valueOf(temp[15]);
                this.posEndContig[i] = Integer.valueOf(temp[16]);
                this.strandContig[i] = Byte.valueOf(temp[17]);
                this.contig[i] = new long[this.contigLengthInLong[i]];
                if (this.contigLengthInLong[i] == 0) continue;
                t = BaseEncoder.getLongArrayFromSeq(temp[18]);
                for (j = 0; j < t.length; ++j) {
                    this.contig[i][j] = t[j];
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void writeDistFile(String outfileS, TagsByTaxa.FilePacking format) {
        System.out.println("Writing PTOPM file to " + outfileS);
        switch (format) {
            case Text: {
                this.writeTextPTOPMFile(outfileS);
                break;
            }
            default: {
                this.writeBinaryPTOPMFile(outfileS);
            }
        }
        System.out.println("PPTOM file written");
    }

    private void writeBinaryPTOPMFile(String outfileS) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfileS), 65536));
            dos.writeInt(this.tagLengthInLong);
            dos.writeInt(this.getTagCount());
            for (int i = 0; i < this.getTagCount(); ++i) {
                int j;
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    dos.writeLong(this.tagsF[i][j]);
                }
                dos.writeShort(this.tagFLength[i]);
                dos.writeInt(this.chrF[i]);
                dos.writeInt(this.posStartF[i]);
                dos.writeInt(this.posEndF[i]);
                dos.writeByte(this.strandF[i]);
                for (j = 0; j < this.tagLengthInLong; ++j) {
                    dos.writeLong(this.tagsB[i][j]);
                }
                dos.writeShort(this.tagBLength[i]);
                dos.writeInt(this.chrB[i]);
                dos.writeInt(this.posStartB[i]);
                dos.writeInt(this.posEndB[i]);
                dos.writeByte(this.strandB[i]);
                dos.writeByte(this.contigLengthInLong[i]);
                for (j = 0; j < this.contigLengthInLong[i]; ++j) {
                    dos.writeLong(this.contig[i][j]);
                }
                dos.writeShort(this.contigLength[i]);
                dos.writeInt(this.chrContig[i]);
                dos.writeInt(this.posStartContig[i]);
                dos.writeInt(this.posEndContig[i]);
                dos.writeByte(this.strandContig[i]);
            }
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void writeTextPTOPMFile(String outfileS) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write(String.valueOf(this.tagLengthInLong));
            bw.newLine();
            bw.write(String.valueOf(this.getTagCount()));
            bw.newLine();
            bw.write("TagF\tLengthF\tChrF\tPosStartF\tPosEndF\tStrandF\tTagB\tLengthB\tChrB\tPosStartB\tPosEndB\tStrandB\tLengthInLongContig\tLengthContig\tChrContig\tPosStartContig\tPosEndContig\tStrandContig\tTagContig");
            bw.newLine();
            for (int i = 0; i < this.getTagCount(); ++i) {
                bw.write(BaseEncoder.getSequenceFromLong(this.getTagF(i)) + "\t" + String.valueOf(this.getTagFLength(i)) + "\t");
                bw.write(String.valueOf(this.chrF[i]) + "\t" + String.valueOf(this.posStartF[i]) + "\t" + String.valueOf(this.posEndF[i]) + "\t" + String.valueOf(this.strandF[i]) + "\t");
                bw.write(BaseEncoder.getSequenceFromLong(this.getTagB(i)) + "\t" + String.valueOf(this.getTagBLength(i)) + "\t");
                bw.write(String.valueOf(this.chrB[i]) + "\t" + String.valueOf(this.posStartB[i]) + "\t" + String.valueOf(this.posEndB[i]) + "\t" + String.valueOf(this.strandB[i]) + "\t");
                bw.write(String.valueOf(this.contigLengthInLong[i]) + "\t" + String.valueOf(this.contigLength[i]) + "\t");
                bw.write(String.valueOf(this.chrContig[i]) + "\t" + String.valueOf(this.posStartContig[i]) + "\t" + String.valueOf(this.posEndContig[i]) + "\t" + String.valueOf(this.strandContig[i]) + "\t");
                if (this.getContigLengthInLong(i) != 0) {
                    bw.write(BaseEncoder.getSequenceFromLong(this.contig[i]) + "\t");
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

