/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.byte3d;

import net.maizegenetics.dna.snp.byte3d.Byte3D;

public abstract class AbstractByte3D
implements Byte3D {
    private final int myNumAlleles;
    private final int myNumTaxa;
    private final int myNumSites;

    public AbstractByte3D(int numAlleles, int numTaxa, int numSites) {
        this.myNumAlleles = numAlleles;
        this.myNumTaxa = numTaxa;
        this.myNumSites = numSites;
    }

    @Override
    public byte[][] valuesForAllSites(int taxon) {
        byte[][] result = new byte[this.myNumAlleles][this.myNumSites];
        for (int allele = 0; allele < this.myNumAlleles; ++allele) {
            for (int site = 0; site < this.myNumSites; ++site) {
                result[allele][site] = this.valueForAllele(taxon, site, allele);
            }
        }
        return result;
    }

    @Override
    public int numTaxa() {
        return this.myNumTaxa;
    }

    @Override
    public int numSites() {
        return this.myNumSites;
    }

    @Override
    public int numAlleles() {
        return this.myNumAlleles;
    }
}

