/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.depth.AlleleDepthUtil;
import net.maizegenetics.dna.snp.io.HeaderPositions;

class ProcessVCFBlock
implements Runnable {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern SLASH_PATTERN = Pattern.compile("/");
    private final HeaderPositions hp;
    private final int taxaN;
    private final int siteN;
    private final int startSite;
    private final GenotypeTableBuilder hdf5Builder;
    private ArrayList<String> txtL;
    private byte[][] gTS;
    private byte[][][] dTS;
    private final ArrayList<Position> blkPosList;
    private final boolean keepDepth;

    private ProcessVCFBlock(int taxaN, HeaderPositions hp, ArrayList<String> txtL, int startSite, GenotypeTableBuilder hdf5Builder, boolean keepDepth) {
        this.taxaN = taxaN;
        this.siteN = txtL.size();
        this.txtL = txtL;
        this.hp = hp;
        this.blkPosList = new ArrayList(this.siteN);
        this.startSite = startSite;
        this.hdf5Builder = hdf5Builder;
        this.keepDepth = keepDepth;
    }

    static ProcessVCFBlock getInstance(int taxaN, HeaderPositions hp, ArrayList<String> txtL, boolean keepDepth) {
        return new ProcessVCFBlock(taxaN, hp, txtL, Integer.MIN_VALUE, null, keepDepth);
    }

    static ProcessVCFBlock getInstance(int taxaN, HeaderPositions hp, ArrayList<String> txtL, int startSite, GenotypeTableBuilder hdf5Builder, boolean keepDepth) {
        return new ProcessVCFBlock(taxaN, hp, txtL, startSite, hdf5Builder, keepDepth);
    }

    @Override
    public void run() {
        HashMap<String, Chromosome> chromosomeLookup = new HashMap<String, Chromosome>();
        this.gTS = new byte[this.taxaN][this.siteN];
        if (this.keepDepth) {
            this.dTS = new byte[this.taxaN][6][this.siteN];
        }
        for (int s = 0; s < this.siteN; ++s) {
            String input = this.txtL.get(s);
            try {
                int[] tabPos = new int[this.hp.NUM_HAPMAP_NON_TAXA_HEADERS + this.taxaN];
                int tabIndex = 0;
                int len = input.length();
                for (int i = 0; tabIndex < this.hp.NUM_HAPMAP_NON_TAXA_HEADERS + this.taxaN && i < len; ++i) {
                    if (input.charAt(i) != '\t') continue;
                    tabPos[tabIndex++] = i;
                }
                String chrName = input.substring(0, tabPos[this.hp.CHROMOSOME_INDEX]);
                Chromosome currChr = (Chromosome)chromosomeLookup.get(chrName);
                if (currChr == null) {
                    currChr = new Chromosome(new String(chrName));
                    chromosomeLookup.put(chrName, currChr);
                }
                String snpID = null;
                if (this.hp.SNPID_INDEX > 0) {
                    snpID = input.substring(tabPos[this.hp.SNPID_INDEX - 1] + 1, tabPos[this.hp.SNPID_INDEX]);
                }
                String refS = input.substring(tabPos[this.hp.REF_INDEX - 1] + 1, tabPos[this.hp.REF_INDEX]);
                String alt = input.substring(tabPos[this.hp.ALT_INDEX - 1] + 1, tabPos[this.hp.ALT_INDEX]);
                String variants = alt.equals(".") ? refS : (refS + "/" + alt).replace(',', '/').replace("<INS>", "+").replace('I', '+').replace("<DEL>", "-").replace('D', '-');
                GeneralPosition.Builder apb = new GeneralPosition.Builder(currChr, Integer.parseInt(input.substring(tabPos[this.hp.POSITION_INDEX - 1] + 1, tabPos[this.hp.POSITION_INDEX]))).knownVariants(variants);
                if (snpID != null && !snpID.equals(".")) {
                    apb.snpName(snpID);
                }
                byte[] alleles = new byte[(variants.length() + 1) / 2];
                int i = 0;
                int varInd = 0;
                while (i < alleles.length) {
                    alleles[i] = NucleotideAlignmentConstants.getNucleotideAlleleByte(variants.charAt(varInd));
                    ++i;
                    varInd += 2;
                }
                apb.allele(WHICH_ALLELE.Reference, alleles[0]);
                for (String annoS : Splitter.on((String)";").split((CharSequence)input.substring(tabPos[this.hp.INFO_INDEX - 1] + 1, tabPos[this.hp.INFO_INDEX]))) {
                    apb.addAnno(annoS);
                }
                this.blkPosList.add(apb.build());
                boolean iGT = false;
                int iAD = -1;
                int iDP = -1;
                int iGQ = -1;
                int iPL = -1;
                if (this.hp.FORMAT_INDEX >= 0) {
                    String[] formatS = input.substring(tabPos[this.hp.FORMAT_INDEX - 1] + 1, tabPos[this.hp.FORMAT_INDEX]).split(":");
                    iAD = ProcessVCFBlock.firstEqualIndex(formatS, "AD");
                }
                int t = 0;
                for (String taxaAllG : Splitter.on((String)"\t").split((CharSequence)input.substring(tabPos[this.hp.NUM_HAPMAP_NON_TAXA_HEADERS - 1] + 1))) {
                    int f = 0;
                    for (String fieldS : Splitter.on((String)":").split((CharSequence)taxaAllG)) {
                        if (f == 0) {
                            int a1 = fieldS.charAt(0) - 48;
                            int a2 = fieldS.charAt(2) - 48;
                            this.gTS[t][s] = a1 < 0 || a2 < 0 ? -1 : GenotypeTableUtils.getDiploidValue(alleles[a1], alleles[a2]);
                        } else if (f == iAD && this.keepDepth) {
                            int i2 = 0;
                            for (String ad : Splitter.on((String)",").split((CharSequence)fieldS)) {
                                if (alleles[i2] == 15) {
                                    ++i2;
                                    continue;
                                }
                                int adInt = Integer.parseInt(ad);
                                this.dTS[t][alleles[i2++]][s] = AlleleDepthUtil.depthIntToByte(adInt);
                            }
                        }
                        ++f;
                    }
                    ++t;
                }
                continue;
            }
            catch (Exception e) {
                System.err.println("Err Site Number:" + s);
                System.err.println("Err:" + input);
                throw e;
            }
        }
        this.txtL = null;
        if (this.hdf5Builder != null) {
            this.addResultsToHDF5Builder();
            this.gTS = null;
            this.dTS = null;
            this.txtL = null;
            this.blkPosList.clear();
        }
    }

    private void addResultsToHDF5Builder() {
        this.hdf5Builder.addSiteBlock(this.startSite, PositionListBuilder.getInstance(this.blkPosList), this.gTS, this.dTS);
    }

    int getSiteNumber() {
        return this.siteN;
    }

    byte[][] getGenoTS() {
        return this.gTS;
    }

    byte[][][] getDepthTS() {
        return this.dTS;
    }

    ArrayList<Position> getBlkPosList() {
        return this.blkPosList;
    }

    private static int firstEqualIndex(String[] sa, String match) {
        for (int i = 0; i < sa.length; ++i) {
            if (!sa[i].equals(match)) continue;
            return i;
        }
        return -1;
    }
}

