/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.Tags;

public class TagCountMutable
extends TagCounts {
    int currentRows = 0;

    public TagCountMutable(int tagLengthInLong, int maxSize) {
        this.tagLengthInLong = tagLengthInLong;
        this.initMatrices(maxSize);
    }

    public TagCountMutable(Tags origTagCount, int maxSize) {
        this.tagLengthInLong = origTagCount.getTagSizeInLong();
        this.initMatrices(maxSize);
        if (origTagCount instanceof TagCounts) {
            this.addReadCounts((TagCounts)origTagCount);
        } else {
            this.addReadCounts(origTagCount, 0);
        }
    }

    @Override
    protected void initMatrices(int tagNum) {
        this.tags = new long[this.tagLengthInLong][tagNum];
        this.tagLength = new byte[tagNum];
        this.readCount = new int[tagNum];
    }

    public int getCurrentSize() {
        return this.currentRows;
    }

    public void addReadCount(long[] tag, int length, int count) {
        for (int j = 0; j < this.tagLengthInLong; ++j) {
            this.tags[j][this.currentRows] = tag[j];
        }
        this.tagLength[this.currentRows] = (byte)length;
        this.readCount[this.currentRows] = count;
        ++this.currentRows;
    }

    public void addReadCounts(TagCounts tagCountsToAdd) {
        for (int i = 0; i < tagCountsToAdd.getTagCount(); ++i) {
            long[] ls = tagCountsToAdd.getTag(i);
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tags[j][this.currentRows] = ls[j];
            }
            this.tagLength[this.currentRows] = (byte)tagCountsToAdd.getTagLength(i);
            this.readCount[this.currentRows] = tagCountsToAdd.getReadCount(i);
            ++this.currentRows;
        }
    }

    public void addReadCounts(Tags tagsToAdd, int defaultCount) {
        for (int i = 0; i < tagsToAdd.getTagCount(); ++i) {
            long[] ls = tagsToAdd.getTag(i);
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tags[j][this.currentRows] = ls[j];
            }
            this.tagLength[this.currentRows] = (byte)tagsToAdd.getTagLength(i);
            this.readCount[this.currentRows] = defaultCount;
            ++this.currentRows;
        }
    }

    @Override
    public void collapseCounts() {
        this.sort();
        int collapsedRows = 0;
        int initSize = this.getCurrentSize();
        for (int i = 1; i < this.getSize(); ++i) {
            if (this.tags[0][i] == 0L) {
                this.readCount[i] = 0;
                continue;
            }
            if (this.compare(i, i - 1) != 0) continue;
            int n = i;
            this.readCount[n] = this.readCount[n] + this.readCount[i - 1];
            this.readCount[i - 1] = 0;
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tags[j][i - 1] = 0L;
            }
            ++collapsedRows;
            --this.currentRows;
        }
        this.sort();
        System.out.println("Rows collapsed:" + collapsedRows);
        int retained = initSize - collapsedRows;
        System.out.println("Unique tags retained:" + retained);
    }

    public void removeRareTag(int minCutoff) {
        for (int i = 0; i < this.getCurrentSize(); ++i) {
            if (this.readCount[i] >= minCutoff) continue;
            this.tags[0][i] = 0L;
            this.readCount[i] = 0;
        }
        this.collapseCounts();
    }

    public int shrinkToCurrentRows() {
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            long[] t1 = new long[this.currentRows];
            System.arraycopy(this.tags[i], 0, t1, 0, this.currentRows);
            this.tags[i] = t1;
        }
        return this.currentRows;
    }

    @Override
    public int compare(int index1, int index2) {
        if (this.tags[0][index1] == 0L || this.tags[0][index2] == 0L) {
            if (this.tags[0][index1] == this.tags[0][index2]) {
                return 0;
            }
            if (this.tags[0][index1] != 0L) {
                return -1;
            }
            return 1;
        }
        for (int i = 0; i < this.tagLengthInLong; ++i) {
            if (this.tags[i][index1] < this.tags[i][index2]) {
                return -1;
            }
            if (this.tags[i][index1] <= this.tags[i][index2]) continue;
            return 1;
        }
        return 0;
    }
}

