/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class TagsByTaxaByteFileMapSeq
extends AbstractTagsByTaxa {
    private String name;
    private DataInputStream theRAF;
    private long bufferedTagIndex = Integer.MIN_VALUE;
    private byte[] bufferedTagDist = null;
    private long[] currTag;
    private byte currTagLength;
    private long byteLenRow = -1L;
    String infileName = "Unknown";

    public TagsByTaxaByteFileMapSeq(String infile) {
        this.infileName = infile;
        this.readDistFile(new File(infile), TagsByTaxa.FilePacking.Byte);
        this.bufferedTagIndex = -1L;
        this.bufferedTagDist = new byte[this.taxaNum];
        this.currTag = new long[this.tagLengthInLong];
        Arrays.fill(this.currTag, Long.MIN_VALUE);
        this.name = infile;
    }

    @Override
    public void readDistFile(File inFile, TagsByTaxa.FilePacking binary) {
        int hapsOutput = 0;
        try {
            this.theRAF = new DataInputStream(new BufferedInputStream(new FileInputStream(inFile), 4000000));
            int tagNum = this.theRAF.readInt();
            this.tagLengthInLong = this.theRAF.readInt();
            this.taxaNum = this.theRAF.readInt();
            this.initMatrices(this.taxaNum, tagNum);
            for (int t = 0; t < this.taxaNum; ++t) {
                this.taxaNames[t] = this.theRAF.readUTF();
            }
            hapsOutput = tagNum;
        }
        catch (Exception e) {
            System.out.println("Catch in reading input file: " + e);
            e.printStackTrace();
        }
        System.out.println("Number of Taxa in file:" + this.taxaNum);
        System.out.println("Number of Haplotypes in file:" + hapsOutput);
    }

    @Override
    public int getReadCountForTagTaxon(int tagIndex, int taxaIndex) {
        if ((long)tagIndex == this.bufferedTagIndex) {
            return this.bufferedTagDist[taxaIndex];
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public synchronized byte[] advanceToTagDist(long[] tag) {
        if (this.theRAF == null) {
            return new byte[this.taxaNum];
        }
        try {
            while (TagsByTaxaByteFileMapSeq.compareTags(this.currTag, tag) < 0) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.currTag[j] = this.theRAF.readLong();
                }
                this.currTagLength = this.theRAF.readByte();
                this.bufferedTagDist = new byte[this.taxaNum];
                this.theRAF.read(this.bufferedTagDist);
                ++this.bufferedTagIndex;
            }
            if (TagsByTaxaByteFileMapSeq.compareTags(this.currTag, tag) == 0) {
                return this.bufferedTagDist;
            }
            return new byte[this.taxaNum];
        }
        catch (IOException e) {
            System.out.println("Closing: " + this.infileName);
            try {
                this.theRAF.close();
                this.theRAF = null;
            }
            catch (IOException ee) {
                System.out.println("Uncloseable:" + this.infileName);
                e.printStackTrace();
            }
            return new byte[this.taxaNum];
        }
    }

    @Override
    public void initMatrices(int taxaNum, int tagNum) {
        this.taxaNames = new String[taxaNum];
    }

    @Override
    public void addTaxa(String[] addTaxaNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMethodByRows(boolean rowSetMethod) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setReadCountForTagTaxon(int tagIndex, int taxaIndex, int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getFileReadyForClosing() {
        if (this.theRAF == null) {
            return;
        }
        try {
            this.theRAF.close();
        }
        catch (IOException e) {
            System.out.println("Error closing: " + this.infileName + e);
            e.printStackTrace();
        }
    }
}

