/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.gui.AbstractGenotypeTableMask;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.taxa.Taxon;

public class GenotypeTableMaskReference
extends AbstractGenotypeTableMask {
    private static final long serialVersionUID = -5197800047652332969L;
    private final int myTaxonReference;
    private final GenotypeTable myAlignment;

    private GenotypeTableMaskReference(GenotypeTable align, int taxonReference, String name, Color color) {
        super(align, name, color, GenotypeTableMask.MaskType.reference);
        this.myTaxonReference = taxonReference;
        this.myAlignment = align;
    }

    public static GenotypeTableMaskReference getInstanceCompareReference(GenotypeTable align) {
        return GenotypeTableMaskReference.getInstanceCompareReference(align, -1);
    }

    public static GenotypeTableMaskReference getInstanceCompareReference(GenotypeTable align, Taxon id) {
        int index = align.taxa().indexOf(id);
        if (index < 0) {
            throw new IllegalArgumentException("GenotypeTableMaskReference: getInstanceCompareReference: unknown id: " + id);
        }
        return GenotypeTableMaskReference.getInstanceCompareReference(align, index);
    }

    public static GenotypeTableMaskReference getInstanceCompareReference(GenotypeTable align, String id) {
        int index = align.taxa().indexOf(id);
        if (index < 0) {
            throw new IllegalArgumentException("GenotypeTableMaskReference: getInstanceCompareReference: unknown id: " + id);
        }
        return GenotypeTableMaskReference.getInstanceCompareReference(align, index);
    }

    public static GenotypeTableMaskReference getInstanceCompareReference(GenotypeTable align, int index) {
        if (index < -1 || index >= align.numberOfTaxa()) {
            throw new IllegalArgumentException("GenotypeTableMaskReference: getInstanceCompareReference: unknown index: " + index);
        }
        String name = index == -1 ? "Alignment Reference" : align.taxaName(index) + " Reference";
        return new GenotypeTableMaskReference(align, index, name, GenotypeTableMaskReference.getNextColor());
    }

    @Override
    public byte getMask(int taxon, int site) {
        if (this.myTaxonReference == -1 && GenotypeTableUtils.isEqualOrUnknown(this.myAlignment.genotype(taxon, site), (byte)(this.myAlignment.referenceAllele(site) << 4 | this.myAlignment.referenceAllele(site)))) {
            return 0;
        }
        if (GenotypeTableUtils.isEqualOrUnknown(this.myAlignment.genotypeArray(taxon, site), this.myAlignment.genotypeArray(this.myTaxonReference, site))) {
            return 0;
        }
        return 1;
    }
}

