/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ReportDestinationDialog
extends JDialog {
    private JCheckBox chkFileOutput;
    private JCheckBox chkRestrictOutput;
    private JTextField txtFilename;
    private JTextField txtMaxP;
    private double maxp = 1.0;
    private JDialog thisDialog = this;
    private boolean okayChecked = false;

    public static void main(String[] args) {
        ReportDestinationDialog rdd = new ReportDestinationDialog();
        rdd.setVisible(true);
        System.exit(-1);
    }

    public ReportDestinationDialog() {
        this.setModal(true);
        this.setTitle("Choose Output Format");
        String msg = "By default all output will be stored in memory. If the output is large enough it could exceed the memory space available to TASSEL and cause TASSEL to crash. If you think this could be a problem, you can choose to write the output to a text file instead. Enter only the file base name. The dataset name and file type will be appended when the report is saved.";
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.txtFilename = new JTextField(30);
        this.txtMaxP = new JTextField(8);
        this.txtMaxP.setText("1e-3");
        JTextArea txtWarning = new JTextArea(msg);
        txtWarning.setLineWrap(true);
        txtWarning.setWrapStyleWord(true);
        txtWarning.setPreferredSize(new Dimension(500, 150));
        txtWarning.setEditable(false);
        final JLabel lblFilename = new JLabel("Output base file name:");
        final JLabel lblMaxp = new JLabel("Do not keep p-values larger than");
        final JButton btnBrowse = new JButton("Browse");
        JButton btnOkay = new JButton("Okay");
        lblFilename.setEnabled(false);
        lblMaxp.setEnabled(false);
        btnBrowse.setEnabled(false);
        this.txtFilename.setEnabled(false);
        this.txtMaxP.setEnabled(false);
        this.chkFileOutput = new JCheckBox("Write output to file", false);
        this.chkFileOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ReportDestinationDialog.this.chkFileOutput.isSelected()) {
                    lblFilename.setEnabled(true);
                    ReportDestinationDialog.this.txtFilename.setEnabled(true);
                    btnBrowse.setEnabled(true);
                } else {
                    lblFilename.setEnabled(false);
                    ReportDestinationDialog.this.txtFilename.setEnabled(false);
                    btnBrowse.setEnabled(false);
                }
            }
        });
        this.chkRestrictOutput = new JCheckBox("Filter output on p-value", false);
        this.chkRestrictOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReportDestinationDialog.this.chkRestrictOutput.isSelected()) {
                    lblMaxp.setEnabled(true);
                    ReportDestinationDialog.this.txtMaxP.setEnabled(true);
                } else {
                    lblMaxp.setEnabled(false);
                    ReportDestinationDialog.this.txtMaxP.setEnabled(false);
                }
            }
        });
        btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Choose a File for Output");
                int action = chooser.showSaveDialog(ReportDestinationDialog.this.thisDialog);
                if (action == 0) {
                    File theFile = chooser.getSelectedFile();
                    ReportDestinationDialog.this.txtFilename.setText(theFile.getPath());
                }
            }
        });
        btnOkay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean validp = true;
                ReportDestinationDialog.this.okayChecked = true;
                if (ReportDestinationDialog.this.chkRestrictOutput.isSelected()) {
                    try {
                        ReportDestinationDialog.this.maxp = Double.parseDouble(ReportDestinationDialog.this.txtMaxP.getText());
                    }
                    catch (Exception e) {
                        validp = false;
                    }
                }
                if (validp) {
                    ReportDestinationDialog.this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(ReportDestinationDialog.this.thisDialog, "Max P is not a valid number.");
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(20, 5, 20, 5);
        contentPane.add((Component)txtWarning, gbc);
        JPanel pnlFile = new JPanel(new GridBagLayout());
        pnlFile.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.insets = new Insets(10, 10, 10, 10);
        contentPane.add((Component)pnlFile, gbc);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(15, 5, 5, 5);
        pnlFile.add((Component)this.chkFileOutput, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        pnlFile.add((Component)lblFilename, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        pnlFile.add((Component)this.txtFilename, gbc);
        gbc.gridx = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        pnlFile.add((Component)btnBrowse, gbc);
        JPanel pnlMaxp = new JPanel(new GridBagLayout());
        pnlMaxp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        contentPane.add((Component)pnlMaxp, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(15, 5, 5, 5);
        pnlMaxp.add((Component)this.chkRestrictOutput, gbc);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        pnlMaxp.add((Component)lblMaxp, gbc);
        gbc.gridx = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        pnlMaxp.add((Component)this.txtMaxP, gbc);
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(15, 5, 20, 5);
        contentPane.add((Component)btnOkay, gbc);
        this.pack();
    }

    public double getMaxP() {
        return this.maxp;
    }

    public String getOutputFileName() {
        return this.txtFilename.getText().trim();
    }

    public boolean wasUseFileChecked() {
        return this.chkFileOutput.isSelected();
    }

    public boolean wasRestrictOutputChecked() {
        return this.chkRestrictOutput.isSelected();
    }

    public boolean isOkayChecked() {
        return this.okayChecked;
    }
}

