/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;

public class SymmetricEigenvalueDecomposition
implements EigenvalueDecomposition {
    double[] V;
    int n;
    int size;
    double[] d;
    double[] e;

    public SymmetricEigenvalueDecomposition(double[] matrix) {
        this.size = matrix.length;
        this.V = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.V[i] = matrix[i];
        }
        this.n = (int)Math.round(Math.sqrt(this.size));
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.tred2();
        this.tql2();
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getEigenvectorsAs1dArray() {
        return this.V;
    }

    private void tred2() {
        int k;
        int start = this.size - this.n;
        for (int j = 0; j < this.n; ++j) {
            this.d[j] = this.V[start + j];
        }
        int starti = this.size;
        for (int i = this.n - 1; i > 0; --i) {
            int k2;
            starti -= this.n;
            double scale = 0.0;
            double h = 0.0;
            for (k2 = 0; k2 < i; ++k2) {
                scale += Math.abs(this.d[k2]);
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                for (int j = 0; j < i; ++j) {
                    this.d[j] = this.V[starti - this.n + j];
                    this.V[starti + j] = 0.0;
                    this.V[j * this.n + i] = 0.0;
                }
            } else {
                int j;
                int j2;
                for (k2 = 0; k2 < i; ++k2) {
                    int n = k2;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k2] * this.d[k2];
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                for (int j3 = 0; j3 < i; ++j3) {
                    this.e[j3] = 0.0;
                }
                int startj = 0;
                for (j2 = 0; j2 < i; ++j2) {
                    this.V[startj + i] = f = this.d[j2];
                    g = this.e[j2] + this.V[startj + j2] * f;
                    int cell = startj + this.n + j2;
                    k = j2 + 1;
                    while (k <= i - 1) {
                        g += this.V[cell] * this.d[k];
                        int n = k++;
                        this.e[n] = this.e[n] + this.V[cell] * f;
                        cell += this.n;
                    }
                    this.e[j2] = g;
                    startj += this.n;
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n = j2;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j2] * this.d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    int n = j;
                    this.e[n] = this.e[n] - hh * this.d[j];
                }
                for (j = 0; j < i; ++j) {
                    f = this.d[j];
                    g = this.e[j];
                    int cell = j * this.n + j;
                    for (int k3 = j; k3 <= i - 1; ++k3) {
                        int n = cell;
                        this.V[n] = this.V[n] - (f * this.e[k3] + g * this.d[k3]);
                        cell += this.n;
                    }
                    cell = starti - this.n + j;
                    this.d[j] = this.V[cell];
                    this.V[cell += this.n] = 0.0;
                }
            }
            this.d[i] = h;
        }
        int rowi = 0;
        int lastrow = this.size - this.n;
        int lastcol = this.n - 1;
        for (int i = 0; i < this.n - 1; ++i) {
            int k4;
            int celliplus1;
            int cell = rowi + i;
            this.V[lastrow + i] = this.V[cell];
            this.V[cell] = 1.0;
            double h = this.d[i + 1];
            if (h != 0.0) {
                celliplus1 = i + 1;
                for (k4 = 0; k4 <= i; ++k4) {
                    this.d[k4] = this.V[celliplus1] / h;
                    celliplus1 += this.n;
                }
                for (int j = 0; j <= i; ++j) {
                    double g = 0.0;
                    celliplus1 = i + 1;
                    int cellj = j;
                    for (k = 0; k <= i; ++k) {
                        g += this.V[celliplus1] * this.V[cellj];
                        celliplus1 += this.n;
                        cellj += this.n;
                    }
                    cellj = j;
                    for (k = 0; k <= i; ++k) {
                        int n = cellj;
                        this.V[n] = this.V[n] - g * this.d[k];
                        cellj += this.n;
                    }
                }
            }
            celliplus1 = i + 1;
            for (k4 = 0; k4 <= i; ++k4) {
                this.V[celliplus1] = 0.0;
                celliplus1 += this.n;
            }
            rowi += this.n;
        }
        for (int j = 0; j < this.n; ++j) {
            int cell = lastrow + j;
            this.d[j] = this.V[cell];
            this.V[cell] = 0.0;
        }
        this.V[lastrow + lastcol] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = this.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i2];
                        h = c * p;
                        r = this.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s * r;
                        s = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s * g;
                        this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                        int celliplus1 = i2 + 1;
                        int celli = 1;
                        for (int k = 0; k < this.n; ++k) {
                            h = this.V[celliplus1];
                            this.V[celliplus1] = s * this.V[celli] + c * h;
                            this.V[celli] = c * this.V[celli] - s * h;
                            celliplus1 += this.n;
                            celli += this.n;
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int k = i;
            double p = this.d[i];
            for (int j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            int celli = i;
            int cellk = k;
            for (int j = 0; j < this.n; ++j) {
                p = this.V[celli];
                this.V[celli] = this.V[cellk];
                this.V[cellk] = p;
                celli += this.n;
                cellk += this.n;
            }
        }
    }

    private double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    @Override
    public double getEigenvalue(int i) {
        return this.d[i];
    }

    @Override
    public DoubleMatrix getEigenvalueMatrix() {
        return DoubleMatrixFactory.DEFAULT.diagonal(this.d);
    }

    @Override
    public double[] getEigenvalues() {
        return this.d;
    }

    @Override
    public DoubleMatrix getEigenvectors() {
        return DoubleMatrixFactory.DEFAULT.make(this.n, this.n, this.V);
    }
}

