/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.CorePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import org.apache.log4j.Logger;

public class PhenotypeBuilder {
    private Logger myLogger = Logger.getLogger(PhenotypeBuilder.class);
    private SOURCE_TYPE source;
    private String filename;
    private Phenotype basePhenotype;
    private List<Phenotype> phenotypesToJoin;
    private List<Taxon> taxaToKeep = null;
    private List<Taxon> taxaToRemove = null;
    private List<PhenotypeAttribute> attributeList = null;
    private List<Phenotype.ATTRIBUTE_TYPE> attributeTypeList = null;
    private int[] indexOfAttributesToKeep = null;
    private HashMap<Phenotype.ATTRIBUTE_TYPE, Integer> attributeChangeMap = new HashMap();
    private boolean isUnionJoin;
    private boolean isFilterable = false;
    private String phenotypeName = "Phenotype";

    public PhenotypeBuilder filterablePhenotypeBuilder(Phenotype basePhenotype) {
        this.basePhenotype = basePhenotype;
        this.source = SOURCE_TYPE.phenotype;
        this.isFilterable = true;
        return this;
    }

    public PhenotypeBuilder fromFile(String filename) {
        this.filename = filename;
        this.source = SOURCE_TYPE.file;
        return this;
    }

    public PhenotypeBuilder joinPhenotypes(List<Phenotype> phenotypes) {
        this.phenotypesToJoin = phenotypes;
        this.isUnionJoin = false;
        this.source = SOURCE_TYPE.join;
        return this;
    }

    public PhenotypeBuilder intersect() {
        this.isUnionJoin = false;
        return this;
    }

    public PhenotypeBuilder union() {
        this.isUnionJoin = true;
        return this;
    }

    public PhenotypeBuilder fromList(List<PhenotypeAttribute> attributes, List<Phenotype.ATTRIBUTE_TYPE> types) {
        this.attributeList = attributes;
        this.attributeTypeList = types;
        this.source = SOURCE_TYPE.list;
        return this;
    }

    public PhenotypeBuilder assignName(String name) {
        this.phenotypeName = name;
        return this;
    }

    public PhenotypeBuilder keepTaxa(List<Taxon> taxaToKeep) {
        if (!this.isFilterable) {
            this.notFilterable();
        }
        this.taxaToKeep = taxaToKeep;
        return this;
    }

    public PhenotypeBuilder removeTaxa(List<Taxon> taxaToRemove) {
        if (!this.isFilterable) {
            this.notFilterable();
        }
        this.taxaToRemove = taxaToRemove;
        return this;
    }

    public PhenotypeBuilder keepAttributes(List<PhenotypeAttribute> attributesToKeep) {
        if (!this.isFilterable) {
            this.notFilterable();
        }
        this.attributeList = attributesToKeep;
        return this;
    }

    public PhenotypeBuilder keepAttributes(int[] indexOfAttributes) {
        if (!this.isFilterable) {
            this.notFilterable();
        }
        this.indexOfAttributesToKeep = indexOfAttributes;
        return this;
    }

    public PhenotypeBuilder changeAttributeType(int attributeIndex, Phenotype.ATTRIBUTE_TYPE type) {
        if (!this.isFilterable) {
            this.notFilterable();
        }
        this.attributeChangeMap.put(type, attributeIndex);
        return this;
    }

    public PhenotypeBuilder typesOfRetainedAttributes(List<Phenotype.ATTRIBUTE_TYPE> attributeTypes) {
        if (!this.isFilterable) {
            this.notFilterable();
        }
        this.attributeTypeList = attributeTypes;
        return this;
    }

    public Phenotype build() {
        if (this.source == SOURCE_TYPE.file) {
            try {
                File phenotypeFile = new File(this.filename);
                BufferedReader br = new BufferedReader(new FileReader(phenotypeFile));
                String topline = br.readLine();
                if (this.phenotypeName.equals("Phenotype")) {
                    this.phenotypeName = new File(this.filename).getName();
                    if (this.phenotypeName.endsWith(".txt")) {
                        this.phenotypeName = this.phenotypeName.substring(0, this.phenotypeName.length() - 4);
                    }
                }
                Phenotype myPhenotype = topline.toLowerCase().startsWith("<phenotype") ? this.importPhenotypeFile(phenotypeFile) : this.importTraits(phenotypeFile);
                br.close();
                return myPhenotype;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.source == SOURCE_TYPE.phenotype) {
            return this.filterBasePhenotype();
        }
        if (this.source == SOURCE_TYPE.list) {
            return this.createPhenotypeFromLists();
        }
        if (this.source == SOURCE_TYPE.join) {
            return this.joinPhenotypes();
        }
        return null;
    }

    private void notFilterable() {
        throw new IllegalStateException("Phenotype Builder error: applied a filter method to a non-filterable builder.");
    }

    private Phenotype importPhenotypeFile(File phenotypeFile) throws IOException {
        String inputStr;
        Pattern whiteSpace = Pattern.compile("\\s+");
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        phenotypeReader.readLine();
        String[] typeString = whiteSpace.split(phenotypeReader.readLine());
        String[] phenoNames = whiteSpace.split(phenotypeReader.readLine());
        int nPheno = typeString.length;
        ArrayList<String[]> stringData = new ArrayList<String[]>();
        while ((inputStr = phenotypeReader.readLine()) != null) {
            stringData.add(whiteSpace.split(inputStr));
        }
        int nObs = stringData.size();
        for (int pheno = 0; pheno < nPheno; ++pheno) {
            if (typeString[pheno].toLowerCase().startsWith("cov") || typeString[pheno].toLowerCase().startsWith("dat")) {
                float[] dataArray = new float[nObs];
                OpenBitSet missing = new OpenBitSet(nObs);
                int obsCount = 0;
                for (String[] inputLine : stringData) {
                    try {
                        dataArray[obsCount] = Float.parseFloat(inputLine[pheno]);
                    }
                    catch (NumberFormatException nfe) {
                        dataArray[obsCount] = Float.NaN;
                        missing.fastSet(obsCount);
                    }
                    ++obsCount;
                }
                attributes.add(new NumericAttribute(phenoNames[pheno], dataArray, missing));
                if (typeString[pheno].toLowerCase().startsWith("cov")) {
                    types.add(Phenotype.ATTRIBUTE_TYPE.covariate);
                    continue;
                }
                types.add(Phenotype.ATTRIBUTE_TYPE.data);
                continue;
            }
            if (typeString[pheno].toLowerCase().startsWith("tax")) {
                ArrayList<Taxon> taxa = new ArrayList<Taxon>();
                for (String[] inputLine : stringData) {
                    taxa.add(new Taxon(inputLine[pheno]));
                }
                attributes.add(new TaxaAttribute(taxa, phenoNames[pheno]));
                types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
                continue;
            }
            if (!typeString[pheno].toLowerCase().startsWith("fac")) continue;
            String[] labelArray = new String[nObs];
            int obsCount = 0;
            for (String[] inputLine : stringData) {
                labelArray[obsCount++] = inputLine[pheno];
            }
            attributes.add(new CategoricalAttribute(phenoNames[pheno], labelArray));
            types.add(Phenotype.ATTRIBUTE_TYPE.factor);
        }
        phenotypeReader.close();
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private Phenotype importTraits(File phenotypeFile) throws IOException {
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        int numberOfDataLines = 0;
        String inputline = phenotypeReader.readLine();
        ArrayList<String> headerLines = new ArrayList<String>();
        boolean isFactor = false;
        boolean isCovariate = false;
        boolean hasHeaders = false;
        boolean isTrait = false;
        String[] traitnames = new String[]{};
        while (inputline != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                ++numberOfDataLines;
            } else if (inputline.toLowerCase().startsWith("<trai")) {
                isTrait = true;
                String[] splitLine = inputline.split("[<>\\s]+");
                traitnames = Arrays.copyOfRange(splitLine, 2, splitLine.length);
            } else if (inputline.toLowerCase().startsWith("<cov")) {
                isCovariate = true;
            } else if (inputline.toLowerCase().startsWith("<fac")) {
                isFactor = true;
            } else if (inputline.toLowerCase().startsWith("<head")) {
                hasHeaders = true;
                headerLines.add(inputline);
            }
            inputline = phenotypeReader.readLine();
        }
        phenotypeReader.close();
        if (hasHeaders) {
            this.processTraitsAndFactors(phenotypeFile, traitnames, numberOfDataLines, isCovariate, headerLines);
        } else {
            if (isFactor) {
                return this.processFactors(phenotypeFile, traitnames, numberOfDataLines);
            }
            if (isTrait) {
                return this.processTraits(phenotypeFile, traitnames, numberOfDataLines, isCovariate);
            }
        }
        throw new IllegalArgumentException("Unrecognized format for a phenotype.");
    }

    private Phenotype processTraits(File phenotypeFile, String[] traitnames, int numberOfDataLines, boolean isCovariate) throws IOException {
        String inputline;
        int ntraits = traitnames.length;
        int nattributes = ntraits + 1;
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(nattributes);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(nattributes);
        ArrayList<float[]> traitValues = new ArrayList<float[]>(ntraits);
        ArrayList<OpenBitSet> missingList = new ArrayList<OpenBitSet>(ntraits);
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        Phenotype.ATTRIBUTE_TYPE myAttributeType = isCovariate ? Phenotype.ATTRIBUTE_TYPE.covariate : Phenotype.ATTRIBUTE_TYPE.data;
        for (int i = 0; i < ntraits; ++i) {
            traitValues.add(new float[numberOfDataLines]);
            missingList.add(new OpenBitSet(numberOfDataLines));
            types.add(myAttributeType);
        }
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        int dataCount = 0;
        int lineCount = 1;
        while ((inputline = phenotypeReader.readLine()) != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                String[] values = inputline.split("\\s+");
                if (values.length != ntraits + 1) {
                    String msg = String.format("Incorrect number of values in line %d of %s", lineCount, phenotypeFile.getName());
                    phenotypeReader.close();
                    throw new IllegalArgumentException(msg);
                }
                taxaList.add(new Taxon(values[0]));
                for (int i = 0; i < ntraits; ++i) {
                    float val;
                    try {
                        val = Float.parseFloat(values[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        val = Float.NaN;
                        ((BitSet)missingList.get(i)).fastSet(dataCount);
                    }
                    ((float[])traitValues.get((int)i))[dataCount] = val;
                }
                ++dataCount;
            }
            ++lineCount;
        }
        phenotypeReader.close();
        attributes.add(new TaxaAttribute(taxaList));
        for (int i = 0; i < ntraits; ++i) {
            attributes.add(new NumericAttribute(traitnames[i], (float[])traitValues.get(i), (BitSet)missingList.get(i)));
        }
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private Phenotype processFactors(File phenotypeFile, String[] traitnames, int numberOfDataLines) throws IOException {
        String inputline;
        int ntraits = traitnames.length;
        int nattributes = ntraits + 1;
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(nattributes);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(nattributes);
        ArrayList<String[]> traitValues = new ArrayList<String[]>(ntraits);
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>();
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        Phenotype.ATTRIBUTE_TYPE myAttributeType = Phenotype.ATTRIBUTE_TYPE.factor;
        for (int i = 0; i < ntraits; ++i) {
            traitValues.add(new String[numberOfDataLines]);
            types.add(myAttributeType);
        }
        BufferedReader phenotypeReader = new BufferedReader(new FileReader(phenotypeFile));
        int dataCount = 0;
        int lineCount = 1;
        while ((inputline = phenotypeReader.readLine()) != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                String[] values = inputline.split("\\s+");
                if (values.length != ntraits + 1) {
                    String msg = String.format("Incorrect number of values in line %d of %s", lineCount, phenotypeFile.getName());
                    phenotypeReader.close();
                    throw new IllegalArgumentException(msg);
                }
                taxaList.add(new Taxon(values[0]));
                for (int i = 0; i < ntraits; ++i) {
                    ((String[])traitValues.get((int)i))[dataCount] = values[i + 1];
                }
                ++dataCount;
            }
            ++lineCount;
        }
        phenotypeReader.close();
        attributes.add(new TaxaAttribute(taxaList));
        for (int i = 0; i < ntraits; ++i) {
            attributes.add(new CategoricalAttribute(traitnames[i], (String[])traitValues.get(i)));
        }
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private void processHeader(String headerLine, Map<String, ArrayList<String>> headerMap) {
        ArrayList<String> values;
        String name;
        String[] header = headerLine.split("[<>=\\s]+");
        if (header[1].toLowerCase().equals("header") && header[2].toLowerCase().equals("name")) {
            name = header[3];
            values = new ArrayList<String>();
            for (int i = 4; i < header.length; ++i) {
                values.add(header[i]);
            }
        } else {
            throw new IllegalArgumentException("Improperly formatted Header: " + headerLine);
        }
        headerMap.put(name, values);
    }

    private Phenotype processTraitsAndFactors(File phenotypeFile, String[] traitnames, int numberOfDataLines, boolean isCovariate, ArrayList<String> headerList) throws IOException {
        int i;
        String inputline;
        int i2;
        TreeSet<String> traitSet = new TreeSet<String>();
        for (String trait : traitnames) {
            traitSet.add(trait);
        }
        HashMap<String, Integer> traitMap = new HashMap<String, Integer>();
        int traitCount = 0;
        for (String trait : traitSet) {
            traitMap.put(trait, traitCount++);
        }
        int ntraitnames = traitnames.length;
        int ntraits = traitSet.size();
        int nfactors = headerList.size();
        String[] factorNames = new String[nfactors];
        String[] splitHeader = headerList.get(0).split("[<>=\\s]+");
        factorNames[0] = splitHeader[3];
        String[] factorValues = Arrays.copyOfRange(splitHeader, 4, splitHeader.length);
        for (int i3 = 1; i3 < nfactors; ++i3) {
            splitHeader = headerList.get(i3).split("[<>=\\s]+");
            factorNames[i3] = splitHeader[3].replace("|", ":");
            for (int j = 0; j < factorValues.length; ++j) {
                int n = j;
                factorValues[n] = factorValues[n] + "|" + splitHeader[j + 4].replace("|", ":");
            }
        }
        TreeSet<String> factorSet = new TreeSet<String>();
        for (String val : factorValues) {
            factorSet.add(val);
        }
        int nCompositeFactors = factorSet.size();
        HashMap<String, Integer> factorMap = new HashMap<String, Integer>();
        int factorCount = 0;
        for (String factor : factorSet) {
            factorMap.put(factor, factorCount++);
        }
        int ndata = numberOfDataLines * nCompositeFactors;
        ArrayList<String[]> factorAttributeArrays = new ArrayList<String[]>(nfactors);
        for (int i4 = 0; i4 < nfactors; ++i4) {
            factorAttributeArrays.add(new String[ndata]);
        }
        int fromIndex = 0;
        int toIndex = numberOfDataLines;
        for (String factor : factorSet) {
            String[] subFactor = factor.split("|");
            for (i2 = 0; i2 < nfactors; ++i2) {
                Arrays.fill((Object[])factorAttributeArrays.get(i2), fromIndex, toIndex, subFactor[i2]);
            }
            fromIndex += numberOfDataLines;
            toIndex += numberOfDataLines;
        }
        ArrayList<float[]> traitAttributeArrays = new ArrayList<float[]>();
        ArrayList<OpenBitSet> missingList = new ArrayList<OpenBitSet>();
        ArrayList<Taxon> tempTaxa = new ArrayList<Taxon>();
        for (i2 = 0; i2 < ntraits; ++i2) {
            float[] traitArray = new float[ndata];
            Arrays.fill(traitArray, Float.NaN);
            traitAttributeArrays.add(traitArray);
            missingList.add(new OpenBitSet(ndata));
        }
        BufferedReader br = new BufferedReader(new FileReader(phenotypeFile));
        int dataCount = 0;
        int lineCount = 1;
        while ((inputline = br.readLine()) != null) {
            if ((inputline = inputline.trim()).length() > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                String[] values = inputline.split("\\s+");
                if (values.length != ntraitnames + 1) {
                    String msg = String.format("Incorrect number of values in line %d of %s", lineCount, phenotypeFile.getName());
                    br.close();
                    throw new IllegalArgumentException(msg);
                }
                tempTaxa.add(new Taxon(values[0]));
                for (i = 0; i < ntraitnames; ++i) {
                    float val;
                    int traitnum = (Integer)traitMap.get(traitnames[i]);
                    int factornum = (Integer)factorMap.get(factorValues[i]);
                    int dataIndex = factornum * numberOfDataLines + dataCount;
                    try {
                        val = Float.parseFloat(values[i + 1]);
                    }
                    catch (NumberFormatException e) {
                        val = Float.NaN;
                        ((BitSet)missingList.get(traitnum)).fastSet(dataIndex);
                    }
                    ((float[])traitAttributeArrays.get((int)traitnum))[dataIndex] = val;
                }
                ++dataCount;
            }
            ++lineCount;
        }
        br.close();
        ArrayList<Taxon> taxaList = new ArrayList<Taxon>(ndata);
        for (i = 0; i < nCompositeFactors; ++i) {
            taxaList.addAll(tempTaxa);
        }
        Phenotype.ATTRIBUTE_TYPE myAttributeType = isCovariate ? Phenotype.ATTRIBUTE_TYPE.covariate : Phenotype.ATTRIBUTE_TYPE.data;
        ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>(nfactors + ntraits);
        ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>(nfactors + ntraits);
        attributes.add(new TaxaAttribute(taxaList));
        types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (int i5 = 0; i5 < nfactors; ++i5) {
            attributes.add(new CategoricalAttribute(factorNames[i5], (String[])factorAttributeArrays.get(i5)));
            types.add(Phenotype.ATTRIBUTE_TYPE.factor);
        }
        traitCount = 0;
        for (String trait : traitSet) {
            attributes.add(new NumericAttribute(trait, (float[])traitAttributeArrays.get(traitCount), (BitSet)missingList.get(traitCount)));
            types.add(myAttributeType);
            ++traitCount;
        }
        return new CorePhenotype(attributes, types, this.phenotypeName);
    }

    private Phenotype filterBasePhenotype() {
        return null;
    }

    private Phenotype createPhenotypeFromLists() {
        if (this.attributeList.size() != this.attributeTypeList.size()) {
            throw new IllegalArgumentException("Error building Phenotype: attribute list size not equal to type list size.");
        }
        Iterator<Phenotype.ATTRIBUTE_TYPE> typeIter = this.attributeTypeList.iterator();
        for (PhenotypeAttribute attr : this.attributeList) {
            Phenotype.ATTRIBUTE_TYPE type;
            if (attr.isTypeCompatible(type = typeIter.next())) continue;
            throw new IllegalArgumentException("Error building Phenotype: types not compatible with attributes.");
        }
        return new CorePhenotype(this.attributeList, this.attributeTypeList, this.phenotypeName);
    }

    private Phenotype joinPhenotypes() {
        return null;
    }

    private static enum SOURCE_TYPE {
        file,
        phenotype,
        list,
        join;

    }
}

