/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GeneratePluginCode {
    private static final Logger myLogger = Logger.getLogger(GeneratePluginCode.class);
    private static final int DEFAULT_DESCRIPTION_LINE_LENGTH = 50;

    private GeneratePluginCode() {
    }

    public static void generate(Class currentMatch) {
        try {
            Constructor constructor = currentMatch.getConstructor(Frame.class);
            GeneratePluginCode.generate((AbstractPlugin)constructor.newInstance(new Object[]{null}));
        }
        catch (Exception ex) {
            try {
                Constructor constructor = currentMatch.getConstructor(Frame.class, Boolean.TYPE);
                GeneratePluginCode.generate((AbstractPlugin)constructor.newInstance(null, false));
            }
            catch (NoSuchMethodException nsme) {
                myLogger.warn((Object)("Self-describing Plugins should implement this constructor: " + currentMatch.getClass().getName()));
                myLogger.warn((Object)"public Plugin(Frame parentFrame, boolean isInteractive) {");
                myLogger.warn((Object)"   super(parentFrame, isInteractive);");
                myLogger.warn((Object)"}");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void generate(AbstractPlugin plugin) {
        String clazz = Utils.getBasename(plugin.getClass().getName());
        System.out.println("    // The following getters and setters were auto-generated.");
        System.out.println("    // Please use this method to re-generate.");
        System.out.println("    //");
        System.out.println("    // public static void main(String[] args) {");
        System.out.println("    //     GeneratePluginCode.generate(" + clazz + ".class);");
        System.out.println("    // }");
        System.out.println("");
        for (Field field : plugin.getParameterFields()) {
            PluginParameter current = null;
            try {
                current = (PluginParameter)field.get(plugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            String guiNameAsCamelCase = GeneratePluginCode.stringToCamelCase(current.guiName());
            System.out.println("    /**");
            System.out.println(GeneratePluginCode.createDescription(current.description()));
            System.out.println("     *");
            System.out.println("     * @return " + current.guiName());
            System.out.println("     */");
            System.out.println("    public " + current.valueType().getSimpleName() + " " + guiNameAsCamelCase + "() {");
            System.out.println("        return " + field.getName() + ".value();");
            System.out.println("    }\n");
            System.out.println("    /**");
            System.out.println(GeneratePluginCode.createDescription("Set " + current.guiName() + ". " + current.description()));
            System.out.println("     *");
            System.out.println("     * @param value " + current.guiName());
            System.out.println("     *");
            System.out.println("     * @return this plugin");
            System.out.println("     */");
            System.out.println("    public " + clazz + " " + guiNameAsCamelCase + "(" + current.valueType().getSimpleName() + " value) {");
            System.out.println("        " + field.getName() + " = new PluginParameter<>(" + field.getName() + ", value);");
            System.out.println("        return this;");
            System.out.println("    }\n");
        }
    }

    private static String createDescription(String description) {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("     * ");
        int n = description.length();
        for (int i = 0; i < n; ++i) {
            ++count;
            if (description.charAt(i) == '\n') {
                builder.append("\n");
                builder.append("     * ");
                count = 0;
                continue;
            }
            if (count > 50 && description.charAt(i) == ' ') {
                builder.append("\n");
                builder.append("     * ");
                count = 0;
                continue;
            }
            builder.append(description.charAt(i));
        }
        return builder.toString();
    }

    private static String stringToCamelCase(String str) {
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toLowerCase(str.charAt(0)));
        boolean makeUpper = false;
        for (int i = 1; i < str.length(); ++i) {
            char current = str.charAt(i);
            if (current == ' ') {
                makeUpper = true;
                continue;
            }
            if (makeUpper) {
                builder.append(Character.toUpperCase(current));
                makeUpper = false;
                continue;
            }
            builder.append(current);
        }
        return builder.toString();
    }
}

