/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.SplitSystem;
import net.maizegenetics.taxa.tree.Tree;
import net.maizegenetics.taxa.tree.TreeUtils;

public class SplitUtils {
    public static SplitSystem getSplits(TaxaList idGroup, Tree tree) {
        int size = tree.getInternalNodeCount() - 1;
        SplitSystem splitSystem = new SplitSystem(idGroup, size);
        boolean[][] splits = splitSystem.getSplitVector();
        for (int i = 0; i < size; ++i) {
            SplitUtils.getSplit(idGroup, tree.getInternalNode(i), splits[i]);
        }
        return splitSystem;
    }

    public static SplitSystem getSplits(Tree tree) {
        TaxaList idGroup = TreeUtils.getLeafIdGroup(tree);
        return SplitUtils.getSplits(idGroup, tree);
    }

    public static void getSplit(TaxaList idGroup, Node internalNode, boolean[] split) {
        int i;
        if (internalNode.isLeaf() || internalNode.isRoot()) {
            throw new IllegalArgumentException("Only internal nodes (and no root) nodes allowed");
        }
        for (i = 0; i < split.length; ++i) {
            split[i] = false;
        }
        for (i = 0; i < internalNode.getChildCount(); ++i) {
            SplitUtils.markNode(idGroup, internalNode, split);
        }
        if (!split[0]) {
            for (i = 0; i < split.length; ++i) {
                split[i] = !split[i];
            }
        }
    }

    public static boolean isSame(boolean[] s1, boolean[] s2) {
        boolean reverse = s1[0] != s2[0];
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Splits must be of the same length!");
        }
        for (int i = 0; i < s1.length; ++i) {
            if (!(reverse ? s1[i] == s2[i] : s1[i] != s2[i])) continue;
            return false;
        }
        return true;
    }

    static void markNode(TaxaList idGroup, Node node, boolean[] split) {
        if (node.isLeaf()) {
            String name = node.getIdentifier().getName();
            int index = idGroup.indexOf(name);
            if (index < 0) {
                throw new IllegalArgumentException("INCOMPATIBLE IDENTIFIER (" + name + ")");
            }
            split[index] = true;
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                SplitUtils.markNode(idGroup, node.getChild(i), split);
            }
        }
    }
}

