/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import net.maizegenetics.util.TableReport;

public abstract class AbstractTableReport
implements TableReport {
    private int currentRowNumber = -1;
    private Object[] currentRow = null;

    @Override
    public Object[][] getTableData() {
        return this.getTableData(0, this.getRowCount() - 1);
    }

    @Override
    public Object[][] getTableData(int start, int end) {
        if (start < 0 || end >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("getTableData: start: " + start + "  end: " + end);
        }
        if (end < start) {
            return null;
        }
        Object[][] temp = new Object[end - start + 1][];
        for (int i = start; i <= end; ++i) {
            temp[i] = this.getRow(i);
        }
        return temp;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row != this.currentRowNumber) {
            this.currentRowNumber = row;
            this.currentRow = this.getRow(row);
        }
        return this.currentRow[col];
    }
}

