/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

public class VCFUtil {
    private static double error = 0.001;
    private static double v1 = Math.log10(1.0 - error * 3.0 / 4.0);
    private static double v2 = Math.log10(error / 4.0);
    private static double v3 = Math.log10(0.5 - error / 4.0);
    private static int[][][] myGenoScoreMap = new int[128][128][];
    public static final int VCF_DEFAULT_MAX_NUM_ALLELES = 3;

    private VCFUtil() {
    }

    public static int[] getScore(int i, int j) {
        if (i > 127 || j > 127) {
            return VCFUtil.calcScore(i, j);
        }
        return myGenoScoreMap[i][j];
    }

    private static int[] calcScore(int a, int b) {
        int[] results = new int[4];
        int n = a + b;
        int m = a;
        if (b > m) {
            m = b;
        }
        double fact = 0.0;
        if (n > m) {
            int i;
            for (i = n; i > m; --i) {
                fact += Math.log10(i);
            }
            for (i = 1; i <= n - m; ++i) {
                fact -= Math.log10(i);
            }
        }
        double aad = Math.pow(10.0, fact + (double)a * v1 + (double)b * v2);
        double abd = Math.pow(10.0, fact + (double)n * v3);
        double bbd = Math.pow(10.0, fact + (double)b * v1 + (double)a * v2);
        double md = aad;
        if (md < abd) {
            md = abd;
        }
        if (md < bbd) {
            md = bbd;
        }
        int gq = 0;
        if (aad + abd + bbd > 0.0) {
            gq = (int)(md / (aad + abd + bbd) * 100.0);
        }
        int aa = (int)(-10.0 * (fact + (double)a * v1 + (double)b * v2));
        int ab = (int)(-10.0 * (fact + (double)n * v3));
        int bb = (int)(-10.0 * (fact + (double)b * v1 + (double)a * v2));
        m = aa;
        if (m > ab) {
            m = ab;
        }
        if (m > bb) {
            m = bb;
        }
        results[0] = (aa -= m) > 255 ? 255 : aa;
        results[1] = ab > 255 ? 255 : (ab -= m);
        results[2] = bb > 255 ? 255 : (bb -= m);
        results[3] = gq;
        return results;
    }

    public static byte resolveVCFGeno(byte[] alleles, int[][] allelesInTaxa, int tx) {
        int[] alleleDepth = new int[allelesInTaxa.length];
        for (int i = 0; i < allelesInTaxa.length; ++i) {
            alleleDepth[i] = allelesInTaxa[i][tx];
        }
        return VCFUtil.resolveVCFGeno(alleles, alleleDepth);
    }

    public static byte resolveVCFGeno(byte[] alleles, int[] alleleDepth) {
        int depth = 0;
        for (int i = 0; i < alleleDepth.length; ++i) {
            depth += alleleDepth[i];
        }
        if (depth == 0) {
            return -1;
        }
        int max = 0;
        int maxAllele = 15;
        int nextMax = 0;
        int nextMaxAllele = 15;
        for (int i = 0; i < alleles.length; ++i) {
            if (alleleDepth[i] > max) {
                nextMax = max;
                nextMaxAllele = maxAllele;
                max = alleleDepth[i];
                maxAllele = alleles[i];
                continue;
            }
            if (alleleDepth[i] <= nextMax) continue;
            nextMax = alleleDepth[i];
            nextMaxAllele = alleles[i];
        }
        if (alleles.length == 1) {
            return (byte)(alleles[0] << 4 | alleles[0]);
        }
        int[] scores = VCFUtil.getScore(max = max > 127 ? 127 : max, nextMax = nextMax > 127 ? 127 : nextMax);
        if (scores[1] <= scores[0] && scores[1] <= scores[2]) {
            return (byte)(maxAllele << 4 | nextMaxAllele);
        }
        if (scores[0] <= scores[1] && scores[0] <= scores[2]) {
            return (byte)(maxAllele << 4 | maxAllele);
        }
        return (byte)(nextMaxAllele << 4 | nextMaxAllele);
    }

    static {
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                VCFUtil.myGenoScoreMap[i][j] = VCFUtil.calcScore(i, j);
            }
        }
    }
}

