/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

import com.sun.xml.parser.ContentModel;
import com.sun.xml.parser.EndOfInputException;

class ContentModelState {
    private ContentModel model;
    private boolean sawOne;
    private ContentModelState next;

    ContentModelState(ContentModel model) {
        this(model, null);
    }

    private ContentModelState(Object content, ContentModelState next) {
        this.model = (ContentModel)content;
        this.next = next;
        this.sawOne = false;
    }

    ContentModelState advance(String token) throws EndOfInputException {
        switch (this.model.type) {
            case '*': 
            case '+': {
                if (this.model.first(token)) {
                    this.sawOne = true;
                    if (this.model.content instanceof String) {
                        return this;
                    }
                    return new ContentModelState(this.model.content, this).advance(token);
                }
                if (this.model.type != '*' && !this.sawOne || this.next == null) break;
                return this.next.advance(token);
            }
            case '?': {
                if (this.model.first(token)) {
                    if (this.model.content instanceof String) {
                        return this.next;
                    }
                    return new ContentModelState(this.model.content, this.next).advance(token);
                }
                if (this.next == null) break;
                return this.next.advance(token);
            }
            case '|': {
                ContentModel m = this.model;
                while (m != null) {
                    if (m.content instanceof String) {
                        if (token == m.content) {
                            return this.next;
                        }
                    } else if (((ContentModel)m.content).first(token)) {
                        return new ContentModelState(m.content, this.next).advance(token);
                    }
                    m = m.next;
                }
                if (!this.model.empty()) break;
                return this.next.advance(token);
            }
            case ',': {
                if (this.model.first(token)) {
                    ContentModelState nextState;
                    if (this.model.type == '\u0000') {
                        return this.next;
                    }
                    if (this.model.next == null) {
                        nextState = new ContentModelState(this.model.content, this.next);
                    } else {
                        nextState = new ContentModelState(this.model.content, this);
                        this.model = this.model.next;
                    }
                    return nextState.advance(token);
                }
                if (!this.model.empty()) break;
                return this.next.advance(token);
            }
            case '\u0000': {
                if (this.model.content != token) break;
                return this.next;
            }
        }
        throw new EndOfInputException();
    }

    boolean terminate() {
        switch (this.model.type) {
            case '+': {
                if (!this.sawOne && !this.model.empty()) {
                    return false;
                }
            }
            case '*': 
            case '?': {
                return this.next == null || this.next.terminate();
            }
            case '|': {
                return this.model.empty() && (this.next == null || this.next.terminate());
            }
            case ',': {
                ContentModel m = this.model;
                while (m != null && m.empty()) {
                    m = m.next;
                }
                if (m != null) {
                    return false;
                }
                return this.next == null || this.next.terminate();
            }
            case '\u0000': {
                return false;
            }
        }
        throw new InternalError();
    }
}

