/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.lang.reflect.Field;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5CompoundMemberByteifyerDateFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerDateFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            return (clazz == Date.class || Long.class.isAssignableFrom(clazz)) && memberInfoOrNull.getType().isTimeStamp();
        }
        return clazz == Date.class;
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        if (dataClass == HDF5DataClass.INTEGER && rank == 0 && elementSize == 8 && typeVariantOrNull == HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH) {
            return Date.class;
        }
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType enumTypeOrNull, Class<?> memberClazz, int index, int offset, HDF5ValueObjectByteifyer.FileInfoProvider fileInfoProvider) {
        String memberName = member.getMemberName();
        HDF5DataTypeVariant typeVariant = HDF5DataTypeVariant.isTypeVariant(member.tryGetTypeVariant()) ? member.tryGetTypeVariant() : HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH;
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, offset, typeVariant);
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, typeVariant);
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, typeVariant);
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, typeVariant);
            }
        }
        throw new Error("Unknown access type");
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, int offset, HDF5DataTypeVariant typeVariant) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5MemberByteifyer(field, memberName, 8, offset, typeVariant){

            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                return HDFNativeData.longToByte(((Date)field.get(obj)).getTime());
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                field.set(obj, new Date(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset)));
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 8, offset, typeVariant){

            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object dateObj = HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                if (dateObj instanceof Date) {
                    return HDFNativeData.longToByte(((Date)dateObj).getTime());
                }
                return HDFNativeData.longToByte((Long)dateObj);
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                HDF5CompoundByteifyerFactory.putMap(obj, memberName, new Date(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset)));
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final int index, int offset, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 8, offset, typeVariant){

            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object dateObj = HDF5CompoundByteifyerFactory.getList(obj, index);
                if (dateObj instanceof Date) {
                    return HDFNativeData.longToByte(((Date)dateObj).getTime());
                }
                return HDFNativeData.longToByte((Long)dateObj);
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                HDF5CompoundByteifyerFactory.setList(obj, index, new Date(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset)));
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final int index, int offset, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 8, offset, typeVariant){

            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object dateObj = HDF5CompoundByteifyerFactory.getArray(obj, index);
                if (dateObj instanceof Date) {
                    return HDFNativeData.longToByte(((Date)dateObj).getTime());
                }
                return HDFNativeData.longToByte((Long)dateObj);
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                HDF5CompoundByteifyerFactory.setArray(obj, index, new Date(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offset)));
            }
        };
    }
}

