/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.StringUtils;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5CompoundMemberByteifyerStringFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerStringFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            return (clazz == String.class || clazz == char[].class) && memberInfoOrNull.getType().getDataClass() == HDF5DataClass.STRING;
        }
        return clazz == String.class || clazz == char[].class;
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType enumTypeOrNull, Class<?> memberClazz, int index, int offset, HDF5ValueObjectByteifyer.FileInfoProvider fileInfoProvider) {
        String memberName = member.getMemberName();
        int memberTypeId = member.getStorageDataTypeId();
        int maxLengthChars = member.getMemberTypeLength();
        int maxLengthBytes = compoundMemberInfoOrNull != null ? compoundMemberInfoOrNull.getType().getSize() : (fileInfoProvider.getCharacterEncoding() == CharacterEncoding.UTF8 ? 2 : 1) * (memberTypeId < 0 ? maxLengthChars + 1 : maxLengthChars);
        int stringDataTypeId = memberTypeId < 0 ? fileInfoProvider.getStringDataTypeId(maxLengthBytes) : memberTypeId;
        boolean isCharArray = memberClazz == char[].class;
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, offset, stringDataTypeId, maxLengthChars, maxLengthBytes, fileInfoProvider.getCharacterEncoding(), isCharArray);
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, stringDataTypeId, maxLengthChars, maxLengthBytes, fileInfoProvider.getCharacterEncoding(), isCharArray);
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, stringDataTypeId, maxLengthChars, maxLengthBytes, fileInfoProvider.getCharacterEncoding(), isCharArray);
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, stringDataTypeId, maxLengthChars, maxLengthBytes, fileInfoProvider.getCharacterEncoding(), isCharArray);
            }
        }
        throw new Error("Unknown access type");
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, int offset, final int stringDataTypeId, int maxLength, int maxLengthInBytes, CharacterEncoding encoding, boolean isCharArray) {
        ReflectionUtils.ensureAccessible(field);
        if (isCharArray) {
            return new HDF5MemberByteifyer(field, memberName, maxLength, maxLengthInBytes, offset, encoding){

                protected int getMemberStorageTypeId() {
                    return stringDataTypeId;
                }

                protected int getMemberNativeTypeId() {
                    return -1;
                }

                public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                    String s = new String((char[])field.get(obj));
                    return StringUtils.toBytes0Term(s, this.getSize(), this.encoding);
                }

                public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                    int totalOffset = arrayOffset + this.offset;
                    int maxIdx = totalOffset + this.size;
                    field.set(obj, StringUtils.fromBytes0Term(byteArr, totalOffset, maxIdx, this.encoding).toCharArray());
                }
            };
        }
        return new HDF5MemberByteifyer(field, memberName, maxLength, maxLengthInBytes, offset, encoding){

            protected int getMemberStorageTypeId() {
                return stringDataTypeId;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object o = field.get(obj);
                if (o == null) {
                    throw new NullPointerException("Field '" + field.getName() + "' is null");
                }
                String s = o.toString();
                return StringUtils.toBytes0Term(s, this.getSize(), this.encoding);
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offset;
                int maxIdx = totalOffset + this.size;
                field.set(obj, StringUtils.fromBytes0Term(byteArr, totalOffset, maxIdx, this.encoding));
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, final int stringDataTypeId, int maxLength, int maxLengthInBytes, CharacterEncoding encoding, final boolean isCharArray) {
        return new HDF5MemberByteifyer(null, memberName, maxLength, maxLengthInBytes, offset, encoding){

            protected int getMemberStorageTypeId() {
                return stringDataTypeId;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object o = HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                String s = o.getClass() == char[].class ? new String((char[])o) : o.toString();
                return StringUtils.toBytes0Term(s, this.getSize(), this.encoding);
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offset;
                int maxIdx = totalOffset + this.size;
                String s = StringUtils.fromBytes0Term(byteArr, totalOffset, maxIdx, this.encoding);
                if (isCharArray) {
                    HDF5CompoundByteifyerFactory.putMap(obj, memberName, s.toCharArray());
                } else {
                    HDF5CompoundByteifyerFactory.putMap(obj, memberName, s);
                }
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final int index, int offset, final int stringDataTypeId, int maxLength, int maxLengthInBytes, CharacterEncoding encoding, final boolean isCharArray) {
        return new HDF5MemberByteifyer(null, memberName, maxLength, maxLengthInBytes, offset, encoding){

            protected int getMemberStorageTypeId() {
                return stringDataTypeId;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object o = HDF5CompoundByteifyerFactory.getList(obj, index);
                String s = o.getClass() == char[].class ? new String((char[])o) : o.toString();
                return StringUtils.toBytes0Term(s, this.getSize(), this.encoding);
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offset;
                int maxIdx = totalOffset + this.size;
                String s = StringUtils.fromBytes0Term(byteArr, totalOffset, maxIdx, this.encoding);
                if (isCharArray) {
                    HDF5CompoundByteifyerFactory.setList(obj, index, s.toCharArray());
                } else {
                    HDF5CompoundByteifyerFactory.setList(obj, index, s);
                }
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final int index, int offset, final int stringDataTypeId, int maxLength, int maxLengthInBytes, CharacterEncoding encoding, final boolean isCharArray) {
        return new HDF5MemberByteifyer(null, memberName, maxLength, maxLengthInBytes, offset, encoding){

            protected int getMemberStorageTypeId() {
                return stringDataTypeId;
            }

            protected int getMemberNativeTypeId() {
                return -1;
            }

            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object o = HDF5CompoundByteifyerFactory.getArray(obj, index);
                String s = o.getClass() == char[].class ? new String((char[])o) : o.toString();
                return StringUtils.toBytes0Term(s, this.getSize(), this.encoding);
            }

            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                int totalOffset = arrayOffset + this.offset;
                int maxIdx = totalOffset + this.size;
                String s = StringUtils.fromBytes0Term(byteArr, totalOffset, maxIdx, this.encoding);
                if (isCharArray) {
                    HDF5CompoundByteifyerFactory.setArray(obj, index, s.toCharArray());
                } else {
                    HDF5CompoundByteifyerFactory.setArray(obj, index, s);
                }
            }
        };
    }
}

