/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.CompoundElement;
import ch.systemsx.cisd.hdf5.CompoundType;
import ch.systemsx.cisd.hdf5.HDF5CompoundMappingHints;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5EnumTypeRetriever;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HDF5CompoundMemberMapping {
    private final String memberName;
    private final int storageDataTypeId;
    private final Field fieldOrNull;
    private String fieldName;
    private Class<?> memberClassOrNull;
    private String enumTypeName;
    private int memberTypeLength;
    private int[] memberTypeDimensions;
    private HDF5EnumerationType enumTypeOrNull;
    private HDF5DataTypeVariant typeVariantOrNull;
    private HDF5CompoundMappingHints hintsOrNull;
    private static final IdentityHashMap<Class, HDF5DataTypeVariant> typeVariantMap = new IdentityHashMap();

    static {
        typeVariantMap.put(Date.class, HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH);
        typeVariantMap.put(HDF5TimeDuration.class, HDF5DataTypeVariant.TIME_DURATION_MICROSECONDS);
    }

    public static HDF5CompoundMemberMapping mapping(String memberName) {
        return new HDF5CompoundMemberMapping(memberName, null, memberName, null, new int[0]);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, String memberName) {
        return new HDF5CompoundMemberMapping(fieldName, null, memberName, null, new int[0]);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, int memberTypeLength) {
        return new HDF5CompoundMemberMapping(fieldName, null, fieldName, null, new int[]{memberTypeLength});
    }

    static HDF5CompoundMemberMapping mappingArrayWithStorageId(String fieldName, String memberName, Class<?> memberClass, int[] memberDimensions, int storageDataTypeId, HDF5DataTypeVariant typeVariantOrNull) {
        return new HDF5CompoundMemberMapping(fieldName, null, memberClass, memberName, null, null, memberDimensions, storageDataTypeId, typeVariantOrNull);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, String memberName, int memberTypeLength) {
        return new HDF5CompoundMemberMapping(fieldName, null, memberName, null, new int[]{memberTypeLength});
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, int memberTypeDimX, int memberTypeDimY) {
        return new HDF5CompoundMemberMapping(fieldName, null, fieldName, null, new int[]{memberTypeDimX, memberTypeDimY});
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, String memberName, int memberTypeDimX, int memberTypeDimY) {
        return new HDF5CompoundMemberMapping(fieldName, null, memberName, null, new int[]{memberTypeDimX, memberTypeDimY});
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, int[] memberTypeDimensions) {
        return new HDF5CompoundMemberMapping(fieldName, null, fieldName, null, memberTypeDimensions);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, String memberName, int[] memberTypeDimensions) {
        return new HDF5CompoundMemberMapping(fieldName, null, memberName, null, memberTypeDimensions);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, HDF5EnumerationType enumType) {
        assert (enumType != null);
        return new HDF5CompoundMemberMapping(fieldName, HDF5EnumerationValue.class, fieldName, enumType, new int[0]);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, HDF5EnumerationType enumType, int[] memberTypeDimensions) {
        assert (enumType != null);
        return new HDF5CompoundMemberMapping(fieldName, HDF5EnumerationValueArray.class, fieldName, enumType, memberTypeDimensions);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, String memberName, HDF5EnumerationType enumType, int[] memberTypeDimensions) {
        assert (enumType != null);
        return new HDF5CompoundMemberMapping(fieldName, HDF5EnumerationValueArray.class, memberName, enumType, memberTypeDimensions);
    }

    static HDF5CompoundMemberMapping mapping(String fieldName, String memberName, HDF5EnumerationType enumType, int[] memberTypeDimensions, int storageTypeId) {
        assert (enumType != null);
        return new HDF5CompoundMemberMapping(fieldName, null, HDF5EnumerationValueArray.class, memberName, enumType, null, memberTypeDimensions, storageTypeId, null);
    }

    static HDF5CompoundMemberMapping mappingWithStorageTypeId(String fieldName, String memberName, HDF5EnumerationType enumType, int[] memberTypeDimensions, int storageTypeId, HDF5DataTypeVariant typeVariantOrNull) {
        assert (enumType != null);
        return new HDF5CompoundMemberMapping(fieldName, null, HDF5EnumerationValueArray.class, memberName, enumType, null, memberTypeDimensions, storageTypeId, typeVariantOrNull);
    }

    static HDF5CompoundMemberMapping mapping(String fieldName, Class<?> memberClass, HDF5EnumerationType enumType, int[] memberTypeDimensions, int storageTypeId) {
        assert (enumType != null);
        return new HDF5CompoundMemberMapping(fieldName, null, memberClass, fieldName, enumType, null, memberTypeDimensions, storageTypeId, null);
    }

    @Deprecated
    public static HDF5CompoundMemberMapping mapping(String fieldName, String memberName, HDF5EnumerationType enumType) {
        assert (enumType != null);
        return new HDF5CompoundMemberMapping(fieldName, HDF5EnumerationValue.class, memberName, enumType, new int[0]);
    }

    public static HDF5CompoundMemberMapping[] inferMapping(Class<?> pojoClass) {
        return HDF5CompoundMemberMapping.inferMapping(pojoClass, null);
    }

    public static HDF5CompoundMemberMapping[] inferMapping(Class<?> pojoClass, Map<String, HDF5EnumerationType> fieldNameToEnumTypeMapOrNull) {
        ArrayList<HDF5CompoundMemberMapping> result = new ArrayList<HDF5CompoundMemberMapping>(pojoClass.getDeclaredFields().length);
        CompoundType ct = pojoClass.getAnnotation(CompoundType.class);
        boolean includeAllFields = ct != null ? ct.mapAllFields() : true;
        Class<?> c = pojoClass;
        while (c != null) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                HDF5EnumerationType enumTypeOrNull = fieldNameToEnumTypeMapOrNull != null ? fieldNameToEnumTypeMapOrNull.get(f.getName()) : null;
                CompoundElement e = f.getAnnotation(CompoundElement.class);
                if (e != null) {
                    result.add(new HDF5CompoundMemberMapping(f.getName(), f, f.getType(), StringUtils.defaultIfEmpty(e.memberName(), f.getName()), enumTypeOrNull, e.typeName(), e.dimensions(), HDF5DataTypeVariant.unmaskNone(e.typeVariant())));
                } else if (includeAllFields) {
                    result.add(new HDF5CompoundMemberMapping(f.getName(), f, f.getType(), f.getName(), enumTypeOrNull, new int[0]));
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return result.toArray(new HDF5CompoundMemberMapping[result.size()]);
    }

    public static HDF5CompoundMemberMapping[] inferMapping(Object pojo, Map<String, HDF5EnumerationType> fieldNameToEnumTypeMapOrNull) {
        HDF5CompoundMemberMapping[] result;
        HDF5CompoundMemberMapping[] hDF5CompoundMemberMappingArray = result = HDF5CompoundMemberMapping.inferMapping(pojo.getClass(), fieldNameToEnumTypeMapOrNull);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5CompoundMemberMapping m = hDF5CompoundMemberMappingArray[n2];
            try {
                Class<?> memberClass = m.tryGetMemberClass();
                if (m.getMemberTypeDimensions().length == 0) {
                    Object o;
                    if (memberClass == String.class) {
                        ReflectionUtils.ensureAccessible(m.fieldOrNull);
                        m.length(Array.getLength(m.fieldOrNull.get(pojo)));
                    } else if (memberClass.isArray()) {
                        if (memberClass.isArray()) {
                            Object firstElement;
                            ReflectionUtils.ensureAccessible(m.fieldOrNull);
                            o = m.fieldOrNull.get(pojo);
                            int dimX = Array.getLength(o);
                            if (!memberClass.getComponentType().isArray()) {
                                m.length(dimX);
                            } else if (dimX > 0 && (firstElement = Array.get(o, 0)) != null) {
                                int dimY = Array.getLength(firstElement);
                                m.dimensions(new int[]{dimX, dimY});
                            }
                        }
                    } else if (MDAbstractArray.class.isAssignableFrom(memberClass)) {
                        ReflectionUtils.ensureAccessible(m.fieldOrNull);
                        o = m.fieldOrNull.get(pojo);
                        m.dimensions(((MDAbstractArray)o).dimensions());
                    }
                }
            }
            catch (IllegalAccessException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            ++n2;
        }
        return result;
    }

    public static HDF5CompoundMemberMapping[] inferMapping(Object[] pojo, Map<String, HDF5EnumerationType> fieldNameToEnumTypeMapOrNull) {
        HDF5CompoundMemberMapping[] result;
        HDF5CompoundMemberMapping[] hDF5CompoundMemberMappingArray = result = HDF5CompoundMemberMapping.inferMapping(pojo.getClass().getComponentType(), fieldNameToEnumTypeMapOrNull);
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5CompoundMemberMapping m = hDF5CompoundMemberMappingArray[n2];
            try {
                Class<?> memberClass = m.tryGetMemberClass();
                if (m.getMemberTypeDimensions().length == 0) {
                    if (memberClass == String.class) {
                        ReflectionUtils.ensureAccessible(m.fieldOrNull);
                        int maxLen = 0;
                        int i = 0;
                        while (i < pojo.length) {
                            maxLen = Math.max(maxLen, Array.getLength(m.fieldOrNull.get(pojo[i])));
                            ++i;
                        }
                        m.length(maxLen);
                    } else if (memberClass.isArray()) {
                        if (memberClass.isArray() && pojo.length > 0) {
                            Object firstElement;
                            ReflectionUtils.ensureAccessible(m.fieldOrNull);
                            Object o = m.fieldOrNull.get(pojo[0]);
                            int dimX = Array.getLength(o);
                            if (!memberClass.getComponentType().isArray()) {
                                m.length(dimX);
                            } else if (dimX > 0 && (firstElement = Array.get(o, 0)) != null) {
                                int dimY = Array.getLength(firstElement);
                                m.dimensions(new int[]{dimX, dimY});
                            }
                        }
                    } else if (MDAbstractArray.class.isAssignableFrom(memberClass) && pojo.length > 0) {
                        ReflectionUtils.ensureAccessible(m.fieldOrNull);
                        Object o = m.fieldOrNull.get(pojo[0]);
                        m.dimensions(((MDAbstractArray)o).dimensions());
                    }
                }
            }
            catch (IllegalAccessException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            ++n2;
        }
        return result;
    }

    public static HDF5CompoundMemberMapping[] addHints(HDF5CompoundMemberMapping[] mapping, HDF5CompoundMappingHints hintsOrNull) {
        if (hintsOrNull != null) {
            HDF5CompoundMemberMapping[] hDF5CompoundMemberMappingArray = mapping;
            int n = mapping.length;
            int n2 = 0;
            while (n2 < n) {
                HDF5CompoundMemberMapping m = hDF5CompoundMemberMappingArray[n2];
                m.hints(hintsOrNull);
                ++n2;
            }
        }
        return mapping;
    }

    public static HDF5CompoundMemberMapping[] inferMapping(Map<String, Object> compoundMap) {
        List<HDF5CompoundMemberMapping> result = HDF5CompoundMemberMapping.inferMapping(compoundMap.size(), compoundMap.entrySet());
        Collections.sort(result, new Comparator<HDF5CompoundMemberMapping>(){

            @Override
            public int compare(HDF5CompoundMemberMapping o1, HDF5CompoundMemberMapping o2) {
                return o1.memberName.compareTo(o2.memberName);
            }
        });
        return result.toArray(new HDF5CompoundMemberMapping[result.size()]);
    }

    public static HDF5CompoundMemberMapping[] inferMapping(List<String> memberNames, List<?> memberValues) {
        assert (memberNames != null);
        assert (memberValues != null);
        assert (memberNames.size() == memberValues.size());
        List<HDF5CompoundMemberMapping> result = HDF5CompoundMemberMapping.inferMapping(memberNames.size(), HDF5CompoundMemberMapping.createEntryIterable(memberNames, memberValues));
        return result.toArray(new HDF5CompoundMemberMapping[result.size()]);
    }

    public static HDF5CompoundMemberMapping[] inferMapping(String[] memberNames, Object[] memberValues) {
        assert (memberNames != null);
        assert (memberValues != null);
        assert (memberNames.length == memberValues.length);
        List<HDF5CompoundMemberMapping> result = HDF5CompoundMemberMapping.inferMapping(memberNames.length, HDF5CompoundMemberMapping.createEntryIterable(memberNames, memberValues));
        return result.toArray(new HDF5CompoundMemberMapping[result.size()]);
    }

    private static Iterable<Map.Entry<String, Object>> createEntryIterable(final List<String> memberNames, final List<?> memberValues) {
        return new Iterable<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    int idx = -1;

                    @Override
                    public boolean hasNext() {
                        return this.idx < memberNames.size() - 1;
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        ++this.idx;
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return (String)memberNames.get(idx);
                            }

                            @Override
                            public Object getValue() {
                                return memberValues.get(idx);
                            }

                            @Override
                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static Iterable<Map.Entry<String, Object>> createEntryIterable(final String[] memberNames, final Object[] memberValues) {
        return new Iterable<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    int idx = -1;

                    @Override
                    public boolean hasNext() {
                        return this.idx < memberNames.length - 1;
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        ++this.idx;
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return memberNames[idx];
                            }

                            @Override
                            public Object getValue() {
                                return memberValues[idx];
                            }

                            @Override
                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static List<HDF5CompoundMemberMapping> inferMapping(int size, Iterable<Map.Entry<String, Object>> entries) {
        ArrayList<HDF5CompoundMemberMapping> result = new ArrayList<HDF5CompoundMemberMapping>(size);
        for (Map.Entry<String, Object> entry : entries) {
            int[] dimensions;
            String memberName = entry.getKey();
            Object memberValue = entry.getValue();
            Class<?> memberClass = HDF5Utils.unwrapClass(memberValue.getClass());
            HDF5DataTypeVariant variantOrNull = memberClass == HDF5TimeDuration.class ? ((HDF5TimeDuration)memberValue).getUnit().getTypeVariant() : null;
            if (memberClass.isArray()) {
                int lenx = Array.getLength(memberValue);
                if (lenx > 0 && Array.get(memberValue, 0).getClass().isArray()) {
                    int leny = Array.getLength(Array.get(memberValue, 0));
                    result.add(new HDF5CompoundMemberMapping(memberName, memberClass, memberName, null, null, new int[]{lenx, leny}, variantOrNull));
                    continue;
                }
                result.add(new HDF5CompoundMemberMapping(memberName, memberClass, memberName, null, null, new int[]{lenx}, variantOrNull));
                continue;
            }
            if (MDAbstractArray.class.isInstance(memberValue)) {
                result.add(new HDF5CompoundMemberMapping(memberName, memberClass, memberName, null, null, ((MDAbstractArray)memberValue).dimensions(), variantOrNull));
                continue;
            }
            HDF5EnumerationType enumTypeOrNull = null;
            if (memberClass == HDF5EnumerationValue.class) {
                enumTypeOrNull = ((HDF5EnumerationValue)memberValue).getType();
                dimensions = new int[]{};
            } else if (memberClass == HDF5EnumerationValueArray.class) {
                enumTypeOrNull = ((HDF5EnumerationValueArray)memberValue).getType();
                dimensions = new int[]{((HDF5EnumerationValueArray)memberValue).getLength()};
            } else if (memberClass == String.class) {
                dimensions = new int[]{((String)memberValue).length()};
            } else if (memberClass == BitSet.class) {
                int len = ((BitSet)memberValue).length();
                dimensions = new int[]{len > 0 ? len : 1};
            } else {
                dimensions = new int[]{};
            }
            result.add(new HDF5CompoundMemberMapping(memberName, memberClass, memberName, enumTypeOrNull, null, dimensions, variantOrNull));
        }
        return result;
    }

    public static String constructCompoundTypeName(Collection<String> memberNames, boolean sort) {
        Collection<String> names = sort ? HDF5CompoundMemberMapping.sort(memberNames) : memberNames;
        StringBuilder b = new StringBuilder();
        for (String name : names) {
            b.append(name);
            b.append(':');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    private static List<String> sort(Collection<String> memberNames) {
        ArrayList<String> names = new ArrayList<String>(memberNames);
        Collections.sort(names);
        return names;
    }

    public static <T> Map<String, HDF5EnumerationType> inferEnumerationTypeMap(T pojo, IHDF5EnumTypeRetriever enumTypeRetriever) {
        HashMap<String, HDF5EnumerationType> resultOrNull = null;
        Class<?> c = pojo.getClass();
        while (c != null) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f.getType() == HDF5EnumerationValue.class) {
                    ReflectionUtils.ensureAccessible(f);
                    try {
                        if (resultOrNull == null) {
                            resultOrNull = new HashMap<String, HDF5EnumerationType>();
                        }
                        resultOrNull.put(f.getName(), ((HDF5EnumerationValue)f.get(pojo)).getType());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Error(ex);
                    }
                    catch (IllegalAccessException ex) {
                        throw new Error(ex);
                    }
                }
                if (f.getType().isEnum()) {
                    ReflectionUtils.ensureAccessible(f);
                    try {
                        if (resultOrNull == null) {
                            resultOrNull = new HashMap();
                        }
                        resultOrNull.put(f.getName(), enumTypeRetriever.getType(f.getType().getSimpleName(), ReflectionUtils.getEnumOptions(HDF5CompoundMemberMapping.asEnumClass(f))));
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Error(ex);
                    }
                }
                if (f.getType() == HDF5EnumerationValueArray.class) {
                    ReflectionUtils.ensureAccessible(f);
                    try {
                        if (resultOrNull == null) {
                            resultOrNull = new HashMap();
                        }
                        resultOrNull.put(f.getName(), ((HDF5EnumerationValueArray)f.get(pojo)).getType());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Error(ex);
                    }
                    catch (IllegalAccessException ex) {
                        throw new Error(ex);
                    }
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return resultOrNull;
    }

    private static Class<? extends Enum<?>> asEnumClass(Field f) {
        return f.getType();
    }

    private HDF5CompoundMemberMapping(String fieldName, Field fieldOrNull, Class<?> memberClassOrNull, String memberName, HDF5EnumerationType enumTypeOrNull, int[] memberTypeDimensions) {
        this(fieldName, fieldOrNull, memberClassOrNull, memberName, enumTypeOrNull, null, memberTypeDimensions, -1, null);
    }

    private HDF5CompoundMemberMapping(String fieldName, Class<?> memberClassOrNull, String memberName, HDF5EnumerationType enumTypeOrNull, int[] memberTypeDimensions) {
        this(fieldName, null, memberClassOrNull, memberName, enumTypeOrNull, null, memberTypeDimensions, -1, null);
    }

    private HDF5CompoundMemberMapping(String fieldName, Class<?> memberClassOrNull, String memberName, HDF5EnumerationType enumTypeOrNull, String enumTypeName, int[] memberTypeDimensions, HDF5DataTypeVariant typeVariantOrNull) {
        this(fieldName, null, memberClassOrNull, memberName, enumTypeOrNull, enumTypeName, memberTypeDimensions, -1, typeVariantOrNull);
    }

    private HDF5CompoundMemberMapping(String fieldName, Field fieldOrNull, Class<?> memberClassOrNull, String memberName, HDF5EnumerationType enumTypeOrNull, String enumTypeName, int[] memberTypeDimensions, HDF5DataTypeVariant typeVariantOrNull) {
        this(fieldName, fieldOrNull, memberClassOrNull, memberName, enumTypeOrNull, enumTypeName, memberTypeDimensions, -1, typeVariantOrNull);
    }

    private HDF5CompoundMemberMapping(String fieldName, Field fieldOrNull, Class<?> memberClassOrNull, String memberName, HDF5EnumerationType enumTypeOrNull, String enumTypeName, int[] memberTypeDimensions, int storageMemberTypeId, HDF5DataTypeVariant typeVariantOrNull) {
        this.fieldOrNull = fieldOrNull;
        this.fieldName = fieldName;
        this.memberClassOrNull = memberClassOrNull;
        this.memberName = memberName;
        this.enumTypeOrNull = enumTypeOrNull;
        this.enumTypeName = enumTypeName;
        this.memberTypeDimensions = memberTypeDimensions;
        this.memberTypeLength = MDArray.getLength(memberTypeDimensions);
        this.storageDataTypeId = storageMemberTypeId;
        this.typeVariantOrNull = typeVariantMap.containsKey((Object)typeVariantOrNull) ? typeVariantMap.get((Object)typeVariantOrNull) : HDF5DataTypeVariant.maskNull(typeVariantOrNull);
    }

    public HDF5CompoundMemberMapping fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public HDF5CompoundMemberMapping enumTypeName(String enumTypeName) {
        this.enumTypeName = enumTypeName != null && enumTypeName.length() == 0 ? null : enumTypeName;
        return this;
    }

    String getEnumTypeName() {
        return this.enumTypeName;
    }

    Field tryGetField(Class<?> clazz, boolean skipChecks) throws HDF5JavaException {
        return this.tryGetField(clazz, clazz, skipChecks);
    }

    Field tryGetField(Class<?> clazz) throws HDF5JavaException {
        return this.tryGetField(clazz, clazz, false);
    }

    private Field tryGetField(Class<?> clazz, Class<?> searchClass, boolean skipChecks) throws HDF5JavaException {
        try {
            Field field = clazz.getDeclaredField(this.fieldName);
            Class<?> fieldType = field.getType();
            boolean isArray = fieldType.isArray();
            boolean isMDArray = MDAbstractArray.class.isAssignableFrom(fieldType);
            if (!skipChecks) {
                if (this.memberTypeLength > 1) {
                    if (field.getType() != String.class && !isArray && field.getType() != BitSet.class && field.getType() != HDF5EnumerationValueArray.class && !isMDArray) {
                        throw new HDF5JavaException("Field '" + this.fieldName + "' of class '" + clazz.getCanonicalName() + "' is no String or array, but a length > 1 is given.");
                    }
                } else if (this.memberTypeLength == 0 && (field.getType() == String.class || isArray || isMDArray || field.getType() == BitSet.class)) {
                    throw new HDF5JavaException("Field '" + this.fieldName + "' of class '" + clazz.getCanonicalName() + "' is a String or array, but a length == 0 is given.");
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> superClassOrNull = clazz.getSuperclass();
            if (superClassOrNull == null || superClassOrNull == Object.class) {
                return null;
            }
            return this.tryGetField(superClassOrNull, searchClass, skipChecks);
        }
    }

    String getMemberName() {
        return this.memberName;
    }

    public HDF5CompoundMemberMapping memberClass(Class<?> memberClass) {
        this.memberClassOrNull = memberClass;
        return this;
    }

    public Class<?> tryGetMemberClass() {
        return this.memberClassOrNull;
    }

    public HDF5CompoundMemberMapping length(int memberTypeLength) {
        return this.dimensions(new int[]{memberTypeLength});
    }

    int getMemberTypeLength() {
        return this.memberTypeLength;
    }

    public HDF5CompoundMemberMapping dimensions(int memberTypeDimensionX, int memberTypeDimensionY) {
        this.memberTypeDimensions = new int[]{memberTypeDimensionX, memberTypeDimensionY};
        this.memberTypeLength = MDArray.getLength(this.memberTypeDimensions);
        return this;
    }

    public HDF5CompoundMemberMapping dimensions(int[] memberTypeDimensions) {
        this.memberTypeDimensions = memberTypeDimensions;
        this.memberTypeLength = MDArray.getLength(memberTypeDimensions);
        if (this.enumTypeOrNull != null) {
            this.checkEnumArrayRank();
            this.memberClassOrNull = HDF5EnumerationValueArray.class;
        }
        return this;
    }

    public HDF5CompoundMemberMapping hints(HDF5CompoundMappingHints hints) {
        this.hintsOrNull = hints;
        return this;
    }

    private void checkEnumArrayRank() {
        if (this.memberTypeDimensions != null && this.memberTypeDimensions.length > 1) {
            throw new HDF5JavaException("Enumeration arrays only supported with rank 1 [rank=" + this.memberTypeDimensions.length + "]");
        }
    }

    int[] getMemberTypeDimensions() {
        return this.memberTypeDimensions;
    }

    int getStorageDataTypeId() {
        return this.storageDataTypeId;
    }

    public HDF5CompoundMemberMapping enumType(HDF5EnumerationType enumType) {
        this.enumTypeOrNull = enumType;
        this.checkEnumArrayRank();
        this.memberClassOrNull = this.memberTypeLength == 0 ? HDF5EnumerationValue.class : HDF5EnumerationValueArray.class;
        return this;
    }

    HDF5EnumerationType tryGetEnumerationType() {
        return this.enumTypeOrNull;
    }

    void setEnumerationType(HDF5EnumerationType enumType) {
        this.enumTypeOrNull = enumType;
    }

    HDF5CompoundMappingHints tryGetHints() {
        return this.hintsOrNull;
    }

    public HDF5CompoundMemberMapping typeVariant(HDF5DataTypeVariant typeVariant) {
        this.typeVariantOrNull = typeVariant;
        return this;
    }

    HDF5DataTypeVariant tryGetTypeVariant() {
        return this.typeVariantOrNull;
    }
}

