/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.HDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.hdf5lib.H5F;
import java.io.File;

public final class HDF5FactoryProvider {
    private static IHDF5Factory factory = new HDF5Factory();

    private HDF5FactoryProvider() {
    }

    public static synchronized IHDF5Factory get() {
        return factory;
    }

    public static synchronized void set(IHDF5Factory factory) {
        HDF5FactoryProvider.factory = factory;
    }

    private static class HDF5Factory
    implements IHDF5Factory {
        private HDF5Factory() {
        }

        public IHDF5WriterConfigurator configure(File file) {
            return new HDF5WriterConfigurator(file);
        }

        public IHDF5ReaderConfigurator configureForReading(File file) {
            return new HDF5ReaderConfigurator(file);
        }

        public IHDF5Writer open(File file) {
            return new HDF5WriterConfigurator(file).writer();
        }

        public IHDF5Reader openForReading(File file) {
            return new HDF5ReaderConfigurator(file).reader();
        }

        public boolean isHDF5File(File file) {
            return H5F.H5Fis_hdf5(file.getPath());
        }
    }
}

