/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5IntReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5IntReader
implements IHDF5IntReader {
    private final HDF5BaseReader baseReader;

    HDF5IntReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public int getIntAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Integer> getAttributeRunnable = new ICallableWithCleanUp<Integer>(){

            @Override
            public Integer call(ICleanUpRegistry registry) {
                int objectId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openObject(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int[] data = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readAttributeAsIntArray(attributeId, HDF5Constants.H5T_NATIVE_INT32, 1);
                return data[0];
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public int[] getIntArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> getAttributeRunnable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int memoryTypeId;
                int len;
                Object[] arrayDimensions;
                int objectId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openObject(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int attributeTypeId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                if (((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                    arrayDimensions = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                    if (arrayDimensions.length != 1) {
                        throw new HDF5JavaException("Array needs to be of rank 1, but is of rank " + arrayDimensions.length);
                    }
                    len = arrayDimensions[0];
                    memoryTypeId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT32, len, registry);
                } else {
                    arrayDimensions = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
                    memoryTypeId = HDF5Constants.H5T_NATIVE_INT32;
                    len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
                }
                int[] data = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readAttributeAsIntArray(attributeId, memoryTypeId, len);
                return data;
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public MDIntArray getIntMDArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDIntArray> getAttributeRunnable = new ICallableWithCleanUp<MDIntArray>(){

            @Override
            public MDIntArray call(ICleanUpRegistry registry) {
                try {
                    int memoryTypeId;
                    int[] arrayDimensions;
                    int objectId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openObject(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                    int attributeId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                    int attributeTypeId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                    if (((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                        arrayDimensions = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                        memoryTypeId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT32, arrayDimensions, registry);
                    } else {
                        arrayDimensions = MDArray.toInt(((HDF5IntReader)HDF5IntReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                        memoryTypeId = HDF5Constants.H5T_NATIVE_INT32;
                    }
                    int len = MDArray.getLength(arrayDimensions);
                    int[] data = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readAttributeAsIntArray(attributeId, memoryTypeId, len);
                    return new MDIntArray(data, arrayDimensions);
                }
                catch (IllegalArgumentException ex) {
                    throw new HDF5JavaException(ex.getMessage());
                }
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public int[][] getIntMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        MDIntArray array = this.getIntMDArrayAttribute(objectPath, attributeName);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public int readInt(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Integer> readCallable = new ICallableWithCleanUp<Integer>(){

            @Override
            public Integer call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openDataSet(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                int[] data = new int[1];
                ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT32, data);
                return data[0];
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readIntArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openDataSet(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                return HDF5IntReader.this.readIntArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private int[] readIntArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            int[] data = new int[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT32, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return data;
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readIntArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private int[] readIntArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        int[] data = new int[HDF5Utils.getOneDimensionalArraySize(dimensions)];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT32, data.length, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return data;
    }

    @Override
    public int[] readToIntMDArrayWithOffset(final String objectPath, final MDIntArray array, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openDataSet(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5IntReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), registry);
                int nativeDataTypeId = HDF5IntReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT32, registry);
                ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToIntMDArrayBlockWithOffset(final String objectPath, final MDIntArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openDataSet(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5IntReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), offset, blockDimensions, registry);
                int nativeDataTypeId = HDF5IntReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT32, registry);
                ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readIntArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readIntArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public int[] readIntArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openDataSet(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5IntReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                int[] data = new int[spaceParams.blockSize];
                ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT32, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[][] readIntMatrix(String objectPath) throws HDF5JavaException {
        MDIntArray array = this.readIntMDArray(objectPath);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public int[][] readIntMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        MDIntArray array = this.readIntMDArrayBlock(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{blockNumberX, blockNumberY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public int[][] readIntMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        MDIntArray array = this.readIntMDArrayBlockWithOffset(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{offsetX, offsetY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public MDIntArray readIntMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDIntArray> readCallable = new ICallableWithCleanUp<MDIntArray>(){

            @Override
            public MDIntArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openDataSet(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                return HDF5IntReader.this.readIntMDArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private MDIntArray readIntMDArray(int dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            int[] data = new int[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT32, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return new MDIntArray(data, spaceParams.dimensions);
        }
        catch (HDF5LibraryException ex) {
            int dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readIntMDArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private MDIntArray readIntMDArrayFromArrayType(int dataSetId, int dataTypeId, ICleanUpRegistry registry) {
        int spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        int[] data = new int[MDArray.getLength(dimensions)];
        int memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT32, dimensions, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return new MDIntArray(data, dimensions);
    }

    @Override
    public MDIntArray readIntMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readIntMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public MDIntArray readIntMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDIntArray> readCallable = new ICallableWithCleanUp<MDIntArray>(){

            @Override
            public MDIntArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.openDataSet(((HDF5IntReader)HDF5IntReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5IntReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                int[] dataBlock = new int[spaceParams.blockSize];
                ((HDF5IntReader)HDF5IntReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT32, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                return new MDIntArray(dataBlock, blockDimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<int[]>> getIntArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<int[]>>(){

            @Override
            public Iterator<HDF5DataBlock<int[]>> iterator() {
                return new Iterator<HDF5DataBlock<int[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<int[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        int[] block = HDF5IntReader.this.readIntArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<int[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDIntArray>> getIntMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDIntArray>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDIntArray>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDIntArray>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDIntArray> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDIntArray data = HDF5IntReader.this.readIntMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDIntArray>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

