/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5BooleanReader;
import ch.systemsx.cisd.hdf5.HDF5ByteReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundMappingHints;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5CompoundReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataType;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.HDF5DoubleReader;
import ch.systemsx.cisd.hdf5.HDF5EnumReader;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5FloatReader;
import ch.systemsx.cisd.hdf5.HDF5GenericReader;
import ch.systemsx.cisd.hdf5.HDF5IntReader;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5ObjectInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.HDF5OpaqueType;
import ch.systemsx.cisd.hdf5.HDF5ReferenceReader;
import ch.systemsx.cisd.hdf5.HDF5ShortReader;
import ch.systemsx.cisd.hdf5.HDF5StringReader;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.HDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5BooleanReader;
import ch.systemsx.cisd.hdf5.IHDF5ByteReader;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5CompoundReader;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.IHDF5DoubleReader;
import ch.systemsx.cisd.hdf5.IHDF5EnumReader;
import ch.systemsx.cisd.hdf5.IHDF5FloatReader;
import ch.systemsx.cisd.hdf5.IHDF5GenericReader;
import ch.systemsx.cisd.hdf5.IHDF5IntReader;
import ch.systemsx.cisd.hdf5.IHDF5LongReader;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReferenceReader;
import ch.systemsx.cisd.hdf5.IHDF5ShortReader;
import ch.systemsx.cisd.hdf5.IHDF5StringReader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import ncsa.hdf.hdf5lib.exceptions.HDF5DatatypeInterfaceException;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5Reader
implements IHDF5Reader {
    private final HDF5BaseReader baseReader;
    private final IHDF5ByteReader byteReader;
    private final IHDF5ShortReader shortReader;
    private final IHDF5IntReader intReader;
    private final IHDF5LongReader longReader;
    private final IHDF5FloatReader floatReader;
    private final IHDF5DoubleReader doubleReader;
    private final IHDF5BooleanReader booleanReader;
    private final IHDF5StringReader stringReader;
    private final IHDF5EnumReader enumReader;
    private final IHDF5CompoundReader compoundReader;
    private final IHDF5DateTimeReader dateTimeReader;
    private final IHDF5ReferenceReader referenceReader;
    private final IHDF5GenericReader genericReader;

    HDF5Reader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
        this.byteReader = new HDF5ByteReader(baseReader);
        this.shortReader = new HDF5ShortReader(baseReader);
        this.intReader = new HDF5IntReader(baseReader);
        this.longReader = new HDF5LongReader(baseReader);
        this.floatReader = new HDF5FloatReader(baseReader);
        this.doubleReader = new HDF5DoubleReader(baseReader);
        this.booleanReader = new HDF5BooleanReader(baseReader);
        this.stringReader = new HDF5StringReader(baseReader);
        this.enumReader = new HDF5EnumReader(baseReader);
        this.compoundReader = new HDF5CompoundReader(baseReader, this.enumReader);
        this.dateTimeReader = new HDF5DateTimeReader(baseReader);
        this.referenceReader = new HDF5ReferenceReader(baseReader);
        this.genericReader = new HDF5GenericReader(baseReader);
    }

    void checkOpen() {
        this.baseReader.checkOpen();
    }

    int getFileId() {
        return this.baseReader.fileId;
    }

    @Override
    public boolean isPerformNumericConversions() {
        return this.baseReader.performNumericConversions;
    }

    @Override
    public File getFile() {
        return this.baseReader.hdf5File;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() {
        this.baseReader.close();
    }

    @Override
    public HDF5LinkInformation getLinkInformation(String objectPath) {
        this.baseReader.checkOpen();
        return this.baseReader.h5.getLinkInfo(this.baseReader.fileId, objectPath, false);
    }

    @Override
    public HDF5ObjectInformation getObjectInformation(String objectPath) {
        this.baseReader.checkOpen();
        return this.baseReader.h5.getObjectInfo(this.baseReader.fileId, objectPath, false);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath, boolean followLink) {
        this.baseReader.checkOpen();
        if (followLink) {
            return this.baseReader.h5.getObjectTypeInfo(this.baseReader.fileId, objectPath, false);
        }
        return this.baseReader.h5.getLinkTypeInfo(this.baseReader.fileId, objectPath, false);
    }

    @Override
    public HDF5ObjectType getObjectType(String objectPath) {
        return this.getObjectType(objectPath, true);
    }

    @Override
    public boolean exists(String objectPath, boolean followLink) {
        if (!followLink) {
            this.baseReader.checkOpen();
            if ("/".equals(objectPath)) {
                return true;
            }
            return this.baseReader.h5.exists(this.baseReader.fileId, objectPath);
        }
        return this.exists(objectPath);
    }

    @Override
    public boolean exists(String objectPath) {
        this.baseReader.checkOpen();
        if ("/".equals(objectPath)) {
            return true;
        }
        return this.baseReader.h5.getObjectTypeId(this.baseReader.fileId, objectPath, false) >= 0;
    }

    @Override
    public boolean isGroup(String objectPath, boolean followLink) {
        return HDF5ObjectType.isGroup(this.getObjectType(objectPath, followLink));
    }

    @Override
    public boolean isGroup(String objectPath) {
        return HDF5ObjectType.isGroup(this.getObjectType(objectPath));
    }

    @Override
    public boolean isDataSet(String objectPath, boolean followLink) {
        return HDF5ObjectType.isDataSet(this.getObjectType(objectPath, followLink));
    }

    @Override
    public boolean isDataSet(String objectPath) {
        return HDF5ObjectType.isDataSet(this.getObjectType(objectPath));
    }

    @Override
    public boolean isDataType(String objectPath, boolean followLink) {
        return HDF5ObjectType.isDataType(this.getObjectType(objectPath, followLink));
    }

    @Override
    public boolean isDataType(String objectPath) {
        return HDF5ObjectType.isDataType(this.getObjectType(objectPath));
    }

    @Override
    public boolean isSoftLink(String objectPath) {
        return HDF5ObjectType.isSoftLink(this.getObjectType(objectPath, false));
    }

    @Override
    public boolean isExternalLink(String objectPath) {
        return HDF5ObjectType.isExternalLink(this.getObjectType(objectPath, false));
    }

    @Override
    public boolean isSymbolicLink(String objectPath) {
        return HDF5ObjectType.isSymbolicLink(this.getObjectType(objectPath, false));
    }

    @Override
    public String tryGetSymbolicLinkTarget(String objectPath) {
        return this.getLinkInformation(objectPath).tryGetSymbolicLinkTarget();
    }

    @Override
    public String tryGetDataTypePath(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> dataTypeNameCallable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5Reader)HDF5Reader.this).baseReader.h5.openDataSet(((HDF5Reader)HDF5Reader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5Reader)HDF5Reader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                return HDF5Reader.this.baseReader.tryGetDataTypePath(dataTypeId);
            }
        };
        return this.baseReader.runner.call(dataTypeNameCallable);
    }

    @Override
    public String tryGetDataTypePath(HDF5DataType type) {
        assert (type != null);
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        return this.baseReader.tryGetDataTypePath(type.getStorageTypeId());
    }

    @Override
    public List<String> getAttributeNames(String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        return HDF5Utils.removeInternalNames(this.getAllAttributeNames(objectPath));
    }

    @Override
    public List<String> getAllAttributeNames(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<List<String>> attributeNameReaderRunnable = new ICallableWithCleanUp<List<String>>(){

            @Override
            public List<String> call(ICleanUpRegistry registry) {
                int objectId = ((HDF5Reader)HDF5Reader.this).baseReader.h5.openObject(((HDF5Reader)HDF5Reader.this).baseReader.fileId, objectPath, registry);
                return ((HDF5Reader)HDF5Reader.this).baseReader.h5.getAttributeNames(objectId, registry);
            }
        };
        return this.baseReader.runner.call(attributeNameReaderRunnable);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(String dataSetPath, String attributeName) {
        return this.getAttributeInformation(dataSetPath, attributeName, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public HDF5DataTypeInformation getAttributeInformation(final String dataSetPath, final String attributeName, final HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        assert (dataSetPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5DataTypeInformation> informationDeterminationRunnable = new ICallableWithCleanUp<HDF5DataTypeInformation>(){

            @Override
            public HDF5DataTypeInformation call(ICleanUpRegistry registry) {
                int[] dimensions;
                int objectId = ((HDF5Reader)HDF5Reader.this).baseReader.h5.openObject(((HDF5Reader)HDF5Reader.this).baseReader.fileId, dataSetPath, registry);
                int attributeId = ((HDF5Reader)HDF5Reader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int dataTypeId = ((HDF5Reader)HDF5Reader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                HDF5DataTypeInformation dataTypeInformation = HDF5Reader.this.baseReader.getDataTypeInformation(dataTypeId, dataTypeInfoOptions, registry);
                if (!dataTypeInformation.isArrayType() && (dimensions = MDArray.toInt(((HDF5Reader)HDF5Reader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry))).length > 0) {
                    dataTypeInformation.setDimensions(dimensions);
                }
                return dataTypeInformation;
            }
        };
        return this.baseReader.runner.call(informationDeterminationRunnable);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath) {
        return this.getDataSetInformation(dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public HDF5DataSetInformation getDataSetInformation(String dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        assert (dataSetPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getDataSetInformation(dataSetPath, dataTypeInfoOptions);
    }

    @Override
    public long getSize(String objectPath) {
        return this.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL).getSize();
    }

    @Override
    public long getNumberOfElements(String objectPath) {
        return this.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL).getNumberOfElements();
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter, String destinationObject) {
        this.baseReader.checkOpen();
        HDF5Writer dwriter = (HDF5Writer)destinationWriter;
        if (dwriter != this) {
            dwriter.checkOpen();
        }
        this.baseReader.copyObject(sourceObject, dwriter.getFileId(), destinationObject);
    }

    @Override
    public void copy(String sourceObject, IHDF5Writer destinationWriter) {
        this.copy(sourceObject, destinationWriter, "/");
    }

    @Override
    public void copyAll(IHDF5Writer destinationWriter) {
        this.copy("/", destinationWriter, "/");
    }

    @Override
    public List<String> getGroupMembers(String groupPath) {
        assert (groupPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getGroupMembers(groupPath);
    }

    @Override
    public List<String> getAllGroupMembers(String groupPath) {
        assert (groupPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getAllGroupMembers(groupPath);
    }

    @Override
    public List<String> getGroupMemberPaths(String groupPath) {
        assert (groupPath != null);
        this.baseReader.checkOpen();
        return this.baseReader.getGroupMemberPaths(groupPath);
    }

    @Override
    public List<HDF5LinkInformation> getGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        this.baseReader.checkOpen();
        if (readLinkTargets) {
            return this.baseReader.h5.getGroupMemberLinkInfo(this.baseReader.fileId, groupPath, false);
        }
        return this.baseReader.h5.getGroupMemberTypeInfo(this.baseReader.fileId, groupPath, false);
    }

    @Override
    public List<HDF5LinkInformation> getAllGroupMemberInformation(String groupPath, boolean readLinkTargets) {
        this.baseReader.checkOpen();
        if (readLinkTargets) {
            return this.baseReader.h5.getGroupMemberLinkInfo(this.baseReader.fileId, groupPath, true);
        }
        return this.baseReader.h5.getGroupMemberTypeInfo(this.baseReader.fileId, groupPath, true);
    }

    @Override
    public String tryGetOpaqueTag(String objectPath) {
        return this.genericReader.tryGetOpaqueTag(objectPath);
    }

    @Override
    public HDF5OpaqueType tryGetOpaqueType(String objectPath) {
        return this.genericReader.tryGetOpaqueType(objectPath);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath) {
        this.baseReader.checkOpen();
        return this.baseReader.tryGetTypeVariant(objectPath);
    }

    @Override
    public HDF5DataTypeVariant tryGetTypeVariant(String objectPath, String attributeName) {
        this.baseReader.checkOpen();
        return this.baseReader.tryGetTypeVariant(objectPath, attributeName);
    }

    @Override
    public boolean hasAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Boolean> writeRunnable = new ICallableWithCleanUp<Boolean>(){

            @Override
            public Boolean call(ICleanUpRegistry registry) {
                int objectId = ((HDF5Reader)HDF5Reader.this).baseReader.h5.openObject(((HDF5Reader)HDF5Reader.this).baseReader.fileId, objectPath, registry);
                return ((HDF5Reader)HDF5Reader.this).baseReader.h5.existsAttribute(objectId, attributeName);
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public boolean getBooleanAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.booleanReader.getBooleanAttribute(objectPath, attributeName);
    }

    @Override
    public String getEnumAttributeAsString(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getAttrAsString(objectPath, attributeName);
    }

    @Override
    public HDF5EnumerationValue getEnumAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getAttr(objectPath, attributeName);
    }

    @Override
    public <T extends Enum<T>> T getEnumAttribute(String objectPath, String attributeName, Class<T> enumClass) throws HDF5JavaException {
        return this.enumReader.getAttr(objectPath, attributeName, enumClass);
    }

    @Override
    public String[] getEnumArrayAttributeAsString(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getArrayAttr(objectPath, attributeName).toStringArray();
    }

    @Override
    public HDF5EnumerationValueArray getEnumArrayAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.enumReader.getArrayAttr(objectPath, attributeName);
    }

    @Override
    public HDF5EnumerationType getEnumType(String dataTypeName) {
        return this.enumReader.getType(dataTypeName);
    }

    @Override
    public HDF5EnumerationType getEnumType(String dataTypeName, String[] values) throws HDF5JavaException {
        return this.enumReader.getType(dataTypeName, values);
    }

    @Override
    public HDF5EnumerationType getEnumType(String dataTypeName, String[] values, boolean check) throws HDF5JavaException {
        return this.enumReader.getType(dataTypeName, values, check);
    }

    @Override
    public HDF5EnumerationType getDataSetEnumType(String dataSetPath) {
        return this.enumReader.getDataSetType(dataSetPath);
    }

    @Override
    public HDF5EnumerationType getEnumTypeForObject(String dataSetPath) {
        return this.enumReader.getDataSetType(dataSetPath);
    }

    @Override
    public Iterable<HDF5DataBlock<byte[]>> getAsByteArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.genericReader.getAsByteArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public byte[] readAsByteArray(String objectPath) {
        return this.genericReader.readAsByteArray(objectPath);
    }

    @Override
    public byte[] getAttributeAsByteArray(String objectPath, String attributeName) {
        return this.genericReader.getAttributeAsByteArray(objectPath, attributeName);
    }

    @Override
    public byte[] readAsByteArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.genericReader.readAsByteArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public byte[] readAsByteArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        return this.genericReader.readAsByteArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public int readAsByteArrayToBlockWithOffset(String objectPath, byte[] buffer, int blockSize, long offset, int memoryOffset) throws HDF5JavaException {
        return this.genericReader.readAsByteArrayToBlockWithOffset(objectPath, buffer, blockSize, offset, memoryOffset);
    }

    @Override
    public BitSet readBitField(String objectPath) throws HDF5DatatypeInterfaceException {
        return this.booleanReader.readBitField(objectPath);
    }

    @Override
    public BitSet readBitFieldBlock(String objectPath, int blockSize, long blockNumber) {
        return this.booleanReader.readBitFieldBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public BitSet readBitFieldBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.booleanReader.readBitFieldBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public boolean isBitSetInBitField(String objectPath, int bitIndex) {
        return this.booleanReader.isBitSetInBitField(objectPath, bitIndex);
    }

    @Override
    public boolean readBoolean(String objectPath) throws HDF5JavaException {
        return this.booleanReader.readBoolean(objectPath);
    }

    @Override
    public long getTimeStampAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getTimeStampAttribute(objectPath, attributeName);
    }

    @Override
    public Date getDateAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getDateAttribute(objectPath, attributeName);
    }

    @Override
    public boolean isTimeStamp(String objectPath, String attributeName) throws HDF5JavaException {
        return this.dateTimeReader.isTimeStamp(objectPath, attributeName);
    }

    @Override
    public HDF5TimeDuration getTimeDurationAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getTimeDurationAttribute(objectPath, attributeName);
    }

    @Override
    public boolean isTimeDuration(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.isTimeDuration(objectPath);
    }

    @Override
    public boolean isTimeStamp(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.isTimeStamp(objectPath);
    }

    @Override
    public boolean isTimeDuration(String objectPath, String attributeName) throws HDF5JavaException {
        return this.dateTimeReader.isTimeDuration(objectPath, attributeName);
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath, String attributeName) throws HDF5JavaException {
        return this.dateTimeReader.tryGetTimeUnit(objectPath, attributeName);
    }

    @Override
    public long[] getTimeStampArrayAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getTimeStampArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Date[] getDateArrayAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getDateArrayAttribute(objectPath, attributeName);
    }

    @Override
    public HDF5TimeDurationArray getTimeDurationArrayAttribute(String objectPath, String attributeName) {
        return this.dateTimeReader.getTimeDurationArrayAttribute(objectPath, attributeName);
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.tryGetTimeUnit(objectPath);
    }

    @Override
    @Deprecated
    public Iterable<HDF5DataBlock<long[]>> getTimeDurationArrayNaturalBlocks(String dataSetPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return this.dateTimeReader.getTimeDurationArrayNaturalBlocks(dataSetPath, timeUnit);
    }

    @Override
    @Deprecated
    public Iterable<HDF5DataBlock<HDF5TimeDuration[]>> getTimeDurationAndUnitArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.getTimeDurationAndUnitArrayNaturalBlocks(objectPath);
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getTimeStampArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.dateTimeReader.getTimeStampArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public Date readDate(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readDate(objectPath);
    }

    @Override
    public Date[] readDateArray(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readDateArray(objectPath);
    }

    @Override
    @Deprecated
    public long readTimeDuration(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDuration(objectPath, timeUnit);
    }

    @Override
    public HDF5TimeDuration readTimeDuration(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDuration(objectPath);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration readTimeDurationAndUnit(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationAndUnit(objectPath);
    }

    @Override
    @Deprecated
    public long[] readTimeDurationArray(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationArray(objectPath, timeUnit);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArray(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationArray(objectPath);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration[] readTimeDurationAndUnitArray(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationAndUnitArray(objectPath);
    }

    @Override
    @Deprecated
    public long[] readTimeDurationArrayBlock(String objectPath, int blockSize, long blockNumber, HDF5TimeUnit timeUnit) {
        return this.dateTimeReader.readTimeDurationArrayBlock(objectPath, blockSize, blockNumber, timeUnit);
    }

    @Override
    @Deprecated
    public long[] readTimeDurationArrayBlockWithOffset(String objectPath, int blockSize, long offset, HDF5TimeUnit timeUnit) {
        return this.dateTimeReader.readTimeDurationArrayBlockWithOffset(objectPath, blockSize, offset, timeUnit);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationAndUnitArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    @Deprecated
    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationAndUnitArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public long readTimeStamp(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeStamp(objectPath);
    }

    @Override
    public long[] readTimeStampArray(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.readTimeStampArray(objectPath);
    }

    @Override
    public long[] readTimeStampArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.dateTimeReader.readTimeStampArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public long[] readTimeStampArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.dateTimeReader.readTimeStampArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public String readObjectReference(String objectPath) {
        return this.referenceReader.readObjectReference(objectPath);
    }

    @Override
    public String readObjectReference(String objectPath, boolean resolveName) {
        return this.referenceReader.readObjectReference(objectPath, resolveName);
    }

    @Override
    public String[] readObjectReferenceArrayBlock(String objectPath, int blockSize, long blockNumber, boolean resolveName) {
        return this.referenceReader.readObjectReferenceArrayBlock(objectPath, blockSize, blockNumber, resolveName);
    }

    @Override
    public String[] readObjectReferenceArrayBlockWithOffset(String objectPath, int blockSize, long offset, boolean resolveName) {
        return this.referenceReader.readObjectReferenceArrayBlockWithOffset(objectPath, blockSize, offset, resolveName);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber, boolean resolveName) {
        return this.referenceReader.readObjectReferenceMDArrayBlock(objectPath, blockDimensions, blockNumber, resolveName);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset, boolean resolveName) {
        return this.referenceReader.readObjectReferenceMDArrayBlockWithOffset(objectPath, blockDimensions, offset, resolveName);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getObjectReferenceArrayNaturalBlocks(String dataSetPath, boolean resolveName) {
        return this.referenceReader.getObjectReferenceArrayNaturalBlocks(dataSetPath, resolveName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getObjectReferenceMDArrayNaturalBlocks(String dataSetPath, boolean resolveName) {
        return this.referenceReader.getObjectReferenceMDArrayNaturalBlocks(dataSetPath, resolveName);
    }

    @Override
    public String[] readObjectReferenceArray(String objectPath) {
        return this.referenceReader.readObjectReferenceArray(objectPath);
    }

    @Override
    public String[] readObjectReferenceArray(String objectPath, boolean resolveName) {
        return this.referenceReader.readObjectReferenceArray(objectPath, resolveName);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArray(String objectPath) {
        return this.referenceReader.readObjectReferenceMDArray(objectPath);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArray(String objectPath, boolean resolveName) {
        return this.referenceReader.readObjectReferenceMDArray(objectPath, resolveName);
    }

    @Override
    public String getObjectReferenceAttribute(String objectPath, String attributeName, boolean resolveName) {
        return this.referenceReader.getObjectReferenceAttribute(objectPath, attributeName, resolveName);
    }

    @Override
    public String[] getObjectReferenceArrayAttribute(String objectPath, String attributeName, boolean resolveName) {
        return this.referenceReader.getObjectReferenceArrayAttribute(objectPath, attributeName, resolveName);
    }

    @Override
    public MDArray<String> getObjectReferenceMDArrayAttribute(String objectPath, String attributeName, boolean resolveName) {
        return this.referenceReader.getObjectReferenceMDArrayAttribute(objectPath, attributeName, resolveName);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        return this.dateTimeReader.readTimeDurationArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5TimeDurationArray>> getTimeDurationArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.dateTimeReader.getTimeDurationArrayNaturalBlocks(objectPath);
    }

    @Override
    public String resolvePath(String reference) throws HDF5JavaException {
        return this.referenceReader.resolvePath(reference);
    }

    @Override
    public String getObjectReferenceAttribute(String objectPath, String attributeName) {
        return this.referenceReader.getObjectReferenceAttribute(objectPath, attributeName);
    }

    @Override
    public String[] getObjectReferenceArrayAttribute(String objectPath, String attributeName) {
        return this.referenceReader.getObjectReferenceArrayAttribute(objectPath, attributeName);
    }

    @Override
    public MDArray<String> getObjectReferenceMDArrayAttribute(String objectPath, String attributeName) {
        return this.referenceReader.getObjectReferenceMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public String[] readObjectReferenceArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.referenceReader.readObjectReferenceArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public String[] readObjectReferenceArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.referenceReader.readObjectReferenceArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.referenceReader.readObjectReferenceMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDArray<String> readObjectReferenceMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.referenceReader.readObjectReferenceMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getObjectReferenceArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.referenceReader.getObjectReferenceArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getObjectReferenceMDArrayNaturalBlocks(String dataSetPath) {
        return this.referenceReader.getObjectReferenceMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public String getStringAttribute(String objectPath, String attributeName) {
        return this.stringReader.getStringAttribute(objectPath, attributeName);
    }

    @Override
    public String[] getStringArrayAttribute(String objectPath, String attributeName) {
        return this.stringReader.getStringArrayAttribute(objectPath, attributeName);
    }

    @Override
    public MDArray<String> getStringMDArrayAttribute(String objectPath, String attributeName) {
        return this.stringReader.getStringMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public String readString(String objectPath) throws HDF5JavaException {
        return this.stringReader.readString(objectPath);
    }

    @Override
    public String[] readStringArray(String objectPath) throws HDF5JavaException {
        return this.stringReader.readStringArray(objectPath);
    }

    @Override
    public String[] readStringArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.stringReader.readStringArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public String[] readStringArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.stringReader.readStringArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDArray<String> readStringMDArray(String objectPath) {
        return this.stringReader.readStringMDArray(objectPath);
    }

    @Override
    public MDArray<String> readStringMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.stringReader.readStringMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDArray<String> readStringMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.stringReader.readStringMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getStringArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.stringReader.getStringArrayNaturalBlocks(objectPath);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getStringMDArrayNaturalBlocks(String objectPath) {
        return this.stringReader.getStringMDArrayNaturalBlocks(objectPath);
    }

    @Override
    public IHDF5EnumReader enums() {
        return this.enumReader;
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5EnumerationValueArray>> getEnumArrayNaturalBlocks(String objectPath, HDF5EnumerationType enumType) throws HDF5JavaException {
        return this.enumReader.getArrayBlocks(objectPath, enumType);
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5EnumerationValueArray>> getEnumArrayNaturalBlocks(String objectPath) throws HDF5JavaException {
        return this.enumReader.getArrayBlocks(objectPath);
    }

    @Override
    public HDF5EnumerationValue readEnum(String objectPath, HDF5EnumerationType enumType) throws HDF5JavaException {
        return this.enumReader.read(objectPath, enumType);
    }

    @Override
    public HDF5EnumerationValue readEnum(String objectPath) throws HDF5JavaException {
        return this.enumReader.read(objectPath);
    }

    @Override
    public <T extends Enum<T>> T readEnum(String objectPath, Class<T> enumClass) throws HDF5JavaException {
        return this.enumReader.read(objectPath, enumClass);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArray(String objectPath, HDF5EnumerationType enumType) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath, enumType);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArray(String objectPath) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath);
    }

    @Override
    public <T extends Enum<T>> T[] readEnumArray(String objectPath, Class<T> enumClass) throws HDF5JavaException {
        return this.readEnumArray(objectPath).toEnumArray(enumClass);
    }

    @Override
    public String[] readEnumArrayAsString(String objectPath) throws HDF5JavaException {
        return this.enumReader.readArray(objectPath).toStringArray();
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlock(String objectPath, HDF5EnumerationType enumType, int blockSize, long blockNumber) {
        return this.enumReader.readArrayBlock(objectPath, enumType, blockSize, blockNumber);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.enumReader.readArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlockWithOffset(String objectPath, HDF5EnumerationType enumType, int blockSize, long offset) {
        return this.enumReader.readArrayBlockWithOffset(objectPath, enumType, blockSize, offset);
    }

    @Override
    public HDF5EnumerationValueArray readEnumArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.enumReader.readArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public String readEnumAsString(String objectPath) throws HDF5JavaException {
        return this.enumReader.readAsString(objectPath);
    }

    @Override
    public IHDF5CompoundReader compounds() {
        return this.compoundReader;
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getCompoundArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.getArrayBlocks(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getCompoundArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.getArrayBlocks(objectPath, type);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getCompoundMDArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.getMDArrayBlocks(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getCompoundMDArrayNaturalBlocks(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.getMDArrayBlocks(objectPath, type);
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getCompoundArrayNaturalBlocks(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.getArrayBlocks(objectPath, pojoClass);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getCompoundMDArrayNaturalBlocks(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.getMDArrayBlocks(objectPath, pojoClass);
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundDataSetInformation(String dataSetPath, boolean sortAlphabetically) throws HDF5JavaException {
        Object[] compoundInformation = this.compoundReader.getDataSetInfo(dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
        if (sortAlphabetically) {
            Arrays.sort(compoundInformation);
        }
        return compoundInformation;
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundDataSetInformation(String dataSetPath) throws HDF5JavaException {
        return this.compoundReader.getDataSetInfo(dataSetPath);
    }

    @Override
    public <T> HDF5CompoundMemberInformation[] getCompoundMemberInformation(Class<T> compoundClass) {
        return this.compoundReader.getMemberInfo(compoundClass);
    }

    @Override
    public HDF5CompoundMemberInformation[] getCompoundMemberInformation(String dataTypeName) {
        return this.compoundReader.getMemberInfo(dataTypeName);
    }

    @Override
    public <T> HDF5CompoundType<T> getCompoundType(Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.compoundReader.getType(pojoClass, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getCompoundType(String name, Class<T> compoundType, HDF5CompoundMemberMapping ... members) {
        return this.compoundReader.getType(name, compoundType, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetCompoundType(String objectPath, Class<T> compoundClass) {
        return this.compoundReader.getDataSetType(objectPath, compoundClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getAttributeCompoundType(String objectPath, String attributeName, Class<T> pojoClass) {
        return this.compoundReader.getAttributeType(objectPath, attributeName, pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(Class<T> pojoClass) {
        return this.compoundReader.getInferredType(pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, Class<T> compoundType) {
        return this.compoundReader.getInferredType(name, compoundType);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, T template) {
        return this.compoundReader.getInferredType(name, template);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(T template) {
        return this.compoundReader.getInferredType(template);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredCompoundType(String name, T template, HDF5CompoundMappingHints hints) {
        return this.compoundReader.getInferredType(name, template, hints);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredCompoundType(String name, List<String> memberNames, List<?> template) {
        return this.compoundReader.getInferredType(name, memberNames, template);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredCompoundType(String name, String[] memberNames, Object[] template) {
        return this.compoundReader.getInferredType(name, memberNames, template);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredCompoundType(List<String> memberNames, List<?> template) {
        return this.compoundReader.getInferredType(memberNames, template);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredCompoundType(String[] memberNames, Object[] template) {
        return this.compoundReader.getInferredType(memberNames, template);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedCompoundType(Class<T> compoundClass) {
        return this.compoundReader.getNamedType(compoundClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedCompoundType(String dataTypeName, Class<T> compoundClass) {
        return this.compoundReader.getNamedType(dataTypeName, compoundClass);
    }

    @Override
    public <T> T readCompound(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.read(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> T readCompound(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.read(objectPath, type);
    }

    @Override
    public <T> T readCompound(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.read(objectPath, pojoClass);
    }

    @Override
    public <T> T[] readCompoundArray(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readArray(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> T[] readCompoundArray(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.readArray(objectPath, type);
    }

    @Override
    public <T> T[] readCompoundArray(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.readArray(objectPath, pojoClass);
    }

    @Override
    public <T> T[] readCompoundArrayBlock(String objectPath, HDF5CompoundType<T> type, int blockSize, long blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readArrayBlock(objectPath, type, blockSize, blockNumber, inspectorOrNull);
    }

    @Override
    public <T> T[] readCompoundArrayBlock(String objectPath, HDF5CompoundType<T> type, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.compoundReader.readArrayBlock(objectPath, type, blockSize, blockNumber);
    }

    @Override
    public <T> T[] readCompoundArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int blockSize, long offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readArrayBlockWithOffset(objectPath, type, blockSize, offset, inspectorOrNull);
    }

    @Override
    public <T> T[] readCompoundArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int blockSize, long offset) throws HDF5JavaException {
        return this.compoundReader.readArrayBlockWithOffset(objectPath, type, blockSize, offset);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArray(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readMDArray(objectPath, type, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArray(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.compoundReader.readMDArray(objectPath, type);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArray(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        return this.compoundReader.readMDArray(objectPath, pojoClass);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlock(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlock(objectPath, type, blockDimensions, blockNumber, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlock(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] blockNumber) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlock(objectPath, type, blockDimensions, blockNumber);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlockWithOffset(objectPath, type, blockDimensions, offset, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readCompoundMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] offset) throws HDF5JavaException {
        return this.compoundReader.readMDArrayBlockWithOffset(objectPath, type, blockDimensions, offset);
    }

    @Override
    public byte[] getByteArrayAttribute(String objectPath, String attributeName) {
        return this.byteReader.getByteArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<byte[]>> getByteArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.byteReader.getByteArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public byte getByteAttribute(String objectPath, String attributeName) {
        return this.byteReader.getByteAttribute(objectPath, attributeName);
    }

    @Override
    public MDByteArray getByteMDArrayAttribute(String objectPath, String attributeName) {
        return this.byteReader.getByteMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDByteArray>> getByteMDArrayNaturalBlocks(String dataSetPath) {
        return this.byteReader.getByteMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public byte[][] getByteMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.byteReader.getByteMatrixAttribute(objectPath, attributeName);
    }

    @Override
    public byte readByte(String objectPath) {
        return this.byteReader.readByte(objectPath);
    }

    @Override
    public byte[] readByteArray(String objectPath) {
        return this.byteReader.readByteArray(objectPath);
    }

    @Override
    public byte[] readByteArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.byteReader.readByteArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public byte[] readByteArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.byteReader.readByteArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDByteArray readByteMDArray(String objectPath) {
        return this.byteReader.readByteMDArray(objectPath);
    }

    @Override
    public MDByteArray readByteMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.byteReader.readByteMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDByteArray readByteMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.byteReader.readByteMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public byte[][] readByteMatrix(String objectPath) throws HDF5JavaException {
        return this.byteReader.readByteMatrix(objectPath);
    }

    @Override
    public byte[][] readByteMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.byteReader.readByteMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public byte[][] readByteMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.byteReader.readByteMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToByteMDArrayBlockWithOffset(String objectPath, MDByteArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.byteReader.readToByteMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToByteMDArrayWithOffset(String objectPath, MDByteArray array, int[] memoryOffset) {
        return this.byteReader.readToByteMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public double[] getDoubleArrayAttribute(String objectPath, String attributeName) {
        return this.doubleReader.getDoubleArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<double[]>> getDoubleArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.doubleReader.getDoubleArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public double getDoubleAttribute(String objectPath, String attributeName) {
        return this.doubleReader.getDoubleAttribute(objectPath, attributeName);
    }

    @Override
    public MDDoubleArray getDoubleMDArrayAttribute(String objectPath, String attributeName) {
        return this.doubleReader.getDoubleMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDDoubleArray>> getDoubleMDArrayNaturalBlocks(String dataSetPath) {
        return this.doubleReader.getDoubleMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public double[][] getDoubleMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.doubleReader.getDoubleMatrixAttribute(objectPath, attributeName);
    }

    @Override
    public double readDouble(String objectPath) {
        return this.doubleReader.readDouble(objectPath);
    }

    @Override
    public double[] readDoubleArray(String objectPath) {
        return this.doubleReader.readDoubleArray(objectPath);
    }

    @Override
    public double[] readDoubleArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.doubleReader.readDoubleArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public double[] readDoubleArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.doubleReader.readDoubleArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDDoubleArray readDoubleMDArray(String objectPath) {
        return this.doubleReader.readDoubleMDArray(objectPath);
    }

    @Override
    public MDDoubleArray readDoubleMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.doubleReader.readDoubleMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDDoubleArray readDoubleMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.doubleReader.readDoubleMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public double[][] readDoubleMatrix(String objectPath) throws HDF5JavaException {
        return this.doubleReader.readDoubleMatrix(objectPath);
    }

    @Override
    public double[][] readDoubleMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.doubleReader.readDoubleMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public double[][] readDoubleMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.doubleReader.readDoubleMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToDoubleMDArrayBlockWithOffset(String objectPath, MDDoubleArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.doubleReader.readToDoubleMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToDoubleMDArrayWithOffset(String objectPath, MDDoubleArray array, int[] memoryOffset) {
        return this.doubleReader.readToDoubleMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public float[] getFloatArrayAttribute(String objectPath, String attributeName) {
        return this.floatReader.getFloatArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<float[]>> getFloatArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.floatReader.getFloatArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public float getFloatAttribute(String objectPath, String attributeName) {
        return this.floatReader.getFloatAttribute(objectPath, attributeName);
    }

    @Override
    public MDFloatArray getFloatMDArrayAttribute(String objectPath, String attributeName) {
        return this.floatReader.getFloatMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDFloatArray>> getFloatMDArrayNaturalBlocks(String dataSetPath) {
        return this.floatReader.getFloatMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public float[][] getFloatMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.floatReader.getFloatMatrixAttribute(objectPath, attributeName);
    }

    @Override
    public float readFloat(String objectPath) {
        return this.floatReader.readFloat(objectPath);
    }

    @Override
    public float[] readFloatArray(String objectPath) {
        return this.floatReader.readFloatArray(objectPath);
    }

    @Override
    public float[] readFloatArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.floatReader.readFloatArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public float[] readFloatArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.floatReader.readFloatArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDFloatArray readFloatMDArray(String objectPath) {
        return this.floatReader.readFloatMDArray(objectPath);
    }

    @Override
    public MDFloatArray readFloatMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.floatReader.readFloatMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDFloatArray readFloatMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.floatReader.readFloatMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public float[][] readFloatMatrix(String objectPath) throws HDF5JavaException {
        return this.floatReader.readFloatMatrix(objectPath);
    }

    @Override
    public float[][] readFloatMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.floatReader.readFloatMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public float[][] readFloatMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.floatReader.readFloatMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToFloatMDArrayBlockWithOffset(String objectPath, MDFloatArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.floatReader.readToFloatMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToFloatMDArrayWithOffset(String objectPath, MDFloatArray array, int[] memoryOffset) {
        return this.floatReader.readToFloatMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public int[] getIntArrayAttribute(String objectPath, String attributeName) {
        return this.intReader.getIntArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<int[]>> getIntArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.intReader.getIntArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public int getIntAttribute(String objectPath, String attributeName) {
        return this.intReader.getIntAttribute(objectPath, attributeName);
    }

    @Override
    public MDIntArray getIntMDArrayAttribute(String objectPath, String attributeName) {
        return this.intReader.getIntMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDIntArray>> getIntMDArrayNaturalBlocks(String dataSetPath) {
        return this.intReader.getIntMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public int[][] getIntMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.intReader.getIntMatrixAttribute(objectPath, attributeName);
    }

    @Override
    public int readInt(String objectPath) {
        return this.intReader.readInt(objectPath);
    }

    @Override
    public int[] readIntArray(String objectPath) {
        return this.intReader.readIntArray(objectPath);
    }

    @Override
    public int[] readIntArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.intReader.readIntArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public int[] readIntArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.intReader.readIntArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDIntArray readIntMDArray(String objectPath) {
        return this.intReader.readIntMDArray(objectPath);
    }

    @Override
    public MDIntArray readIntMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.intReader.readIntMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDIntArray readIntMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.intReader.readIntMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public int[][] readIntMatrix(String objectPath) throws HDF5JavaException {
        return this.intReader.readIntMatrix(objectPath);
    }

    @Override
    public int[][] readIntMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.intReader.readIntMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public int[][] readIntMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.intReader.readIntMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToIntMDArrayBlockWithOffset(String objectPath, MDIntArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.intReader.readToIntMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToIntMDArrayWithOffset(String objectPath, MDIntArray array, int[] memoryOffset) {
        return this.intReader.readToIntMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public long[] getLongArrayAttribute(String objectPath, String attributeName) {
        return this.longReader.getLongArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getLongArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.longReader.getLongArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public long getLongAttribute(String objectPath, String attributeName) {
        return this.longReader.getLongAttribute(objectPath, attributeName);
    }

    @Override
    public MDLongArray getLongMDArrayAttribute(String objectPath, String attributeName) {
        return this.longReader.getLongMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDLongArray>> getLongMDArrayNaturalBlocks(String dataSetPath) {
        return this.longReader.getLongMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public long[][] getLongMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.longReader.getLongMatrixAttribute(objectPath, attributeName);
    }

    @Override
    public long readLong(String objectPath) {
        return this.longReader.readLong(objectPath);
    }

    @Override
    public long[] readLongArray(String objectPath) {
        return this.longReader.readLongArray(objectPath);
    }

    @Override
    public long[] readLongArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.longReader.readLongArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public long[] readLongArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.longReader.readLongArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDLongArray readLongMDArray(String objectPath) {
        return this.longReader.readLongMDArray(objectPath);
    }

    @Override
    public MDLongArray readLongMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.longReader.readLongMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDLongArray readLongMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.longReader.readLongMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public long[][] readLongMatrix(String objectPath) throws HDF5JavaException {
        return this.longReader.readLongMatrix(objectPath);
    }

    @Override
    public long[][] readLongMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.longReader.readLongMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public long[][] readLongMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.longReader.readLongMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToLongMDArrayBlockWithOffset(String objectPath, MDLongArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.longReader.readToLongMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToLongMDArrayWithOffset(String objectPath, MDLongArray array, int[] memoryOffset) {
        return this.longReader.readToLongMDArrayWithOffset(objectPath, array, memoryOffset);
    }

    @Override
    public short[] getShortArrayAttribute(String objectPath, String attributeName) {
        return this.shortReader.getShortArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5DataBlock<short[]>> getShortArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.shortReader.getShortArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public short getShortAttribute(String objectPath, String attributeName) {
        return this.shortReader.getShortAttribute(objectPath, attributeName);
    }

    @Override
    public MDShortArray getShortMDArrayAttribute(String objectPath, String attributeName) {
        return this.shortReader.getShortMDArrayAttribute(objectPath, attributeName);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDShortArray>> getShortMDArrayNaturalBlocks(String dataSetPath) {
        return this.shortReader.getShortMDArrayNaturalBlocks(dataSetPath);
    }

    @Override
    public short[][] getShortMatrixAttribute(String objectPath, String attributeName) throws HDF5JavaException {
        return this.shortReader.getShortMatrixAttribute(objectPath, attributeName);
    }

    @Override
    public short readShort(String objectPath) {
        return this.shortReader.readShort(objectPath);
    }

    @Override
    public short[] readShortArray(String objectPath) {
        return this.shortReader.readShortArray(objectPath);
    }

    @Override
    public short[] readShortArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.shortReader.readShortArrayBlock(objectPath, blockSize, blockNumber);
    }

    @Override
    public short[] readShortArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.shortReader.readShortArrayBlockWithOffset(objectPath, blockSize, offset);
    }

    @Override
    public MDShortArray readShortMDArray(String objectPath) {
        return this.shortReader.readShortMDArray(objectPath);
    }

    @Override
    public MDShortArray readShortMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.shortReader.readShortMDArrayBlock(objectPath, blockDimensions, blockNumber);
    }

    @Override
    public MDShortArray readShortMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.shortReader.readShortMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public short[][] readShortMatrix(String objectPath) throws HDF5JavaException {
        return this.shortReader.readShortMatrix(objectPath);
    }

    @Override
    public short[][] readShortMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        return this.shortReader.readShortMatrixBlock(objectPath, blockSizeX, blockSizeY, blockNumberX, blockNumberY);
    }

    @Override
    public short[][] readShortMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        return this.shortReader.readShortMatrixBlockWithOffset(objectPath, blockSizeX, blockSizeY, offsetX, offsetY);
    }

    @Override
    public int[] readToShortMDArrayBlockWithOffset(String objectPath, MDShortArray array, int[] blockDimensions, long[] offset, int[] memoryOffset) {
        return this.shortReader.readToShortMDArrayBlockWithOffset(objectPath, array, blockDimensions, offset, memoryOffset);
    }

    @Override
    public int[] readToShortMDArrayWithOffset(String objectPath, MDShortArray array, int[] memoryOffset) {
        return this.shortReader.readToShortMDArrayWithOffset(objectPath, array, memoryOffset);
    }
}

