/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.HDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.File;

final class HDF5WriterConfigurator
extends HDF5ReaderConfigurator
implements IHDF5WriterConfigurator {
    private boolean useExtentableDataTypes = true;
    private boolean overwriteFile = false;
    private boolean keepDataSetIfExists = false;
    private IHDF5WriterConfigurator.FileFormat fileFormat = IHDF5WriterConfigurator.FileFormat.ALLOW_1_8;
    private IHDF5WriterConfigurator.SyncMode syncMode = OSUtilities.isWindows() ? IHDF5WriterConfigurator.SyncMode.SYNC_ON_FLUSH_BLOCK : IHDF5WriterConfigurator.SyncMode.SYNC_ON_FLUSH;

    public HDF5WriterConfigurator(File hdf5File) {
        super(hdf5File);
    }

    public HDF5WriterConfigurator overwrite() {
        this.overwriteFile = true;
        return this;
    }

    public HDF5WriterConfigurator keepDataSetsIfTheyExist() {
        this.keepDataSetIfExists = true;
        return this;
    }

    public HDF5WriterConfigurator dontUseExtendableDataTypes() {
        this.useExtentableDataTypes = false;
        return this;
    }

    public HDF5WriterConfigurator fileFormat(IHDF5WriterConfigurator.FileFormat newFileFormat) {
        this.fileFormat = newFileFormat;
        return this;
    }

    public HDF5WriterConfigurator syncMode(IHDF5WriterConfigurator.SyncMode newSyncMode) {
        this.syncMode = newSyncMode;
        return this;
    }

    public HDF5WriterConfigurator performNumericConversions() {
        return (HDF5WriterConfigurator)super.performNumericConversions();
    }

    public HDF5WriterConfigurator useUTF8CharacterEncoding() {
        return (HDF5WriterConfigurator)super.useUTF8CharacterEncoding();
    }

    public HDF5WriterConfigurator noAutoDereference() {
        return (HDF5WriterConfigurator)super.noAutoDereference();
    }

    public IHDF5Writer writer() {
        if (this.readerWriterOrNull == null) {
            this.readerWriterOrNull = new HDF5Writer(new HDF5BaseWriter(this.hdf5File, this.performNumericConversions, this.useUTF8CharEncoding, this.autoDereference, this.fileFormat, this.useExtentableDataTypes, this.overwriteFile, this.keepDataSetIfExists, this.syncMode));
        }
        return (HDF5Writer)this.readerWriterOrNull;
    }
}

