/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.hdf5.HDF5ObjectInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.ArchiverException;
import ch.systemsx.cisd.hdf5.h5ar.IArchiveEntryProcessor;
import ch.systemsx.cisd.hdf5.h5ar.IListEntryVisitor;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.ListArchiveException;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

class ArchiveEntryListProcessor
implements IArchiveEntryProcessor {
    private final IListEntryVisitor visitor;
    private final byte[] buffer;
    private final boolean checkArchive;

    ArchiveEntryListProcessor(IListEntryVisitor visitor, byte[] buffer, boolean checkArchive) {
        this.visitor = visitor;
        this.buffer = buffer;
        this.checkArchive = checkArchive;
    }

    public boolean process(String dir, String path, LinkRecord link, IHDF5Reader reader, IdCache idCache, IErrorStrategy errorStrategy) throws IOException {
        String errorMessage = null;
        if (this.checkArchive) {
            HDF5ObjectInformation info = reader.getObjectInformation(path);
            FileLinkType verifiedType = Utils.translateType(info.getType());
            link.setVerifiedType(verifiedType);
            if (verifiedType == FileLinkType.REGULAR_FILE) {
                long verifiedSize = reader.getSize(path);
                int verifiedCrc32 = 0;
                try {
                    verifiedCrc32 = this.calcCRC32Archive(path, verifiedSize, reader);
                }
                catch (HDF5Exception ex) {
                    errorMessage = String.valueOf(ex.getClass().getSimpleName()) + ": " + ex.getMessage();
                }
                link.setFileVerification(verifiedSize, verifiedCrc32);
            }
        }
        this.visitor.visit(new ArchiveEntry(dir, path, link, idCache, errorMessage));
        return true;
    }

    public void postProcessDirectory(String dir, String path, LinkRecord link, IHDF5Reader reader, IdCache idCache, IErrorStrategy errorStrategy) throws IOException, HDF5Exception {
    }

    private int calcCRC32Archive(String objectPath, long size, IHDF5Reader hdf5Reader) {
        CRC32 crc32Digest = new CRC32();
        long offset = 0L;
        while (offset < size) {
            int n = hdf5Reader.readAsByteArrayToBlockWithOffset(objectPath, this.buffer, this.buffer.length, offset, 0);
            offset += (long)n;
            crc32Digest.update(this.buffer, 0, n);
        }
        return (int)crc32Digest.getValue();
    }

    public ArchiverException createException(String objectPath, String detailedMsg) {
        return new ListArchiveException(objectPath, detailedMsg);
    }

    public ArchiverException createException(String objectPath, HDF5Exception cause) {
        return new ListArchiveException(objectPath, cause);
    }

    public ArchiverException createException(String objectPath, RuntimeException cause) {
        return new ListArchiveException(objectPath, cause);
    }

    public ArchiverException createException(File file, IOException cause) {
        return new ListArchiveException(file, cause);
    }
}

