/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.alignment.template;

import java.util.ArrayList;
import java.util.List;
import org.biojava3.alignment.template.AbstractMatrixAligner;
import org.biojava3.alignment.template.GapPenalty;
import org.biojava3.alignment.template.PairwiseSequenceAligner;
import org.biojava3.alignment.template.SequencePair;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;

public abstract class AbstractPairwiseSequenceAligner<S extends Sequence<C>, C extends Compound>
extends AbstractMatrixAligner<S, C>
implements PairwiseSequenceAligner<S, C> {
    private S query;
    private S target;
    protected SequencePair<S, C> pair;

    protected AbstractPairwiseSequenceAligner() {
    }

    protected AbstractPairwiseSequenceAligner(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        this(query, target, gapPenalty, subMatrix, false);
    }

    protected AbstractPairwiseSequenceAligner(S query, S target, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix, boolean local) {
        super(gapPenalty, subMatrix, local);
        this.query = query;
        this.target = target;
        this.reset();
    }

    public void setQuery(S query) {
        this.query = query;
        this.reset();
    }

    public void setTarget(S target) {
        this.target = target;
        this.reset();
    }

    @Override
    public SequencePair<S, C> getPair() {
        if (this.pair == null) {
            this.align();
        }
        return this.pair;
    }

    @Override
    public S getQuery() {
        return this.query;
    }

    @Override
    public S getTarget() {
        return this.target;
    }

    @Override
    protected CompoundSet<C> getCompoundSet() {
        return this.query == null ? null : this.query.getCompoundSet();
    }

    @Override
    protected List<C> getCompoundsOfQuery() {
        return this.query == null ? new ArrayList() : this.query.getAsList();
    }

    @Override
    protected List<C> getCompoundsOfTarget() {
        return this.target == null ? new ArrayList() : this.target.getAsList();
    }

    @Override
    protected int[] getScoreMatrixDimensions() {
        return new int[]{this.query == null ? 1 : this.query.getLength() + 1, this.target == null ? 1 : this.target.getLength() + 1, this.getGapPenalty() == null || this.getGapPenalty().getType() == GapPenalty.Type.LINEAR ? 1 : 3};
    }

    @Override
    protected short getSubstitutionScore(int queryColumn, int targetColumn) {
        return this.getSubstitutionMatrix().getValue(this.query.getCompoundAt(queryColumn), this.target.getCompoundAt(targetColumn));
    }

    @Override
    protected boolean isReady() {
        return this.query != null && this.target != null && this.getGapPenalty() != null && this.getSubstitutionMatrix() != null && this.query.getCompoundSet().equals(this.target.getCompoundSet());
    }

    @Override
    protected void reset() {
        super.reset();
        this.pair = null;
        if (this.query != null && this.target != null && this.getGapPenalty() != null && this.getSubstitutionMatrix() != null && this.query.getCompoundSet().equals(this.target.getCompoundSet())) {
            int maxq = 0;
            int maxt = 0;
            for (Compound c : this.query) {
                maxq += this.getSubstitutionMatrix().getValue(c, c);
            }
            for (Compound c : this.target) {
                maxt += this.getSubstitutionMatrix().getValue(c, c);
            }
            this.max = (short)Math.max(maxq, maxt);
            this.min = this.isLocal() ? (short)0 : (short)(2 * this.getGapPenalty().getOpenPenalty() + (this.query.getLength() + this.target.getLength()) * this.getGapPenalty().getExtensionPenalty());
            this.score = this.min;
        }
    }
}

