/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.apache.batik.css.AbstractCSSRule;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMStyleDeclaration;
import org.apache.batik.css.DocumentHandlerAdapter;
import org.apache.batik.css.event.CSSPropertyChangeEvent;
import org.apache.batik.css.event.CSSStyleDeclarationChangeEvent;
import org.apache.batik.css.event.CSSStyleDeclarationChangeListener;
import org.apache.batik.css.event.CSSStyleRuleChangeListener;
import org.apache.batik.css.event.CSSStyleRuleChangeSupport;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.css.parser.ExtendedParserWrapper;
import org.apache.batik.css.value.ValueFactory;
import org.apache.batik.css.value.ValueFactoryMap;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSOMStyleRule
extends AbstractCSSRule
implements CSSStyleRule,
CSSStyleDeclarationChangeListener {
    protected SelectorList selectors;
    protected CSSOMStyleDeclaration style;
    protected ExtendedParser parser;
    protected ValueFactoryMap factories;
    protected DocumentHandler ruleHandler = new StyleRuleHandler();
    protected CSSStyleRuleChangeSupport styleRuleChangeSupport;
    protected URL baseURI;

    public CSSOMStyleRule(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule, Parser parser, ValueFactoryMap valueFactoryMap) {
        super(cSSStyleSheet, cSSRule);
        this.parser = ExtendedParserWrapper.wrap(parser);
        this.factories = valueFactoryMap;
        this.style = new CSSOMStyleDeclaration(this, parser);
        this.style.setValueFactoryMap(valueFactoryMap);
        this.style.addCSSStyleDeclarationChangeListener(this);
    }

    public void setBaseURI(URL uRL) {
        this.baseURI = uRL;
    }

    public URL getBaseURI() {
        return this.baseURI;
    }

    public short getType() {
        return 1;
    }

    public String getCssText() {
        if (this.selectors == null) {
            return "";
        }
        return this.getSelectorText() + " {\n" + this.style.getCssText() + "}";
    }

    public void setCssText(String string) throws DOMException {
        SelectorList selectorList = this.selectors;
        CSSOMStyleDeclaration cSSOMStyleDeclaration = this.style;
        try {
            this.fireCSSStyleRuleChangeStart();
            this.style = new CSSOMStyleDeclaration(this, this.parser);
            this.style.addCSSStyleDeclarationChangeListener(this);
            this.style.fireCSSStyleDeclarationChangeStart();
            this.parser.setSelectorFactory(AbstractCSSRule.SELECTOR_FACTORY);
            this.parser.setConditionFactory(AbstractCSSRule.CONDITION_FACTORY);
            this.parser.setDocumentHandler(this.ruleHandler);
            this.parser.parseRule(string);
        }
        catch (DOMException dOMException) {
            this.style.fireCSSStyleDeclarationChangeCancel();
            this.fireCSSStyleRuleChangeCancel();
            this.selectors = selectorList;
            this.style = cSSOMStyleDeclaration;
            throw CSSDOMExceptionFactory.createDOMException((short)15, "style.rule.value", new Object[]{string + "\n" + dOMException.getMessage()});
        }
        catch (Exception exception) {
            this.style.fireCSSStyleDeclarationChangeCancel();
            this.fireCSSStyleRuleChangeCancel();
            this.selectors = selectorList;
            this.style = cSSOMStyleDeclaration;
            throw CSSDOMExceptionFactory.createDOMException((short)15, "style.rule.value", new Object[]{string});
        }
        this.style.fireCSSStyleDeclarationChangeEnd();
        cSSOMStyleDeclaration.setCssText("");
        cSSOMStyleDeclaration.removeCSSStyleDeclarationChangeListener(this);
        this.fireCSSStyleRuleChangeEnd();
    }

    public String getSelectorText() {
        if (this.selectors == null) {
            return "";
        }
        String string = this.selectors.item(0).toString();
        int n = 1;
        while (n < this.selectors.getLength()) {
            string = string + ", " + this.selectors.item(n);
            ++n;
        }
        return string;
    }

    public void setSelectorText(String string) throws DOMException {
        try {
            InputSource inputSource = new InputSource((Reader)new StringReader(string));
            this.parser.setSelectorFactory(AbstractCSSRule.SELECTOR_FACTORY);
            this.parser.setConditionFactory(AbstractCSSRule.CONDITION_FACTORY);
            SelectorList selectorList = this.selectors;
            this.selectors = this.parser.parseSelectors(inputSource);
            if (this.styleRuleChangeSupport != null) {
                this.styleRuleChangeSupport.fireSelectorListChange(selectorList, this.selectors);
            }
        }
        catch (Exception exception) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "selector.value", new Object[]{string});
        }
    }

    public void setSelectors(SelectorList selectorList) {
        this.selectors = selectorList;
    }

    public SelectorList getSelectors() {
        return this.selectors;
    }

    public CSSStyleDeclaration getStyle() {
        return this.style;
    }

    public void addCSSStyleRuleChangeListener(CSSStyleRuleChangeListener cSSStyleRuleChangeListener) {
        if (this.styleRuleChangeSupport == null) {
            this.styleRuleChangeSupport = new CSSStyleRuleChangeSupport(this);
        }
        this.styleRuleChangeSupport.addCSSStyleRuleChangeListener(cSSStyleRuleChangeListener);
    }

    public void removeCSSStyleRuleChangeListener(CSSStyleRuleChangeListener cSSStyleRuleChangeListener) {
        if (this.styleRuleChangeSupport == null) {
            return;
        }
        this.styleRuleChangeSupport.removeCSSStyleRuleChangeListener(cSSStyleRuleChangeListener);
    }

    public void cssStyleDeclarationChangeStart(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        if (this.styleRuleChangeSupport != null) {
            this.styleRuleChangeSupport.fireCSSStyleDeclarationChangeStart();
        }
    }

    public void cssStyleDeclarationChangeCancel(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        if (this.styleRuleChangeSupport != null) {
            this.styleRuleChangeSupport.fireCSSStyleDeclarationChangeCancel();
        }
    }

    public void cssStyleDeclarationChangeEnd(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        if (this.styleRuleChangeSupport != null) {
            this.styleRuleChangeSupport.fireCSSStyleDeclarationChangeEnd();
        }
    }

    public void cssPropertyChange(CSSPropertyChangeEvent cSSPropertyChangeEvent) {
        if (this.styleRuleChangeSupport != null) {
            this.styleRuleChangeSupport.fireCSSPropertyChange(cSSPropertyChangeEvent.getPropertyName(), cSSPropertyChangeEvent.getOldValue(), cSSPropertyChangeEvent.getNewValue());
        }
    }

    public void fireCSSStyleRuleChangeStart() {
        if (this.styleRuleChangeSupport == null) {
            return;
        }
        this.styleRuleChangeSupport.fireCSSStyleRuleChangeStart();
    }

    public void fireCSSStyleRuleChangeCancel() {
        if (this.styleRuleChangeSupport == null) {
            return;
        }
        this.styleRuleChangeSupport.fireCSSStyleRuleChangeCancel();
    }

    public void fireCSSStyleRuleChangeEnd() {
        if (this.styleRuleChangeSupport == null) {
            return;
        }
        this.styleRuleChangeSupport.fireCSSStyleRuleChangeEnd();
    }

    protected class StyleRuleHandler
    extends DocumentHandlerAdapter {
        protected StyleRuleHandler() {
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            SelectorList selectorList2 = CSSOMStyleRule.this.selectors;
            CSSOMStyleRule.this.selectors = selectorList;
            if (CSSOMStyleRule.this.styleRuleChangeSupport != null) {
                CSSOMStyleRule.this.styleRuleChangeSupport.fireSelectorListChange(selectorList2, selectorList);
            }
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            String string2 = bl ? "!important" : "";
            ValueFactory valueFactory = CSSOMStyleRule.this.factories.get(string);
            valueFactory.createCSSValue(lexicalUnit, CSSOMStyleRule.this.style, string2);
        }
    }
}

