/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;

public class perfume {
    private static final String BASE = "b_";

    public static void main(String[] args) {
        if (args.length != 2) {
            System.exit(-1);
        }
        try {
            CommandLineArguments cla = null;
            cla = new CommandLineArguments(args);
            File in = cla.getFile(0);
            File out = cla.getFile(1);
            if (out.exists()) {
                System.out.println(out + " already exists");
                System.exit(-1);
            }
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhyloXmlParser xml_parser = new PhyloXmlParser();
            Phylogeny[] phylogenies_0 = factory.create(in, xml_parser);
            Phylogeny phylogeny_0 = phylogenies_0[0];
            PhylogenyNodeIterator it = phylogeny_0.iteratorPostorder();
            int i = 0;
            while (it.hasNext()) {
                PhylogenyNode node = it.next();
                perfume.processNode(node, i);
                ++i;
            }
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(out, phylogeny_0, 0);
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void processNode(PhylogenyNode node, int i) {
        node.setDistanceToParent(-1024.0);
        if (!node.isExternal() && (node.getNodeName() == null || node.getNodeName().isEmpty())) {
            node.setName(BASE + i);
        }
    }
}

