/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class printSameOrder {
    public static void main(String[] args) {
        Phylogeny tree = null;
        PhylogenyNode node = null;
        PrintWriter out = null;
        File infile = null;
        File outfile = null;
        if (args.length != 2) {
            System.err.println("\nprintSameOrder: Wrong number of arguments.");
            System.err.println("Usage: \"java printSameOrder <infile> <outfile>\"\n");
            System.exit(-1);
        }
        infile = new File(args[0]);
        outfile = new File(args[1]);
        try {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser pp = ForesterUtil.createParserDependingOnFileType(infile, true);
            tree = factory.create(infile, pp)[0];
        }
        catch (Exception e) {
            System.err.println(e + "\nCould not read " + infile + "\n");
            System.exit(-1);
        }
        node = tree.getFirstExternalNode();
        try {
            try {
                out = new PrintWriter((Writer)new FileWriter(outfile), true);
                while (node != null) {
                    out.println(node.getNodeName());
                    node = node.getNextExternalNode();
                }
            }
            catch (Exception e) {
                System.err.println(e + "\nException during writing.\n");
                System.exit(-1);
                out.close();
            }
        }
        finally {
            out.close();
        }
    }
}

