/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDI;
import org.forester.sdi.SDIse;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class ta {
    private static final String STRIP_OPTION = "s";
    private static final String SDISE_OPTION = "b";
    private static final String MOST_PARSIMONIOUS_OPTION = "m";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String DEFAULT_OUTFILE = "sdi_out.xml";
    private static final String PRG_NAME = "sdi";
    private static final String PRG_VERSION = "alpha 0.3";
    private static final String PRG_DATE = "2008.03.04";

    public static void main(String[] args) {
        PhylogenyParser pp;
        PhylogenyFactory factory;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        CommandLineArguments cla = null;
        try {
            cla = new CommandLineArguments(args);
        }
        catch (Exception e) {
            ForesterUtil.fatalError(PRG_NAME, e.getMessage());
        }
        if (cla.isOptionSet(HELP_OPTION_1) || cla.isOptionSet(HELP_OPTION_2)) {
            System.out.println();
            ta.print_help();
            System.exit(0);
        } else if (args.length < 2 || cla.getNumberOfNames() < 2 || cla.getNumberOfNames() > 3) {
            System.out.println();
            System.out.println("Wrong number of arguments.");
            System.out.println();
            ta.print_help();
            System.exit(-1);
        }
        ArrayList<String> allowed_options = new ArrayList<String>();
        allowed_options.add(STRIP_OPTION);
        allowed_options.add(SDISE_OPTION);
        allowed_options.add(MOST_PARSIMONIOUS_OPTION);
        String dissallowed_options = cla.validateAllowedOptionsAsString(allowed_options);
        if (dissallowed_options.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + dissallowed_options);
        }
        boolean use_sdise = false;
        boolean strip2 = false;
        boolean most_parsimonous_duplication_model = false;
        if (cla.isOptionSet(STRIP_OPTION)) {
            strip2 = true;
        }
        if (cla.isOptionSet(SDISE_OPTION)) {
            use_sdise = true;
        }
        if (cla.isOptionSet(MOST_PARSIMONIOUS_OPTION)) {
            if (use_sdise) {
                ForesterUtil.fatalError(PRG_NAME, "Can only use most parsimonious duplication mode with GSDI");
            }
            most_parsimonous_duplication_model = true;
        }
        Phylogeny species_tree = null;
        Phylogeny gene_tree = null;
        File gene_tree_file = null;
        File species_tree_file = null;
        File out_file = null;
        try {
            gene_tree_file = cla.getFile(0);
            species_tree_file = cla.getFile(1);
            out_file = cla.getNumberOfNames() == 3 ? cla.getFile(2) : new File(DEFAULT_OUTFILE);
        }
        catch (IllegalArgumentException e) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + e.getMessage());
        }
        if (ForesterUtil.isReadableFile(gene_tree_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(gene_tree_file));
        }
        if (ForesterUtil.isReadableFile(species_tree_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(species_tree_file));
        }
        if (ForesterUtil.isWritableFile(out_file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(out_file));
        }
        try {
            factory = ParserBasedPhylogenyFactory.getInstance();
            pp = ForesterUtil.createParserDependingOnFileType(species_tree_file, true);
            species_tree = factory.create(species_tree_file, pp)[0];
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to read species tree from \"" + gene_tree_file + "\" [" + e.getMessage() + "]");
        }
        try {
            factory = ParserBasedPhylogenyFactory.getInstance();
            pp = ForesterUtil.createParserDependingOnFileType(gene_tree_file, true);
            gene_tree = factory.create(gene_tree_file, pp)[0];
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to read gene tree from \"" + gene_tree_file + "\" [" + e.getMessage() + "]");
        }
        gene_tree.setRooted(true);
        species_tree.setRooted(true);
        if (!gene_tree.isCompletelyBinary()) {
            ForesterUtil.fatalError(PRG_NAME, "gene tree is not completely binary.");
        }
        if (use_sdise && !species_tree.isCompletelyBinary()) {
            ForesterUtil.fatalError(PRG_NAME, "species tree is not completely binary.");
        }
        System.out.println();
        System.out.println("Strip species tree: " + strip2);
        SDI sdi2 = null;
        long start_time = new Date().getTime();
        try {
            if (use_sdise) {
                System.out.println();
                System.out.println("Using SDIse algorithm.");
                sdi2 = new SDIse(gene_tree, species_tree);
            } else {
                System.out.println();
                System.out.println("Using GSDI algorithm.");
                System.out.println();
                System.out.println("Use most parsimonous duplication model: " + most_parsimonous_duplication_model);
                sdi2 = new GSDI(gene_tree, species_tree, most_parsimonous_duplication_model);
            }
        }
        catch (Exception e) {
            ForesterUtil.unexpectedFatalError(PRG_NAME, e);
        }
        System.out.println();
        System.out.println("Running time (excluding I/O): " + (new Date().getTime() - start_time) + "ms");
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(out_file, gene_tree, 1);
        }
        catch (IOException e) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to \"" + out_file + "\" [" + e.getMessage() + "]");
        }
        System.out.println();
        System.out.println("Successfully wrote resulting gene tree to: " + out_file);
        System.out.println();
        if (!use_sdise && !most_parsimonous_duplication_model) {
            System.out.println("Number of potential duplications: " + ((GSDI)sdi2).getSpeciationOrDuplicationEventsSum());
        }
        if (!use_sdise) {
            System.out.println("Number speciations              : " + ((GSDI)sdi2).getSpeciationsSum());
        }
        System.out.println();
    }

    private static void print_help() {
        System.out.println("Usage: \"sdi [-options] <gene tree file name> <species tree file name>  [outfile name]\"");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -s: to strip the species tree prior to duplication inference");
        System.out.println(" -b: to use SDIse algorithm instead of GSDI algorithm (for binary trees only, faster)");
        System.out.println(" -m: use most parimonious duplication model for GSDI: ");
        System.out.println("     assign nodes as speciations which would otherwise be assiged");
        System.out.println("     as unknown because of polytomies in the species tree");
        System.out.println();
        System.out.println("Species tree file");
        System.out.println(" In NHX format, with species names in species name fields unless -n option");
        System.out.println(" is used.");
        System.out.println();
        System.out.println("Gene tree file");
        System.out.println(" In NHX format, with species names in species name fields and sequence names");
        System.out.println(" in sequence name fields.");
        System.out.println();
        System.out.println("!! WARNING: GSDI algorithm is under development, please use SDIse (-b) instead  !!");
        System.out.println();
    }
}

