/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;

final class PdfWriter {
    private PdfWriter() {
    }

    public static String writePhylogenyToPdf(String file_name, TreePanel tree_panel, Options options) throws IOException {
        return PdfWriter.writePhylogenyToPdf(file_name, tree_panel, options, 0, 0);
    }

    public static String writePhylogenyToPdf(String file_name, TreePanel tree_panel, Options options, int width, int height) throws IOException {
        Phylogeny phylogeny = tree_panel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        File file = new File(file_name);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("[" + file_name + "] is a directory");
        }
        FileOutputStream os = new FileOutputStream(file);
        os.flush();
        os.close();
        String msg = file.toString();
        if (width > 0 && height > 0) {
            msg = String.valueOf(msg) + " [size: " + width + ", " + height + "]";
        }
        return msg;
    }
}

