/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.webservices;

import java.util.ArrayList;
import java.util.List;
import org.forester.archaeopteryx.webservices.BasicPhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

public final class WebserviceUtil {
    public static final String TAX_CODE_TO_SCI_NAME = "tax_code_to_sci_name";
    public static final String TREE_FAM_INST = "tree_fam";
    public static final String PFAM_INST = "pfam";
    public static final String TOL_WEBSERVER = "http://tolweb.org/onlinecontributors/app?service=external&page=xml/TreeStructureService&node_id=__query__";
    public static final String TOL_NAME = "Tree of Life";
    public static final String TREE_BASE_NAME = "TreeBase";
    public static final String TREE_FAM_NAME = "TreeFam";
    public static final String PFAM_NAME = "Pfam";
    public static final String PFAM_SERVER = "http://pfam.janelia.org";

    public static List<PhylogeniesWebserviceClient> createDefaultClients() {
        ArrayList<PhylogeniesWebserviceClient> clients = new ArrayList<PhylogeniesWebserviceClient>();
        clients.add(new BasicPhylogeniesWebserviceClient(TOL_NAME, "Read Tree from Tree of Life...", "Use ToL webservice to obtain a phylogeny", "Please enter a Tree of Life node identifier\n(Examples: 19386 for Cephalopoda, 2461 for Cnidaria, 2466 for Deuterostomia)", WebservicesManager.WsPhylogenyFormat.TOL_XML_RESPONSE, ForesterUtil.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, TOL_WEBSERVER, true, "http://tolweb.org", null));
        clients.add(new BasicPhylogeniesWebserviceClient(TREE_BASE_NAME, "Read Tree from TreeBase...", "Use TreeBase to obtain a phylogeny", "Please enter a TreeBase tree identifier\n(Examples: 2654, 825, 3306, 2518, 2406)", WebservicesManager.WsPhylogenyFormat.NH, ForesterUtil.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, "http://130.132.27.194/treebase/TreeBASE.acgi?PickedItems=Tree__query__&Button=ATV.nhx", true, "http://www.treebase.org", TAX_CODE_TO_SCI_NAME));
        clients.add(new BasicPhylogeniesWebserviceClient(PFAM_NAME, "Read Gene Tree from Pfam...", "Use  Pfam to obtain a (full) gene tree", "Please enter a Pfam (PF) accession number\n(Examples: 01849 for NAC, 00452 for Bcl-2, 00046 for Homeobox)", WebservicesManager.WsPhylogenyFormat.PFAM, null, "http://pfam.janelia.org/family/tree/download?alnType=full&acc=PF__query__", false, PFAM_SERVER, PFAM_INST));
        clients.add(new BasicPhylogeniesWebserviceClient(TREE_FAM_NAME, "Read Full Gene Tree from TreeFam...", "Use TreeFam to obtain a (full) gene tree", "Please enter a TreeFam (TF) accession number\n(Examples: 101004 for Cyclin D, 315938 for Hox, 105310 for Wnt)", WebservicesManager.WsPhylogenyFormat.NHX, null, "http://www.treefam.org/cgi-bin/getdata.pl?ac=TF__query__&f=full.nhx", true, "http://www.treefam.org", TREE_FAM_INST));
        clients.add(new BasicPhylogeniesWebserviceClient(TREE_FAM_NAME, "Read Clean Gene Tree from TreeFam...", "Use TreeFam to obtain a (\"clean\") gene tree", "Please enter a TreeFam (TF) accession number\n(Examples: 101004 for Cyclin D, 315938 for Hox, 105310 for Wnt)", WebservicesManager.WsPhylogenyFormat.NHX, null, "http://www.treefam.org/cgi-bin/getdata.pl?ac=TF__query__&f=clean.nhx", true, "http://www.treefam.org", TREE_FAM_INST));
        return clients;
    }

    static void extractSpTremblAccFromNodeName(Phylogeny phy, String source) {
        PreorderTreeIterator it = new PreorderTreeIterator(phy);
        while (it.hasNext()) {
            String acc_str;
            String name;
            int i;
            PhylogenyNode n = it.next();
            if (ForesterUtil.isEmpty(n.getNodeName()) || (i = (name = n.getNodeName()).lastIndexOf("/")) <= 0 || ForesterUtil.isEmpty(acc_str = name.substring(0, i))) continue;
            Sequence seq = new Sequence();
            Accession acc = new Accession(acc_str, source);
            seq.setAccession(acc);
            n.getNodeData().setSequence(seq);
        }
    }

    public static void processInstructions(PhylogeniesWebserviceClient client, Phylogeny phylogeny) {
        if (client.getProcessingInstructions().equals(TAX_CODE_TO_SCI_NAME)) {
            WebserviceUtil.transferTaxonomyCodeToScientificName(phylogeny);
        } else if (client.getProcessingInstructions().equals(TREE_FAM_INST)) {
            WebserviceUtil.transferInternalTaxonomyCodeToScientificName(phylogeny);
            WebserviceUtil.transferExternalScientificNameToTaxonomyCode(phylogeny);
            WebserviceUtil.transferSequenceNameToSequenceAccession(phylogeny, "ensembl");
            WebserviceUtil.setTaxonomyIdentifierType(phylogeny, "ncbi");
        } else if (client.getProcessingInstructions().equals(PFAM_INST)) {
            WebserviceUtil.extractSpTremblAccFromNodeName(phylogeny, "sptrembl");
        }
    }

    static void setTaxonomyIdentifierType(Phylogeny phy, String type) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().getIdentifier() == null) continue;
            n.getNodeData().getTaxonomy().setIdentifier(new Identifier(n.getNodeData().getTaxonomy().getIdentifier().getValue(), type));
        }
    }

    static void transferExternalScientificNameToTaxonomyCode(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            String name;
            PhylogenyNode n = it.next();
            if (!n.isExternal() || !n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(name = n.getNodeData().getTaxonomy().getScientificName()) || !PhyloXmlUtil.TAXOMONY_CODE_PATTERN.matcher(name).matches()) continue;
            n.getNodeData().getTaxonomy().setScientificName("");
            n.getNodeData().getTaxonomy().setTaxonomyCode(name);
        }
    }

    static void transferInternalTaxonomyCodeToScientificName(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            String name;
            PhylogenyNode n = it.next();
            if (n.isExternal() || !n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(name = n.getNodeData().getTaxonomy().getTaxonomyCode())) continue;
            n.getNodeData().getTaxonomy().setScientificName(name);
            n.getNodeData().getTaxonomy().setTaxonomyCode("");
        }
    }

    static void transferSequenceNameToSequenceAccession(Phylogeny phy, String source) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            String name;
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasSequence() || ForesterUtil.isEmpty(name = n.getNodeData().getSequence().getName())) continue;
            n.getNodeData().getSequence().setName("");
            n.getNodeData().getSequence().setAccession(new Accession(name, source));
        }
    }

    static void transferTaxonomyCodeToScientificName(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            String name;
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(name = n.getNodeData().getTaxonomy().getTaxonomyCode())) continue;
            n.getNodeData().getTaxonomy().setScientificName(name);
            n.getNodeData().getTaxonomy().setTaxonomyCode("");
        }
    }
}

