/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;
import org.forester.util.ForesterUtil;

public class PropertyParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new PropertyParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private PropertyParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhylogenyParserException {
        String ref = "";
        String value = "";
        String unit = "";
        String datatype = "";
        String applies_to_str = "";
        String id_ref = "";
        if (element.isHasAttribute("ref")) {
            ref = element.getAttribute("ref");
        }
        if (element.isHasAttribute("unit")) {
            unit = element.getAttribute("unit");
        }
        if (element.isHasAttribute("datatype")) {
            datatype = element.getAttribute("datatype");
        }
        if (element.isHasAttribute("applies_to")) {
            applies_to_str = element.getAttribute("applies_to");
        }
        if (element.isHasAttribute("id_ref")) {
            id_ref = element.getAttribute("id_ref");
        }
        if (!ForesterUtil.isEmpty(element.getValueAsString())) {
            value = element.getValueAsString();
        }
        Property.AppliesTo applies_to = Property.AppliesTo.OTHER;
        if (applies_to_str.equals(Property.AppliesTo.NODE.toString())) {
            applies_to = Property.AppliesTo.NODE;
        } else if (applies_to_str.equals(Property.AppliesTo.PARENT_BRANCH.toString())) {
            applies_to = Property.AppliesTo.PARENT_BRANCH;
        } else if (applies_to_str.equals(Property.AppliesTo.CLADE.toString())) {
            applies_to = Property.AppliesTo.CLADE;
        } else if (applies_to_str.equals(Property.AppliesTo.ANNOTATION.toString())) {
            applies_to = Property.AppliesTo.ANNOTATION;
        } else if (applies_to_str.equals(Property.AppliesTo.PHYLOGENY.toString())) {
            applies_to = Property.AppliesTo.PHYLOGENY;
        }
        return new Property(ref, value, unit, datatype, applies_to, id_ref);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

