/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.util.SortedMap;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.pccx.ModelingUtils;
import org.forester.pccx.ScoringMethodForExternalNode;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;

public class BranchCountingBasedScoringMethod
implements ScoringMethodForExternalNode {
    double calculateScoreContributionPerExternalNode(PhylogenyNode external_node, PhylogenyNode current_node) {
        double score_contribution = 0.0;
        score_contribution = current_node == external_node ? 1.0 : 1.0 / (double)ModelingUtils.calculateBranchSum(external_node, current_node);
        return score_contribution;
    }

    @Override
    public void calculateScoreForExternalNode(SortedMap<PhylogenyNode, Double> external_node_scores, Phylogeny phylogeny, PhylogenyNode external_node, CoverageCalculationOptions options) {
        for (PhylogenyNode element : external_node_scores.keySet()) {
            double prev_score_contribution;
            PhylogenyNode current_node = element;
            double score_contribution = this.calculateScoreContributionPerExternalNode(external_node, current_node);
            if (!(score_contribution > (prev_score_contribution = ((Double)external_node_scores.get(current_node)).doubleValue()))) continue;
            external_node_scores.put(current_node, score_contribution);
        }
    }

    @Override
    public String getDesciption() {
        return "sum of 1/branch-segment-sum";
    }

    @Override
    public double getNormalizationFactor(Phylogeny phylogeny) {
        return 1.0 / (double)phylogeny.getNumberOfExternalNodes();
    }
}

