/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class BranchLengthBasedScoringMethod
extends BranchCountingBasedScoringMethod {
    public static final double MIN_ALLOWED_BL_VALUE = 0.001;

    @Override
    double calculateScoreContributionPerExternalNode(PhylogenyNode external_node, PhylogenyNode current_node) {
        double score_contribution = 0.0;
        score_contribution = current_node == external_node ? external_node.getDistanceToParent() : ModelingUtils.calculateBranchLengthSum(external_node, current_node);
        return 1.0 / (score_contribution > 0.001 ? score_contribution : 0.001);
    }

    @Override
    public String getDesciption() {
        return "sum of 1/branch-length-sum [for self: 1/branch-length] [min branch length: 0.0010]";
    }

    @Override
    public double getNormalizationFactor(Phylogeny phylogeny) {
        double s = 0.0;
        double d = 0.0;
        PhylogenyNodeIterator iter = phylogeny.iteratorExternalForward();
        while (iter.hasNext()) {
            d = iter.next().getDistanceToParent();
            s += 1.0 / (d > 0.001 ? d : 0.001);
        }
        return 1.0 / s;
    }
}

