/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Point
implements PhylogenyData {
    private final String _geodetic_datum;
    private final BigDecimal _lat;
    private final BigDecimal _long;
    private final BigDecimal _alt;
    private final String _alt_unit;

    public Point(String geodetic_datum, BigDecimal lat, BigDecimal longitude) {
        this(geodetic_datum, lat, longitude, null, "");
    }

    public Point(String geodetic_datum, BigDecimal lat, BigDecimal longitude, BigDecimal alt, String alt_unit) {
        if (ForesterUtil.isEmpty(geodetic_datum) || lat == null || longitude == null || alt_unit == null) {
            throw new IllegalArgumentException("illegaly empty of null fields in constructor");
        }
        if (alt != null || ForesterUtil.isEmpty(alt_unit)) {
            throw new IllegalArgumentException("altitude must hava a unit");
        }
        this._geodetic_datum = geodetic_datum;
        this._lat = lat;
        this._long = longitude;
        this._alt = alt;
        this._alt_unit = alt_unit;
    }

    @Override
    public StringBuffer asSimpleText() {
        if (this.getAlt() == null) {
            return new StringBuffer("[" + this.getLat().toPlainString() + ", " + this.getLong() + "]");
        }
        return new StringBuffer("[" + this.getLat().toPlainString() + ", " + this.getLong() + ", " + this.getAlt() + this.getAltUnit() + "]");
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        return new Point(new String(this.getGeodeticDatum()), new BigDecimal(this.getLat().toPlainString()), new BigDecimal(this.getLong().toPlainString()), this.getAlt() == null ? null : new BigDecimal(this.getAlt().toPlainString()), new String(this.getAltUnit()));
    }

    public BigDecimal getAlt() {
        return this._alt;
    }

    public String getAltUnit() {
        return this._alt_unit;
    }

    public String getGeodeticDatum() {
        return this._geodetic_datum;
    }

    public BigDecimal getLat() {
        return this._lat;
    }

    public BigDecimal getLong() {
        return this._long;
    }

    @Override
    public boolean isEqual(PhylogenyData point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        if (this.getAlt() != null) {
            PhylogenyDataUtil.appendOpen(writer, "point", "geodetic_datum", this.getGeodeticDatum(), "alt_unit", this.getAltUnit());
        } else {
            PhylogenyDataUtil.appendOpen(writer, "point", "geodetic_datum", this.getGeodeticDatum());
        }
        PhylogenyDataUtil.appendElement(writer, "latitude", this.getLat().toPlainString(), indentation);
        PhylogenyDataUtil.appendElement(writer, "longitude", this.getLong().toPlainString(), indentation);
        if (this.getAlt() != null) {
            PhylogenyDataUtil.appendElement(writer, "alt", this.getAlt().toPlainString(), indentation);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "point");
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

