/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;

public class PropertiesMap
implements PhylogenyData {
    private final SortedMap<String, Property> _properties = new TreeMap<String, Property>();

    public void addProperty(Property property) throws IllegalArgumentException {
        if (this.getProperties().containsKey(property.getRef())) {
            throw new IllegalArgumentException("ref [" + property.getRef() + "] is already present");
        }
        this.getProperties().put(property.getRef(), property);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        String[] stringArray = this.getPropertyRefs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ref = stringArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(this.getProperty(ref).asText());
            ++n2;
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        PropertiesMap new_one = new PropertiesMap();
        for (String r : this.getProperties().keySet()) {
            new_one.addProperty((Property)this.getProperties().get(r));
        }
        return new_one;
    }

    public SortedMap<String, Property> getProperties() {
        return this._properties;
    }

    public Property[] getPropertiesArray() {
        Property[] a = new Property[this.getProperties().size()];
        int i = 0;
        for (String r : this.getProperties().keySet()) {
            a[i++] = (Property)this.getProperties().get(r);
        }
        return a;
    }

    public Property getProperty(String ref) throws IllegalArgumentException {
        Property p = null;
        if (this.getProperties() != null) {
            p = (Property)this.getProperties().get(ref);
        }
        if (p != null) {
            return p;
        }
        throw new IllegalArgumentException("Ref [" + ref + "] is not present");
    }

    public String[] getPropertyRefs() {
        if (this.getProperties() == null) {
            return new String[0];
        }
        Property[] properties = this.getPropertiesArray();
        String[] refs = new String[properties.length];
        int i = 0;
        while (i < properties.length) {
            refs[i] = properties[i].getRef();
            ++i;
        }
        return refs;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public boolean refExists(String ref) {
        if (this.getProperties() != null) {
            for (String r : this.getProperties().keySet()) {
                if (!r.equalsIgnoreCase(ref)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (this.getProperties() != null) {
            for (String ref : this.getProperties().keySet()) {
                sb.append(((Property)this.getProperties().get(ref)).toNHX());
            }
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.getProperties() != null) {
            for (String ref : this.getProperties().keySet()) {
                ((Property)this.getProperties().get(ref)).toPhyloXML(writer, level, indentation);
            }
        }
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

