/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Property
implements PhylogenyData {
    private final String _value;
    private final String _ref;
    private final String _unit;
    private final String _datatype;
    private final AppliesTo _applies_to;
    private final String _id_ref;

    public Property(String ref, String value, String unit, String datatype, AppliesTo applies_to) {
        this(ref, value, unit, datatype, applies_to, "");
    }

    private Property(String ref, String value, String unit, String datatype, AppliesTo applies_to, boolean dummy) {
        this._ref = ref;
        this._value = value;
        this._unit = unit;
        this._datatype = datatype;
        this._applies_to = applies_to;
        this._id_ref = "";
    }

    public Property(String ref, String value, String unit, String datatype, AppliesTo applies_to, String id_ref) {
        if (!ForesterUtil.isEmpty(ref) && ref.indexOf(":") < 1) {
            throw new IllegalArgumentException("property reference [" + ref + "] is not in the expected format (missing a \":\")");
        }
        if (!ForesterUtil.isEmpty(unit) && unit.indexOf(":") < 1) {
            throw new IllegalArgumentException("property unit [" + unit + "] is not in the expected format (missing a \":\")");
        }
        if (!ForesterUtil.isEmpty(datatype) && datatype.indexOf(":") < 1) {
            throw new IllegalArgumentException("property datatype [" + unit + "] is not in the expected format (missing a \":\")");
        }
        this._ref = ref;
        this._value = value;
        this._unit = unit;
        this._datatype = datatype;
        this._applies_to = applies_to;
        this._id_ref = id_ref;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getRef());
        sb.append(": ");
        sb.append(this.getValue());
        if (!ForesterUtil.isEmpty(this.getUnit())) {
            sb.append(this.getUnit());
        }
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        return new Property(new String(this.getRef()), new String(this.getValue()), new String(this.getUnit()), new String(this.getDataType()), this.getAppliesTo(), new String(this.getIdRef()));
    }

    public AppliesTo getAppliesTo() {
        return this._applies_to;
    }

    public String getDataType() {
        return this._datatype;
    }

    public String getIdRef() {
        return this._id_ref;
    }

    public String getRef() {
        return this._ref;
    }

    public String getUnit() {
        return this._unit;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (data == null) {
            return false;
        }
        return ((Property)data).getValue().equals(this.getValue()) && ((Property)data).getUnit().equals(this.getUnit()) && ((Property)data).getRef().equals(this.getRef());
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer nhx = new StringBuffer();
        nhx.append(":X");
        switch (this.getAppliesTo()) {
            case CLADE: {
                nhx.append("C=");
                break;
            }
            case NODE: {
                nhx.append("N=");
                break;
            }
            case PARENT_BRANCH: {
                nhx.append("B=");
                break;
            }
            case PHYLOGENY: {
                nhx.append("P=");
                break;
            }
            case ANNOTATION: {
                nhx.append("S=");
                break;
            }
            default: {
                nhx.append("O=");
            }
        }
        if (!this.getDataType().equals("")) {
            if (this.getDataType().equals("xsd:string")) {
                nhx.append("S=");
            } else if (this.getDataType().equals("xsd:long")) {
                nhx.append("L=");
            } else if (this.getDataType().equals("xsd:decimal")) {
                nhx.append("D=");
            } else if (this.getDataType().equals("xsd:boolean")) {
                nhx.append("B=");
            } else if (this.getDataType().equals("xsd:anyUR")) {
                nhx.append("U=");
            }
        }
        nhx.append(this.getRef());
        nhx.append("=");
        nhx.append(this.getValue());
        if (!this.getUnit().equals("")) {
            nhx.append("=");
            nhx.append(this.getUnit());
        }
        return nhx;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        PhylogenyDataUtil.appendElement(writer, "property", this.getValue(), "ref", this.getRef(), "unit", this.getUnit(), "datatype", this.getDataType(), "applies_to", this.getAppliesTo().toString(), "id_ref", this.getIdRef(), indentation);
    }

    public String toString() {
        return this.asText().toString();
    }

    public static Property createFromNhxString(String nhx) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(nhx, "=");
        int tokens = st.countTokens();
        String error = "error in NHX property tag format: expected: X[N|B|C|S|T|P|O]=<datatype>=<ref>=<value>[=<unit>], got: \"" + nhx + "\" instead";
        if (tokens != 4 && tokens != 5) {
            throw new IllegalArgumentException(error);
        }
        String first = st.nextToken();
        AppliesTo applies_to = null;
        if (first.equals("XN")) {
            applies_to = AppliesTo.NODE;
        } else if (first.equals("XB")) {
            applies_to = AppliesTo.PARENT_BRANCH;
        } else if (first.equals("XC")) {
            applies_to = AppliesTo.CLADE;
        } else if (first.equals("XS")) {
            applies_to = AppliesTo.ANNOTATION;
        } else if (first.equals("XT")) {
            applies_to = AppliesTo.OTHER;
        } else if (first.equals("XP")) {
            applies_to = AppliesTo.PHYLOGENY;
        } else if (first.equals("XO")) {
            applies_to = AppliesTo.OTHER;
        } else {
            throw new IllegalArgumentException(error);
        }
        String datatype = st.nextToken();
        if (datatype.equals("S")) {
            datatype = "xsd:string";
        } else if (datatype.equals("L")) {
            datatype = "xsd:long";
        } else if (datatype.equals("D")) {
            datatype = "xsd:decimal";
        } else if (datatype.equals("B")) {
            datatype = "xsd:boolean";
        } else if (datatype.equals("U")) {
            datatype = "xsd:anyURI";
        }
        String ref = st.nextToken();
        String value = st.nextToken();
        String unit = "";
        if (tokens == 5) {
            unit = st.nextToken();
        }
        return new Property(ref, value, unit, datatype, applies_to, true);
    }

    public static enum AppliesTo {
        PHYLOGENY{

            public String toString() {
                return "phylogeny";
            }
        }
        ,
        CLADE{

            public String toString() {
                return "clade";
            }
        }
        ,
        NODE{

            public String toString() {
                return "node";
            }
        }
        ,
        ANNOTATION{

            public String toString() {
                return "annotation";
            }
        }
        ,
        PARENT_BRANCH{

            public String toString() {
                return "parent_branch";
            }
        }
        ,
        OTHER{

            public String toString() {
                return "other";
            }
        };

    }
}

