/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class ExternalForwardIterator
implements PhylogenyNodeIterator {
    private PhylogenyNode _current_node;
    private final PhylogenyNode _last_ext_node;
    private final PhylogenyNode _first_ext_node;

    public ExternalForwardIterator(Phylogeny phylogeny) throws IllegalArgumentException {
        if (phylogeny.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use ExternalForwardIterator on an empty phylogeny.");
        }
        PhylogenyNode n = phylogeny.getRoot();
        while (!n.isExternal()) {
            n = n.getLastChildNode();
        }
        this._last_ext_node = n;
        this._first_ext_node = phylogeny.getFirstExternalNode();
        this.reset();
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private PhylogenyNode getFirstExtNode() {
        return this._first_ext_node;
    }

    private PhylogenyNode getLastExtNode() {
        return this._last_ext_node;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrentNode() != null;
    }

    @Override
    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode n = this.getCurrentNode();
        if (n == this.getLastExtNode()) {
            this.setCurrentNode(null);
        } else {
            this.setCurrentNode(n.getNextExternalNode());
        }
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.setCurrentNode(this.getFirstExtNode());
    }

    private void setCurrentNode(PhylogenyNode current_node) {
        this._current_node = current_node;
    }
}

