/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.util.ForesterUtil;

public class BasicCharacterStateMatrix<S>
implements CharacterStateMatrix<S> {
    final Object[][] _states;
    final String[] _identifiers;
    final String[] _characters;
    final Map<String, Integer> _identifier_index_map;
    final Map<String, Integer> _character_index_map;

    public BasicCharacterStateMatrix(int number_of_identifiers, int number_of_characters) {
        this._states = new Object[number_of_identifiers][number_of_characters];
        this._identifiers = new String[number_of_identifiers];
        this._characters = new String[number_of_characters];
        this._identifier_index_map = new HashMap<String, Integer>(number_of_identifiers);
        this._character_index_map = new HashMap<String, Integer>(number_of_characters);
    }

    public BasicCharacterStateMatrix(int number_of_identifiers, int number_of_characters, S default_state) {
        this(number_of_identifiers, number_of_identifiers);
        int identifier = 0;
        while (identifier < number_of_identifiers) {
            int character = 0;
            while (character < number_of_characters) {
                this.setState(identifier, character, default_state);
                ++character;
            }
            ++identifier;
        }
    }

    public BasicCharacterStateMatrix(List<List<S>> states) {
        if (states == null || states.size() < 1 || states.get(0) == null) {
            throw new IllegalArgumentException("attempt to create character state matrix from empty list");
        }
        int number_of_characters = states.get(0).size();
        int number_of_identifiers = states.size();
        this._states = new Object[number_of_identifiers][number_of_characters];
        this._identifiers = new String[number_of_identifiers];
        this._characters = new String[number_of_characters];
        this._identifier_index_map = new HashMap<String, Integer>(number_of_identifiers);
        this._character_index_map = new HashMap<String, Integer>(number_of_characters);
        int identifier = 0;
        while (identifier < number_of_identifiers) {
            int character = 0;
            while (character < number_of_characters) {
                this.setState(identifier, character, states.get(identifier).get(character));
                ++character;
            }
            ++identifier;
        }
    }

    public BasicCharacterStateMatrix(S[][] states) {
        this(states.length, states[0].length);
        int identifier = 0;
        while (identifier < states.length) {
            int character = 0;
            while (character < states[0].length) {
                this.setState(identifier, character, states[identifier][character]);
                ++character;
            }
            ++identifier;
        }
    }

    @Override
    public boolean containsCharacter(String character) {
        return this._character_index_map.containsKey(character);
    }

    @Override
    public boolean containsIdentifier(String identifier) {
        return this._identifier_index_map.containsKey(identifier);
    }

    @Override
    public CharacterStateMatrix<S> copy() {
        BasicCharacterStateMatrix<S> new_matrix = new BasicCharacterStateMatrix<S>(this.getNumberOfIdentifiers(), this.getNumberOfCharacters());
        int character = 0;
        while (character < this.getNumberOfCharacters()) {
            if (this.getCharacter(character) != null) {
                new_matrix.setCharacter(character, this.getCharacter(character));
            }
            ++character;
        }
        int identifier = 0;
        while (identifier < this.getNumberOfIdentifiers()) {
            if (this.getIdentifier(identifier) != null) {
                new_matrix.setIdentifier(identifier, this.getIdentifier(identifier));
            }
            int character2 = 0;
            while (character2 < this.getNumberOfCharacters()) {
                new_matrix.setState(identifier, character2, this.getState(identifier, character2));
                ++character2;
            }
            ++identifier;
        }
        return new_matrix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check character state matrix equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check character state matrix to " + o + " [" + o.getClass() + "]");
        }
        CharacterStateMatrix other = (CharacterStateMatrix)o;
        if (this.getNumberOfIdentifiers() == other.getNumberOfIdentifiers()) {
            this.getNumberOfCharacters();
            other.getNumberOfCharacters();
        }
        int identifier = 0;
        while (identifier < this.getNumberOfIdentifiers()) {
            int character = 0;
            while (character < this.getNumberOfCharacters()) {
                Object os;
                S s = this.getState(identifier, character);
                if (s != (os = other.getState(identifier, character))) {
                    if (s == null && os != null) {
                        return false;
                    }
                    if (s != null && os == null) {
                        return false;
                    }
                    if (!s.equals(other.getState(identifier, character))) {
                        return false;
                    }
                }
                ++character;
            }
            ++identifier;
        }
        return true;
    }

    @Override
    public String getCharacter(int character_index) {
        return this._characters[character_index];
    }

    @Override
    public int getCharacterIndex(String character) {
        if (!this._character_index_map.containsKey(character)) {
            throw new IllegalArgumentException("character [" + character + "] not found");
        }
        return this._character_index_map.get(character);
    }

    @Override
    public String getIdentifier(int identifier_index) {
        return this._identifiers[identifier_index];
    }

    @Override
    public int getIdentifierIndex(String identifier) {
        if (!this._identifier_index_map.containsKey(identifier)) {
            throw new IllegalArgumentException("indentifier [" + identifier + "] not found");
        }
        return this._identifier_index_map.get(identifier);
    }

    private int getLengthOfLongestState() {
        int longest = 0;
        int identifier = 0;
        while (identifier < this.getNumberOfIdentifiers()) {
            int character = 0;
            while (character < this.getNumberOfCharacters()) {
                int l;
                S s = this.getState(identifier, character);
                if (s != null && (l = this.getState(identifier, character).toString().length()) > longest) {
                    longest = l;
                }
                ++character;
            }
            ++identifier;
        }
        return longest;
    }

    @Override
    public int getNumberOfCharacters() {
        if (!this.isEmpty()) {
            return this._states[0].length;
        }
        return 0;
    }

    @Override
    public int getNumberOfIdentifiers() {
        return this._states.length;
    }

    @Override
    public S getState(int identifier_index, int character_index) {
        return (S)this._states[identifier_index][character_index];
    }

    @Override
    public S getState(String identifier, int character_index) {
        if (!this.containsIdentifier(identifier)) {
            throw new IllegalArgumentException("identifier [" + identifier + "] not found");
        }
        return this.getState(this._identifier_index_map.get(identifier), character_index);
    }

    @Override
    public S getState(String identifier, String character) {
        if (!this.containsIdentifier(identifier)) {
            throw new IllegalArgumentException("identifier [" + identifier + "] not found");
        }
        if (!this.containsCharacter(character)) {
            throw new IllegalArgumentException("character [" + character + "] not found");
        }
        return this.getState(this._identifier_index_map.get(identifier), (int)this._character_index_map.get(character));
    }

    @Override
    public boolean isEmpty() {
        return this.getNumberOfIdentifiers() <= 0;
    }

    @Override
    public CharacterStateMatrix<S> pivot() {
        BasicCharacterStateMatrix<S> new_matrix = new BasicCharacterStateMatrix<S>(this.getNumberOfCharacters(), this.getNumberOfIdentifiers());
        int character = 0;
        while (character < this.getNumberOfCharacters()) {
            if (this.getCharacter(character) != null) {
                new_matrix.setIdentifier(character, this.getCharacter(character));
            }
            ++character;
        }
        int identifier = 0;
        while (identifier < this.getNumberOfIdentifiers()) {
            if (this.getIdentifier(identifier) != null) {
                new_matrix.setCharacter(identifier, this.getIdentifier(identifier));
            }
            int character2 = 0;
            while (character2 < this.getNumberOfCharacters()) {
                new_matrix.setState(character2, identifier, this.getState(identifier, character2));
                ++character2;
            }
            ++identifier;
        }
        return new_matrix;
    }

    @Override
    public void setCharacter(int character_index, String character) {
        if (character == null) {
            throw new IllegalArgumentException("attempt to use null character");
        }
        this._characters[character_index] = character;
        if (this._character_index_map.containsKey(character)) {
            throw new IllegalArgumentException("character [" + character + "] is not unique");
        }
        this._character_index_map.put(character, character_index);
    }

    @Override
    public void setIdentifier(int identifier_index, String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("attempt to use null identifier");
        }
        this._identifiers[identifier_index] = identifier;
        if (this._identifier_index_map.containsKey(identifier)) {
            throw new IllegalArgumentException("identifier [" + identifier + "] is not unique");
        }
        this._identifier_index_map.put(identifier, identifier_index);
    }

    @Override
    public void setState(int identifier_index, int character_index, S state) {
        this._states[identifier_index][character_index] = state;
    }

    @Override
    public void setState(String identifier, int character_index, S state) {
        if (!this._identifier_index_map.containsKey(identifier)) {
            throw new IllegalArgumentException("identifier [" + identifier + "] not found");
        }
        this.setState(this._identifier_index_map.get(identifier), character_index, state);
    }

    @Override
    public void setState(String identifier, String character, S state) {
        if (!this.containsIdentifier(identifier)) {
            throw new IllegalArgumentException("identifier [" + identifier + "] not found");
        }
        if (!this.containsCharacter(character)) {
            throw new IllegalArgumentException("character [" + character + "] not found");
        }
        this.setState(this._identifier_index_map.get(identifier), (int)this._character_index_map.get(character), state);
    }

    private void toForester(Writer writer) throws IOException {
        int longest = this.getLengthOfLongestState() + 5;
        writer.write("Identifiers: ");
        writer.write(String.valueOf(this.getNumberOfIdentifiers()));
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("Characters : ");
        writer.write(String.valueOf(this.getNumberOfCharacters()));
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(ForesterUtil.pad("", 20, ' ', false).toString());
        writer.write(32);
        int character = 0;
        while (character < this.getNumberOfCharacters()) {
            String c = this.getCharacter(character);
            writer.write(c != null ? ForesterUtil.pad(c, longest, ' ', false).toString() : ForesterUtil.pad("", longest, ' ', false).toString());
            if (character < this.getNumberOfCharacters() - 1) {
                writer.write(32);
            }
            ++character;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        int identifier = 0;
        while (identifier < this.getNumberOfIdentifiers()) {
            if (this.getIdentifier(identifier) != null) {
                writer.write(ForesterUtil.pad(this.getIdentifier(identifier), 20, ' ', false).toString());
                writer.write(32);
            }
            int character2 = 0;
            while (character2 < this.getNumberOfCharacters()) {
                S state = this.getState(identifier, character2);
                writer.write(state != null ? ForesterUtil.pad(state.toString(), longest, ' ', false).toString() : ForesterUtil.pad("", longest, ' ', false).toString());
                if (character2 < this.getNumberOfCharacters() - 1) {
                    writer.write(32);
                }
                ++character2;
            }
            if (identifier < this.getNumberOfIdentifiers() - 1) {
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ++identifier;
        }
    }

    private void toNexus(Writer writer) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write("#NEXUS");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        this.writeNexusTaxaBlock(writer);
        this.writeNexusBinaryChractersBlock(writer);
    }

    private void toPhylip(Writer writer) throws IOException {
        int pad = 6;
        writer.write(32);
        writer.write(32);
        writer.write(32);
        writer.write(32);
        writer.write(this.getNumberOfIdentifiers());
        writer.write(32);
        writer.write(this.getNumberOfCharacters());
        writer.write(ForesterUtil.LINE_SEPARATOR);
        int identifier = 0;
        while (identifier < this.getNumberOfIdentifiers()) {
            if (ForesterUtil.isEmpty(this.getIdentifier(identifier))) {
                throw new IllegalStateException("PHYLIP format does not allow empty identifiers");
            }
            writer.write(ForesterUtil.pad(this.getIdentifier(identifier), 6, ' ', false).toString());
            writer.write(32);
            writer.write(32);
            writer.write("");
            int character = 0;
            while (character < this.getNumberOfCharacters()) {
                String state = this.getState(identifier, character).toString();
                writer.write(state != null ? ForesterUtil.pad(state, 6, ' ', false).toString() : ForesterUtil.pad("", 6, ' ', false).toString());
                if (character < this.getNumberOfCharacters() - 1) {
                    writer.write(32);
                    writer.write(32);
                }
                ++character;
            }
            if (identifier < this.getNumberOfIdentifiers() - 1) {
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ++identifier;
        }
    }

    @Override
    public void toWriter(Writer writer) throws IOException {
        this.toForester(writer);
    }

    @Override
    public void toWriter(Writer writer, CharacterStateMatrix.Format format) throws IOException {
        switch (format) {
            case PHYLIP: {
                this.toPhylip(writer);
                break;
            }
            case FORESTER: {
                this.toForester(writer);
                break;
            }
            case NEXUS_BINARY: {
                this.toNexus(writer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format:" + (Object)((Object)format));
            }
        }
    }

    public void writeNexusBinaryChractersBlock(Writer w) throws IOException {
        w.write("Begin Characters;");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(" ");
        w.write("Dimensions");
        w.write(" ");
        w.write("NChar");
        w.write("=");
        w.write(String.valueOf(this.getNumberOfCharacters()));
        w.write(";");
        w.write(ForesterUtil.LINE_SEPARATOR);
        this.writeNexusCharstatelabels(w);
        w.write(" ");
        w.write("Format");
        w.write(" ");
        w.write("DataType");
        w.write("=");
        w.write("Standard");
        w.write(" ");
        w.write("Symbols");
        w.write("=\"");
        w.write(String.valueOf((Object)CharacterStateMatrix.BinaryStates.ABSENT));
        w.write(String.valueOf((Object)CharacterStateMatrix.BinaryStates.PRESENT));
        w.write("\";");
        w.write(ForesterUtil.LINE_SEPARATOR);
        this.writeNexusMatrix(w);
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("End;");
        w.write(ForesterUtil.LINE_SEPARATOR);
    }

    public void writeNexusCharstatelabels(Writer w) throws IOException {
        w.write(" ");
        w.write("CharStateLabels");
        w.write(ForesterUtil.LINE_SEPARATOR);
        int i = 0;
        while (i < this.getNumberOfCharacters()) {
            w.write("  " + (i + 1) + " '");
            w.write(this.getCharacter(i));
            w.write("'");
            if (i < this.getNumberOfCharacters() - 1) {
                w.write(",");
                w.write(ForesterUtil.LINE_SEPARATOR);
            }
            ++i;
        }
        w.write(";");
        w.write(ForesterUtil.LINE_SEPARATOR);
    }

    public void writeNexusMatrix(Writer w) throws IOException {
        w.write(" ");
        w.write("Matrix");
        w.write(ForesterUtil.LINE_SEPARATOR);
        int identifier = 0;
        while (identifier < this.getNumberOfIdentifiers()) {
            if (this.getIdentifier(identifier) != null) {
                w.write("  ");
                w.write(ForesterUtil.pad(this.getIdentifier(identifier), 20, ' ', false).toString());
                w.write(32);
            }
            int character = 0;
            while (character < this.getNumberOfCharacters()) {
                S state = this.getState(identifier, character);
                if (state == null) {
                    throw new IllegalStateException("character state matrix cannot contain null if to be represented in nexus format");
                }
                if (!(state instanceof CharacterStateMatrix.BinaryStates)) {
                    throw new IllegalStateException("nexus format representation expects binary character data - got [" + this.getState(0, 0).getClass() + "] instead");
                }
                if (state == CharacterStateMatrix.BinaryStates.UNKNOWN) {
                    throw new IllegalStateException("character state matrix cannot contain unknown states if to be represented in nexus format");
                }
                w.write(state.toString());
                ++character;
            }
            if (identifier < this.getNumberOfIdentifiers() - 1) {
                w.write(ForesterUtil.LINE_SEPARATOR);
            }
            ++identifier;
        }
        w.write(";");
    }

    public void writeNexusTaxaBlock(Writer w) throws IOException {
        w.write("Begin Taxa;");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(" ");
        w.write("Dimensions");
        w.write(" ");
        w.write("NTax");
        w.write("=");
        w.write(String.valueOf(this.getNumberOfIdentifiers()));
        w.write(";");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(" ");
        w.write("TaxLabels");
        int i = 0;
        while (i < this.getNumberOfIdentifiers()) {
            w.write(" ");
            w.write(this.getIdentifier(i));
            ++i;
        }
        w.write(";");
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write("End;");
        w.write(ForesterUtil.LINE_SEPARATOR);
    }
}

