/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.forester.surfacing.BasicSpecies;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.Protein;
import org.forester.surfacing.ProteinId;
import org.forester.surfacing.Species;

public class BasicProtein
implements Protein {
    private final ProteinId _id;
    private final Species _species;
    private String _name;
    private String _desc;
    private String _accession;
    private final List<Domain> _protein_domains;

    public BasicProtein(String id_str, String species_str) {
        this._id = new ProteinId(id_str);
        this._species = new BasicSpecies(species_str);
        this._protein_domains = new ArrayList<Domain>();
        this.init();
    }

    @Override
    public void addProteinDomain(Domain protein_domain) {
        this.getProteinDomains().add(protein_domain);
    }

    @Override
    public boolean contains(List<DomainId> query_domain_ids, boolean in_nc_order) {
        if (!in_nc_order) {
            for (DomainId query_domain_id : query_domain_ids) {
                if (this.getProteinDomainIds().contains(query_domain_id)) continue;
                return false;
            }
            return true;
        }
        int current_start_position = -1;
        block1: for (DomainId query_domain_id : query_domain_ids) {
            if (this.getProteinDomainIds().contains(query_domain_id)) {
                List<Domain> found_domains = this.getProteinDomains(query_domain_id);
                TreeSet<Integer> ordered_start_positions = new TreeSet<Integer>();
                for (Domain found_domain : found_domains) {
                    ordered_start_positions.add(found_domain.getFrom());
                }
                Iterator<Domain> iterator = ordered_start_positions.iterator();
                while (iterator.hasNext()) {
                    int start_position = (Integer)((Object)iterator.next());
                    if (start_position <= current_start_position) continue;
                    current_start_position = start_position;
                    continue block1;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAccession() {
        return this._accession;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int getNumberOfProteinDomains() {
        return this.getProteinDomains().size();
    }

    @Override
    public Domain getProteinDomain(int index) {
        return this._protein_domains.get(index);
    }

    @Override
    public int getProteinDomainCount(DomainId domain_id) {
        return this.getProteinDomains(domain_id).size();
    }

    private List<DomainId> getProteinDomainIds() {
        ArrayList<DomainId> ids = new ArrayList<DomainId>(this.getProteinDomains().size());
        for (Domain domain : this.getProteinDomains()) {
            ids.add(domain.getDomainId());
        }
        return ids;
    }

    @Override
    public List<Domain> getProteinDomains() {
        return this._protein_domains;
    }

    @Override
    public List<Domain> getProteinDomains(DomainId domain_id) {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (Domain domain : this.getProteinDomains()) {
            if (!domain.getDomainId().equals(domain_id)) continue;
            domains.add(domain);
        }
        return domains;
    }

    @Override
    public ProteinId getProteinId() {
        return this._id;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    private void init() {
        this._desc = "";
        this._accession = "";
        this._name = "";
    }

    public void setAccession(String accession) {
        this._accession = accession;
    }

    public void setDescription(String description) {
        this._desc = description;
    }

    public void setName(String name) {
        this._name = name;
    }
}

