/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.HashSet;
import java.util.Set;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.CSSStyleDeclarationFactory;
import org.apache.batik.util.CSSConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public class ElementNonCSSPresentationalHintsSupport
implements CSSConstants {
    public static Set createPresentionAttributeSet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("alignment-baseline");
        hashSet.add("baseline-shift");
        hashSet.add("clip");
        hashSet.add("clip-path");
        hashSet.add("clip-rule");
        hashSet.add("color");
        hashSet.add("color-interpolation");
        hashSet.add("color-interpolation-filters");
        hashSet.add("color-profile");
        hashSet.add("color-rendering");
        hashSet.add("cursor");
        hashSet.add("direction");
        hashSet.add("display");
        hashSet.add("dominant-baseline");
        hashSet.add("enable-background");
        hashSet.add("fill");
        hashSet.add("fill-opacity");
        hashSet.add("fill-rule");
        hashSet.add("filter");
        hashSet.add("flood-color");
        hashSet.add("flood-opacity");
        hashSet.add("font-family");
        hashSet.add("font-size");
        hashSet.add("font-size-adjust");
        hashSet.add("font-stretch");
        hashSet.add("font-style");
        hashSet.add("font-variant");
        hashSet.add("font-weight");
        hashSet.add("glyph-orientation-horizontal");
        hashSet.add("glyph-orientation-vertical");
        hashSet.add("image-rendering");
        hashSet.add("letter-spacing");
        hashSet.add("lighting-color");
        hashSet.add("marker");
        hashSet.add("marker-end");
        hashSet.add("marker-mid");
        hashSet.add("marker-start");
        hashSet.add("mask");
        hashSet.add("opacity");
        hashSet.add("overflow");
        hashSet.add("pointer-events");
        hashSet.add("shape-rendering");
        hashSet.add("stop-color");
        hashSet.add("stop-opacity");
        hashSet.add("stroke");
        hashSet.add("stroke-dasharray");
        hashSet.add("stroke-dashoffset");
        hashSet.add("stroke-linecap");
        hashSet.add("stroke-linejoin");
        hashSet.add("stroke-miterlimit");
        hashSet.add("stroke-opacity");
        hashSet.add("stroke-width");
        hashSet.add("text-anchor");
        hashSet.add("text-decoration");
        hashSet.add("text-rendering");
        hashSet.add("unicode-bidi");
        hashSet.add("visibility");
        hashSet.add("word-spacing");
        hashSet.add("writing-mode");
        return hashSet;
    }

    public static CSSStyleDeclaration getNonCSSPresentationalHints(Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = null;
        SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)element.getOwnerDocument().getImplementation();
        Set set = sVGDOMImplementation.getPresentionAttributeSet();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = namedNodeMap.item(n2);
            String string = node.getNodeName();
            if (set.contains(string)) {
                if (cSSStyleDeclaration == null) {
                    DOMImplementation dOMImplementation = element.getOwnerDocument().getImplementation();
                    CSSStyleDeclarationFactory cSSStyleDeclarationFactory = (CSSStyleDeclarationFactory)dOMImplementation;
                    cSSStyleDeclaration = cSSStyleDeclarationFactory.createCSSStyleDeclaration();
                }
                cSSStyleDeclaration.setProperty(string, node.getNodeValue(), "");
            }
            ++n2;
        }
        return cSSStyleDeclaration;
    }
}

