/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.maizegenetics.analysis.chart.BasicChartPanel;
import net.maizegenetics.analysis.chart.ManhattanDisplayPlugin;
import net.maizegenetics.analysis.chart.TableReportManhattanDataset;
import net.maizegenetics.analysis.chart.XYMultipleYToolTipGenerator;
import net.maizegenetics.util.TableReport;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;

public class XYScatterMultipleYPanel
extends BasicChartPanel {
    ManhattanDisplayPlugin myManhattanDisplayPlugin;
    ChartPanel myChartPanel;
    JButton saveButton = new JButton("save...");
    TableReportManhattanDataset dataset;
    TableReport myTableReport;

    public XYScatterMultipleYPanel(ManhattanDisplayPlugin plugin, TableReport theTable, int start, int end) {
        this.myManhattanDisplayPlugin = plugin;
        this.myTableReport = theTable;
        try {
            this.dataset = new TableReportManhattanDataset(theTable, start, end);
            this.chart = this.createChart(this.dataset);
            this.myChartPanel = new ChartPanel(this.chart);
            this.myChartPanel.setPreferredSize(new Dimension(900, 500));
            this.myTableReport = theTable;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 3));
        this.add((Component)this.myChartPanel);
        this.saveButton.setAlignmentX(1.0f);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYScatterMultipleYPanel.this.saveButton_actionPerformed(e);
            }
        });
        this.add(this.saveButton);
    }

    private void saveButton_actionPerformed(ActionEvent e) {
        this.myManhattanDisplayPlugin.saveDataToFile((Component)this.myChartPanel);
    }

    public JFreeChart createChart(TableReportManhattanDataset dataset) {
        String name = "Please select numeric variables";
        String xName = "X";
        String y1Name = "Y";
        String y2Name = "Y2";
        if (dataset != null) {
            xName = dataset.getXName();
            y1Name = "-Log10(P-Value)";
            name = "P-Values by Chromosome for " + dataset.getTrait();
        }
        this.chart = ChartFactory.createScatterPlot((String)name, (String)xName, (String)y1Name, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().setForegroundAlpha(0.75f);
        this.chart.getXYPlot().getRenderer().setToolTipGenerator((XYToolTipGenerator)new XYMultipleYToolTipGenerator());
        return this.chart;
    }

    @Override
    public JComponent getMainComponent() {
        return this.myChartPanel;
    }
}

