/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;
import net.maizegenetics.analysis.data.DiploidOptionDialog;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.data.ImputeDisplayOptionDialog;
import net.maizegenetics.analysis.data.ReportOptionDialog;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.taxa.distance.WriteDistanceMatrix;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.PhenotypeUtils;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.Report;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ExportPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ExportPlugin.class);
    private FileLoadPlugin.TasselFileType myFileType = FileLoadPlugin.TasselFileType.Hapmap;
    private String mySaveFile = null;
    private boolean myIsDiploid = false;
    private boolean myKeepDepth = true;
    private final JFileChooser myFileChooserSave = new JFileChooser(TasselPrefs.getSaveDir());

    public ExportPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            DataSet dataSet;
            String filename;
            block22: {
                if (input.getSize() != 1) {
                    String message = "Please select one and only one item.";
                    if (this.isInteractive()) {
                        JOptionPane.showMessageDialog(this.getParentFrame(), message);
                    } else {
                        myLogger.error((Object)("performFunction: " + message));
                    }
                    DataSet dataSet2 = null;
                    return dataSet2;
                }
                filename = this.mySaveFile;
                try {
                    Object data = input.getData(0).getData();
                    if (data instanceof GenotypeTable) {
                        filename = this.performFunctionForAlignment((GenotypeTable)data);
                        break block22;
                    }
                    if (data instanceof Phenotype) {
                        filename = this.performFunctionForPhenotype((Phenotype)data);
                        break block22;
                    }
                    if (data instanceof DistanceMatrix) {
                        filename = this.performFunctionForDistanceMatrix((DistanceMatrix)data);
                        break block22;
                    }
                    if (data instanceof TableReport) {
                        filename = this.performFunctionForTableReport((TableReport)data);
                        break block22;
                    }
                    if (data instanceof Report) {
                        filename = this.performFunctionForReport((Report)data);
                        break block22;
                    }
                    String message = "Don't know how to export data type: " + data.getClass().getName();
                    if (this.isInteractive()) {
                        JOptionPane.showMessageDialog(this.getParentFrame(), message);
                    } else {
                        myLogger.error((Object)("performFunction: " + message));
                    }
                    DataSet dataSet3 = null;
                    return dataSet3;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StringBuilder builder = new StringBuilder();
                    builder.append(Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(e), 50));
                    String str = builder.toString();
                    if (this.isInteractive()) {
                        DialogUtils.showError(str, (Component)this.getParentFrame());
                    } else {
                        myLogger.error((Object)str);
                    }
                    DataSet dataSet4 = null;
                    return dataSet4;
                }
            }
            if (filename != null) {
                myLogger.info((Object)("performFunction: wrote dataset: " + input.getData(0).getName() + " to file: " + filename));
                dataSet = new DataSet(new Datum("Filename", filename, null), (Plugin)this);
                return dataSet;
            }
            dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public String performFunctionForDistanceMatrix(DistanceMatrix input) {
        if (this.isInteractive()) {
            this.setSaveFile(this.getFileByChooser());
        }
        if (this.mySaveFile == null || this.mySaveFile.length() == 0) {
            return null;
        }
        try {
            File theFile = new File(Utils.addSuffixIfNeeded(this.mySaveFile, ".txt"));
            WriteDistanceMatrix.saveDelimitedDistanceMatrix(input, theFile);
            return theFile.getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("ExportPlugin: performFunctionForDistanceMatrix: Problem writing file: " + this.mySaveFile);
        }
    }

    public String performFunctionForTableReport(TableReport input) {
        if (this.isInteractive()) {
            this.setSaveFile(this.getFileByChooser());
        }
        if (this.mySaveFile == null || this.mySaveFile.length() == 0) {
            return null;
        }
        try {
            File theFile = new File(Utils.addSuffixIfNeeded(this.mySaveFile, ".txt"));
            TableReportUtils.saveDelimitedTableReport(input, "\t", theFile);
            return theFile.getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("ExportPlugin: performFunctionForTableReport: Problem writing file: " + this.mySaveFile);
        }
    }

    public String performFunctionForPhenotype(Phenotype input) {
        if (this.isInteractive()) {
            this.setSaveFile(this.getFileByChooser());
        }
        if (this.mySaveFile == null || this.mySaveFile.length() == 0) {
            return null;
        }
        File theFile = null;
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            theFile = new File(Utils.addSuffixIfNeeded(this.mySaveFile, ".txt"));
            fw = new FileWriter(theFile);
            pw = new PrintWriter(fw);
            PhenotypeUtils.saveAs(input, pw);
            String string = theFile.getCanonicalPath();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("ExportPlugin: performFunctionForPhenotype: Problem writing file: " + this.mySaveFile);
        }
        finally {
            try {
                pw.close();
                fw.close();
            }
            catch (Exception e) {}
        }
    }

    public String performFunctionForAlignment(GenotypeTable inputAlignment) {
        if (this.isInteractive()) {
            ExportPluginDialog theDialog = new ExportPluginDialog();
            theDialog.setLocationRelativeTo(this.getParentFrame());
            theDialog.setVisible(true);
            if (theDialog.isCancel()) {
                return null;
            }
            this.myFileType = theDialog.getTasselFileType();
            this.myKeepDepth = theDialog.keepDepth();
            theDialog.dispose();
            this.setSaveFile(this.getFileByChooser());
        }
        if (this.mySaveFile == null || this.mySaveFile.length() == 0) {
            return null;
        }
        String resultFile = this.mySaveFile;
        if (this.myFileType == FileLoadPlugin.TasselFileType.Hapmap || this.myFileType == FileLoadPlugin.TasselFileType.HapmapDiploid) {
            int n = 0;
            DefaultMutableTreeNode node = null;
            if (this.isInteractive()) {
                DiploidOptionDialog diploidDialog = new DiploidOptionDialog();
                diploidDialog.setLocationRelativeTo(this.getParentFrame());
                diploidDialog.setVisible(true);
                this.myIsDiploid = diploidDialog.getDiploid();
                node = (DefaultMutableTreeNode)((TASSELMainFrame)this.getParentFrame()).getDataTreePanel().getTree().getLastSelectedPathComponent();
                n = node.getChildCount();
            } else if (this.myFileType == FileLoadPlugin.TasselFileType.Hapmap) {
                this.myIsDiploid = false;
            } else if (this.myFileType == FileLoadPlugin.TasselFileType.HapmapDiploid) {
                this.myIsDiploid = true;
            }
            boolean foundImputed = false;
            if (n == 0 || !this.isInteractive()) {
                resultFile = ExportUtils.writeToHapmap(inputAlignment, this.myIsDiploid, this.mySaveFile, '\t', this);
            } else {
                for (int i = 0; i < n && !foundImputed; ++i) {
                    GenotypeTableMask.MaskType maskType;
                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node.getChildAt(i);
                    Datum currentDatum = (Datum)currentNode.getUserObject();
                    Object currentMask = currentDatum.getData();
                    if (!(currentMask instanceof GenotypeTableMask) || (maskType = ((GenotypeTableMask)currentMask).getMaskType()) != GenotypeTableMask.MaskType.imputed) continue;
                    ImputeDisplayOptionDialog imputeOptionDialog = new ImputeDisplayOptionDialog();
                    imputeOptionDialog.setLocationRelativeTo(this.getParentFrame());
                    imputeOptionDialog.setVisible(true);
                    if (imputeOptionDialog.getDisplayImputed() || i != n - 1) continue;
                    resultFile = ExportUtils.writeToHapmap(inputAlignment, this.myIsDiploid, this.mySaveFile, '\t', this);
                }
            }
        } else if (this.myFileType == FileLoadPlugin.TasselFileType.Plink) {
            resultFile = ExportUtils.writeToPlink(inputAlignment, this.mySaveFile, '\t');
        } else if (this.myFileType == FileLoadPlugin.TasselFileType.Phylip_Seq) {
            PrintWriter out = null;
            try {
                resultFile = Utils.addSuffixIfNeeded(this.mySaveFile, ".phy");
                out = new PrintWriter(new FileWriter(resultFile));
                ExportUtils.printSequential(inputAlignment, out);
            }
            catch (Exception e) {
                throw new IllegalStateException("ExportPlugin: performFunction: Problem writing file: " + this.mySaveFile);
            }
            finally {
                out.flush();
                out.close();
            }
        } else if (this.myFileType == FileLoadPlugin.TasselFileType.Phylip_Inter) {
            PrintWriter out = null;
            try {
                resultFile = Utils.addSuffixIfNeeded(this.mySaveFile, ".phy");
                out = new PrintWriter(new FileWriter(resultFile));
                ExportUtils.printInterleaved(inputAlignment, out);
            }
            catch (Exception e) {
                throw new IllegalStateException("ExportPlugin: performFunction: Problem writing file: " + this.mySaveFile);
            }
            finally {
                out.flush();
                out.close();
            }
        } else if (this.myFileType == FileLoadPlugin.TasselFileType.Table) {
            resultFile = ExportUtils.saveDelimitedAlignment(inputAlignment, "\t", this.mySaveFile);
        } else if (this.myFileType == FileLoadPlugin.TasselFileType.Serial) {
            resultFile = ExportUtils.writeAlignmentToSerialGZ(inputAlignment, this.mySaveFile);
        } else if (this.myFileType == FileLoadPlugin.TasselFileType.HDF5) {
            resultFile = ExportUtils.writeGenotypeHDF5(inputAlignment, this.mySaveFile, this.myKeepDepth);
        } else if (this.myFileType == FileLoadPlugin.TasselFileType.VCF) {
            resultFile = ExportUtils.writeToVCF(inputAlignment, this.mySaveFile, this.myKeepDepth);
        } else {
            throw new IllegalStateException("ExportPlugin: performFunction: Unknown Alignment File Format: " + (Object)((Object)this.myFileType));
        }
        return resultFile;
    }

    public String performFunctionForReport(Report input) {
        if (this.isInteractive()) {
            ReportOptionDialog theDialog = new ReportOptionDialog();
            theDialog.setLocationRelativeTo(this.getParentFrame());
            theDialog.setVisible(true);
            if (theDialog.isCancel()) {
                return null;
            }
            this.myFileType = theDialog.getTasselFileType();
            theDialog.dispose();
            this.setSaveFile(this.getFileByChooser());
        }
        if (this.mySaveFile == null || this.mySaveFile.length() == 0) {
            return null;
        }
        String resultFile = Utils.addSuffixIfNeeded(this.mySaveFile, ".txt");
        if (this.myFileType == FileLoadPlugin.TasselFileType.Text) {
            BufferedWriter writer = Utils.getBufferedWriter(resultFile);
            try {
                writer.append(input.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("ExportPlugin: performFunctionForReport: Problem writing file: " + resultFile);
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(resultFile);
            input.report(writer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("ExportPlugin: performFunctionForReport: Problem writing file: " + resultFile);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
        return resultFile;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = ExportPlugin.class.getResource("/net/maizegenetics/analysis/images/Export16.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Export";
    }

    @Override
    public String getToolTipText() {
        return "Export data to files on your computer.";
    }

    public String getSaveFile() {
        return this.mySaveFile;
    }

    public void setSaveFile(String saveFile) {
        this.mySaveFile = saveFile;
    }

    public void setSaveFile(File saveFile) {
        this.mySaveFile = saveFile == null ? null : saveFile.getPath();
    }

    public void setAlignmentFileType(FileLoadPlugin.TasselFileType type) {
        this.myFileType = type;
    }

    public void setIsDiploid(boolean isDiploid) {
        this.myIsDiploid = isDiploid;
    }

    private File getFileByChooser() {
        this.myFileChooserSave.setMultiSelectionEnabled(false);
        File result = null;
        int returnVal = this.myFileChooserSave.showSaveDialog(this.getParentFrame());
        if (returnVal == 1 || returnVal == 0) {
            result = this.myFileChooserSave.getSelectedFile();
            TasselPrefs.putSaveDir(this.myFileChooserSave.getCurrentDirectory().getPath());
        }
        return result;
    }

    class ExportPluginDialog
    extends JDialog {
        private boolean myIsCancel;
        private ButtonGroup myButtonGroup;
        private JRadioButton myHapMapRadioButton;
        private JRadioButton myByteHDF5RadioButton;
        private JRadioButton myVCFRadioButton;
        private JRadioButton myPlinkRadioButton;
        private JRadioButton myPhylipRadioButton;
        private JRadioButton myPhylipInterRadioButton;
        private JRadioButton myTabTableRadioButton;
        private JCheckBox myKeepDepthCheck;

        public ExportPluginDialog() {
            super((Frame)null, "Export...", true);
            this.myIsCancel = true;
            this.myButtonGroup = new ButtonGroup();
            this.myHapMapRadioButton = new JRadioButton("Write Hapmap");
            this.myByteHDF5RadioButton = new JRadioButton("Write HDF5");
            this.myVCFRadioButton = new JRadioButton("Write VCF");
            this.myPlinkRadioButton = new JRadioButton("Write Plink");
            this.myPhylipRadioButton = new JRadioButton("Write Phylip (Sequential)");
            this.myPhylipInterRadioButton = new JRadioButton("Write Phylip (Interleaved)");
            this.myTabTableRadioButton = new JRadioButton("Write Tab Delimited");
            this.myKeepDepthCheck = new JCheckBox("Keep Depth (VCF or HDF5)", true);
            try {
                this.jbInit();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setTitle("Export...");
            this.setDefaultCloseOperation(1);
            this.setUndecorated(false);
            this.getRootPane().setWindowDecorationStyle(0);
            Container contentPane = this.getContentPane();
            BoxLayout layout = new BoxLayout(contentPane, 1);
            contentPane.setLayout(layout);
            JPanel main = this.getMain();
            contentPane.add(main);
            this.pack();
            this.setResizable(false);
            this.myButtonGroup.add(this.myHapMapRadioButton);
            this.myButtonGroup.add(this.myByteHDF5RadioButton);
            this.myButtonGroup.add(this.myVCFRadioButton);
            this.myButtonGroup.add(this.myPlinkRadioButton);
            this.myButtonGroup.add(this.myPhylipRadioButton);
            this.myButtonGroup.add(this.myPhylipInterRadioButton);
            this.myButtonGroup.add(this.myTabTableRadioButton);
            this.myHapMapRadioButton.setSelected(true);
        }

        private JPanel getMain() {
            JPanel inputs = new JPanel();
            BoxLayout layout = new BoxLayout(inputs, 1);
            inputs.setLayout(layout);
            inputs.setAlignmentX(0.5f);
            inputs.add(Box.createRigidArea(new Dimension(1, 10)));
            inputs.add(this.getLabel());
            inputs.add(Box.createRigidArea(new Dimension(1, 10)));
            inputs.add(this.getFileTypePanel());
            inputs.add(Box.createRigidArea(new Dimension(1, 10)));
            inputs.add(this.getOptionPanel());
            inputs.add(Box.createRigidArea(new Dimension(1, 5)));
            inputs.add(this.getButtons());
            inputs.add(Box.createRigidArea(new Dimension(1, 10)));
            return inputs;
        }

        private JPanel getLabel() {
            JPanel result = new JPanel();
            BoxLayout layout = new BoxLayout(result, 1);
            result.setLayout(layout);
            result.setAlignmentX(0.5f);
            JLabel jLabel1 = new JLabel("Choose File Type to Export.");
            jLabel1.setFont(new Font("Dialog", 1, 18));
            result.add(jLabel1);
            return result;
        }

        private JPanel getFileTypePanel() {
            JPanel result = new JPanel();
            BoxLayout layout = new BoxLayout(result, 1);
            result.setLayout(layout);
            result.setAlignmentX(0.5f);
            result.setBorder(BorderFactory.createEtchedBorder());
            result.add(this.myHapMapRadioButton);
            result.add(this.myByteHDF5RadioButton);
            result.add(this.myVCFRadioButton);
            result.add(this.myPlinkRadioButton);
            result.add(this.myPhylipRadioButton);
            result.add(this.myPhylipInterRadioButton);
            result.add(this.myTabTableRadioButton);
            result.add(Box.createRigidArea(new Dimension(1, 20)));
            return result;
        }

        private JPanel getOptionPanel() {
            JPanel result = new JPanel();
            BoxLayout layout = new BoxLayout(result, 1);
            result.setLayout(layout);
            result.setAlignmentX(0.5f);
            result.setBorder(BorderFactory.createEtchedBorder());
            result.add(this.myKeepDepthCheck);
            result.add(Box.createRigidArea(new Dimension(1, 10)));
            return result;
        }

        private JPanel getButtons() {
            JButton okButton = new JButton();
            JButton cancelButton = new JButton();
            cancelButton.setText("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportPluginDialog.this.cancelButton_actionPerformed(e);
                }
            });
            okButton.setText("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportPluginDialog.this.okButton_actionPerformed(e);
                }
            });
            JPanel result = new JPanel(new FlowLayout(1));
            result.add(okButton);
            result.add(cancelButton);
            return result;
        }

        public FileLoadPlugin.TasselFileType getTasselFileType() {
            if (this.myHapMapRadioButton.isSelected()) {
                return FileLoadPlugin.TasselFileType.Hapmap;
            }
            if (this.myByteHDF5RadioButton.isSelected()) {
                return FileLoadPlugin.TasselFileType.HDF5;
            }
            if (this.myVCFRadioButton.isSelected()) {
                return FileLoadPlugin.TasselFileType.VCF;
            }
            if (this.myPlinkRadioButton.isSelected()) {
                return FileLoadPlugin.TasselFileType.Plink;
            }
            if (this.myPhylipRadioButton.isSelected()) {
                return FileLoadPlugin.TasselFileType.Phylip_Seq;
            }
            if (this.myPhylipInterRadioButton.isSelected()) {
                return FileLoadPlugin.TasselFileType.Phylip_Inter;
            }
            if (this.myTabTableRadioButton.isSelected()) {
                return FileLoadPlugin.TasselFileType.Table;
            }
            return null;
        }

        public boolean keepDepth() {
            return this.myKeepDepthCheck.isSelected();
        }

        private void okButton_actionPerformed(ActionEvent e) {
            this.myIsCancel = false;
            this.setVisible(false);
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.myIsCancel = true;
            this.setVisible(false);
        }

        public boolean isCancel() {
            return this.myIsCancel;
        }
    }
}

