/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class PlinkLoadPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(PlinkLoadPlugin.class);
    private String myPedFile = null;
    private String myMapFile = null;
    private String myChromosome = null;

    public PlinkLoadPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        if (this.isInteractive()) {
            PlinkLoadPluginDialog theDialog = new PlinkLoadPluginDialog();
            theDialog.setLocationRelativeTo(this.getParentFrame());
            theDialog.setVisible(true);
            if (theDialog.isCancel()) {
                return null;
            }
            theDialog.dispose();
        }
        if (this.myPedFile == null || this.myPedFile.length() == 0) {
            return null;
        }
        if (this.myMapFile == null || this.myMapFile.length() == 0) {
            return null;
        }
        DataSet result = this.loadFile(this.myPedFile, this.myMapFile, this.myChromosome);
        return result;
    }

    public String getPedFile() {
        return this.myPedFile;
    }

    public String getMapFile() {
        return this.myMapFile;
    }

    public String getChromosome() {
        return this.myChromosome;
    }

    public void setPedFile(String filename) {
        this.myPedFile = filename;
    }

    public void setMapFile(String filename) {
        this.myMapFile = filename;
    }

    public void setChromosome(String chromosome) {
        this.myChromosome = chromosome;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Load Plink";
    }

    @Override
    public String getToolTipText() {
        return "Load Plink Files";
    }

    public DataSet loadFile(String thePedFile, String theMapFile, String chromosome) {
        GenotypeTable result = ImportUtils.readFromPLink(thePedFile, theMapFile, this);
        Datum td = new Datum(Utils.getFilename(thePedFile, ".plk.ped"), result, null);
        DataSet tds = new DataSet(td, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(tds, PlinkLoadPlugin.class));
        return tds;
    }

    class PlinkLoadPluginDialog
    extends JDialog {
        private JPanel main;
        private static final int TEXT_FIELD_WIDTH = 30;
        private JTextField myMapFileField;
        private JTextField myPedFileField;
        private JTextField myChromosomeField;
        private boolean myIsCancel;
        private JButton myMapFileBrowseButton;
        private JButton myPedFileBrowseButton;
        private JFileChooser myFileChooser;

        public PlinkLoadPluginDialog() {
            super((Frame)null, "File Loader", true);
            this.main = null;
            this.myMapFileField = null;
            this.myPedFileField = null;
            this.myChromosomeField = null;
            this.myIsCancel = false;
            this.myMapFileBrowseButton = null;
            this.myPedFileBrowseButton = null;
            this.myFileChooser = null;
            try {
                this.createDialog();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void createDialog() {
            this.myPedFileField = new JTextField(30);
            this.myPedFileField.setText("(Select .PED File)");
            this.myMapFileField = new JTextField(30);
            this.myMapFileField.setText("(Select .MAP File)");
            this.myFileChooser = new JFileChooser(TasselPrefs.getOpenDir());
            this.myPedFileBrowseButton = new JButton("Browse...");
            this.myMapFileBrowseButton = new JButton("Browse...");
            this.myPedFileField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String temp = PlinkLoadPluginDialog.this.myMapFileField.getText();
                    if (temp == null || temp.length() == 0) {
                        PlinkLoadPluginDialog.this.myMapFileField.setText(PlinkLoadPluginDialog.this.myPedFileField.getText());
                    }
                }
            });
            Frame frame = JOptionPane.getFrameForComponent(PlinkLoadPlugin.this.getParentFrame());
            this.setLocationRelativeTo(frame);
            this.setTitle("Load Plink");
            this.setDefaultCloseOperation(1);
            this.setUndecorated(false);
            this.getRootPane().setWindowDecorationStyle(0);
            Container contentPane = this.getContentPane();
            BoxLayout layout = new BoxLayout(contentPane, 1);
            contentPane.setLayout(layout);
            this.main = this.getMain();
            contentPane.add(this.main);
            this.pack();
            this.setResizable(false);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ce) {
                    PlinkLoadPluginDialog.this.myPedFileField.requestFocusInWindow();
                }
            });
            this.myPedFileBrowseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PlinkLoadPluginDialog.this.myFileChooser.showOpenDialog(PlinkLoadPluginDialog.this.main) == 0) {
                        File file = PlinkLoadPluginDialog.this.myFileChooser.getSelectedFile();
                        PlinkLoadPluginDialog.this.myPedFileField.setText(file.getPath());
                        TasselPrefs.putOpenDir(PlinkLoadPluginDialog.this.myFileChooser.getCurrentDirectory().getPath());
                    }
                }
            });
            this.myMapFileBrowseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PlinkLoadPluginDialog.this.myFileChooser.showOpenDialog(PlinkLoadPluginDialog.this.main) == 0) {
                        File file = PlinkLoadPluginDialog.this.myFileChooser.getSelectedFile();
                        PlinkLoadPluginDialog.this.myMapFileField.setText(file.getPath());
                        TasselPrefs.putOpenDir(PlinkLoadPluginDialog.this.myFileChooser.getCurrentDirectory().getPath());
                    }
                }
            });
        }

        private JPanel getMain() {
            JPanel inputs = new JPanel();
            BoxLayout layout = new BoxLayout(inputs, 1);
            inputs.setLayout(layout);
            inputs.setAlignmentX(0.5f);
            inputs.add(this.getLine("Ped File:", this.myPedFileField, this.myPedFileBrowseButton));
            inputs.add(this.getLine("Map File:", this.myMapFileField, this.myMapFileBrowseButton));
            inputs.add(Box.createRigidArea(new Dimension(1, 20)));
            inputs.add(this.getButtons());
            return inputs;
        }

        private JButton getResetButton() {
            JButton resetButton = new JButton("Reset");
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlinkLoadPluginDialog.this.myPedFileField.setText("");
                    PlinkLoadPluginDialog.this.myMapFileField.setText("");
                    PlinkLoadPluginDialog.this.myChromosomeField.setText("");
                }
            });
            return resetButton;
        }

        private JPanel getLine(String label, JTextField ref) {
            JPanel result = new JPanel(new FlowLayout(0));
            result.add(new JLabel(label));
            ref.setEditable(true);
            ref.setHorizontalAlignment(2);
            ref.setAlignmentX(0.5f);
            ref.setAlignmentY(0.5f);
            ref.setMaximumSize(ref.getPreferredSize());
            result.add(ref);
            return result;
        }

        private JPanel getLine(String label, JTextField ref, JButton button) {
            JPanel result = new JPanel(new FlowLayout(0));
            result.add(new JLabel(label));
            ref.setEditable(true);
            ref.setHorizontalAlignment(2);
            ref.setAlignmentX(0.5f);
            ref.setAlignmentY(0.5f);
            ref.setMaximumSize(ref.getPreferredSize());
            result.add(ref);
            result.add(button);
            return result;
        }

        private JPanel getButtons() {
            JPanel result = new JPanel(new FlowLayout(1));
            result.add(this.getOkButton());
            result.add(this.getCancelButton());
            result.add(this.getResetButton());
            return result;
        }

        private JButton getCancelButton() {
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlinkLoadPluginDialog.this.myIsCancel = true;
                    PlinkLoadPluginDialog.this.setVisible(false);
                }
            });
            return cancelButton;
        }

        private JButton getOkButton() {
            JButton okButton = new JButton();
            okButton.setText("Ok");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlinkLoadPlugin.this.myPedFile = PlinkLoadPluginDialog.this.myPedFileField.getText();
                    PlinkLoadPlugin.this.myMapFile = PlinkLoadPluginDialog.this.myMapFileField.getText();
                    PlinkLoadPluginDialog.this.myIsCancel = false;
                    PlinkLoadPluginDialog.this.setVisible(false);
                }
            });
            return okButton;
        }

        public boolean isCancel() {
            return this.myIsCancel;
        }
    }
}

