/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class ChromosomeFilterDialog
extends JDialog {
    private int numChromsSelected;
    private boolean isCanceled = true;
    private JPanel mainPanel = new JPanel();
    private JPanel checkBoxPanel = new JPanel();
    private JLabel lblChromSelect = new JLabel();
    private JButton okayButton = new JButton();
    private JButton cancelButton = new JButton();
    private JCheckBox selectAllCheckBox = new JCheckBox();
    private JCheckBox[] selectChromsCheckBoxes;
    private GridBagLayout gridBagLayout = new GridBagLayout();

    public ChromosomeFilterDialog(String[] chromNames, Frame f) {
        super(f, "Filter Alignment", true);
        this.selectChromsCheckBoxes = new JCheckBox[chromNames.length];
        this.selectAllCheckBox.setText("Select/Deselect All");
        this.selectAllCheckBox.setSelected(true);
        for (int i = 0; i < chromNames.length; ++i) {
            this.selectChromsCheckBoxes[i] = new JCheckBox(chromNames[i]);
            this.selectChromsCheckBoxes[i].setSelected(true);
        }
        this.numChromsSelected = chromNames.length;
        try {
            this.initUI();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void initUI() throws Exception {
        int i;
        this.lblChromSelect.setFont(new Font("Dialog", 1, 16));
        this.lblChromSelect.setText("Select Chromosomes to Filter");
        this.mainPanel.setMinimumSize(new Dimension(480, 480));
        this.mainPanel.setPreferredSize(new Dimension(480, 480));
        this.mainPanel.setLayout(this.gridBagLayout);
        this.okayButton.setMaximumSize(new Dimension(63, 27));
        this.okayButton.setMinimumSize(new Dimension(63, 27));
        this.okayButton.setText("Select");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromosomeFilterDialog.this.okayButton_actionPerformed(e);
            }
        });
        this.cancelButton.setMaximumSize(new Dimension(63, 27));
        this.cancelButton.setMinimumSize(new Dimension(63, 27));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromosomeFilterDialog.this.cancelButton_actionPerformed(e);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okayButton);
        buttonPanel.add(this.cancelButton);
        this.selectAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChromosomeFilterDialog.this.selectAllCheckBox_actionPerformed(e);
            }
        });
        for (i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
            this.selectChromsCheckBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChromosomeFilterDialog.this.checkBox_actionPerformed(e);
                }
            });
        }
        this.checkBoxPanel.setLayout(new GridLayout(0, 2));
        for (i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
            this.checkBoxPanel.add(this.selectChromsCheckBoxes[i]);
        }
        this.checkBoxPanel.add(this.selectAllCheckBox);
        this.mainPanel.add((Component)this.lblChromSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.checkBoxPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(20, 40, 5, 0), 15, 0));
        this.mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 20, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.mainPanel, "Center");
    }

    public String[] getChromsSelected() {
        String[] chroms = new String[this.numChromsSelected];
        int j = 0;
        for (int i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
            if (!this.selectChromsCheckBoxes[i].isSelected()) continue;
            chroms[j] = this.selectChromsCheckBoxes[i].getText();
            ++j;
        }
        return chroms;
    }

    private void okayButton_actionPerformed(ActionEvent e) {
        if (this.numChromsSelected != 0) {
            this.isCanceled = false;
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this.getParent(), "Please select at least one chromosome.");
        }
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.isCanceled = true;
        this.setVisible(false);
    }

    private void selectAllCheckBox_actionPerformed(ActionEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            for (int i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
                this.selectChromsCheckBoxes[i].setSelected(true);
            }
            this.numChromsSelected = this.selectChromsCheckBoxes.length;
        } else {
            for (int i = 0; i < this.selectChromsCheckBoxes.length; ++i) {
                this.selectChromsCheckBoxes[i].setSelected(false);
            }
            this.numChromsSelected = 0;
        }
    }

    private void checkBox_actionPerformed(ActionEvent e) {
        if (!((JCheckBox)e.getSource()).isSelected()) {
            this.selectAllCheckBox.setSelected(false);
            --this.numChromsSelected;
        } else {
            ++this.numChromsSelected;
            if (this.numChromsSelected == this.selectChromsCheckBoxes.length) {
                this.selectAllCheckBox.setSelected(true);
            }
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

