/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.filter.DataFilterAlignmentDialog;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import org.apache.log4j.Logger;

public class FilterAlignmentPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterAlignmentPlugin.class);
    private int myStart = 0;
    private int myEnd = -1;
    private int myStartPos = -1;
    private int myEndPos = -1;
    private Chromosome myLocus = null;
    private String myLocusStr = null;
    private int myMinCount = 1;
    private double myMinFreq = 0.01;
    private double myMaxFreq = 1.0;
    private boolean myExtractIndels = false;
    private boolean myFilterMinorSNPs = false;
    private boolean myIsUseAllSiteTypes = true;
    private boolean myDoSlidingHaps = false;
    private int myWinSize = 3;
    private int myStepSize = 3;

    public FilterAlignmentPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() < 1) {
                String gpMessage = "Invalid selection.  Please select genotype alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), gpMessage);
                } else {
                    myLogger.error((Object)gpMessage);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            ArrayList<Datum> alignOutList = new ArrayList<Datum>();
            for (Datum current : alignInList) {
                Datum result = this.processDatum(current, this.isInteractive());
                if (result == null) continue;
                alignOutList.add(result);
            }
            if (alignOutList.isEmpty()) {
                Datum current;
                current = null;
                return current;
            }
            DataSet output = new DataSet(alignOutList, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, FilterAlignmentPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum processDatum(Datum inDatum, boolean isInteractive) {
        Chromosome theLocus;
        GenotypeTable aa = (GenotypeTable)inDatum.getData();
        if (this.myEnd == -1) {
            this.myEnd = aa.numberOfSites() - 1;
        }
        if ((theLocus = this.myLocus) == null && this.myLocusStr != null) {
            theLocus = aa.chromosome(this.myLocusStr);
            if (theLocus == null) {
                throw new IllegalStateException("FilterAlignmentPlugin: processDatum: Alignment doesn't contain locus: " + this.myLocusStr);
            }
            if (this.myStartPos == -1) {
                int[] startEnd = aa.firstLastSiteOfChromosome(theLocus);
                this.myStart = startEnd[0];
                this.myEnd = startEnd[1];
            }
        }
        if (this.myStartPos != -1) {
            this.myStart = aa.siteOfPhysicalPosition(this.myStartPos, theLocus);
            if (this.myStart < 0) {
                this.myStart = -(this.myStart + 1);
            }
        }
        if (this.myEndPos != -1) {
            this.myEnd = aa.siteOfPhysicalPosition(this.myEndPos, theLocus);
            if (this.myEnd < 0) {
                this.myEnd = -(this.myEnd + 2);
            }
        }
        if (this.myEnd < this.myStart) {
            throw new IllegalStateException("FilterAlignmentPlugin: processDatum: Start Site can't be after End Site.");
        }
        if (isInteractive) {
            DataFilterAlignmentDialog theDialog = new DataFilterAlignmentDialog(aa, this.getParentFrame());
            theDialog.setLocationRelativeTo(this.getParentFrame());
            theDialog.setVisible(true);
            if (theDialog.isCanceled()) {
                return null;
            }
            aa = theDialog.getChromFilteredAlignment();
            this.myStart = theDialog.getStart();
            this.myEnd = theDialog.getEnd();
            this.myMinCount = theDialog.getMinimumCount();
            this.myMinFreq = theDialog.getMinimumFrequency();
            this.myMaxFreq = theDialog.getMaximumFrequency();
            this.myExtractIndels = theDialog.isExtractIndels();
            this.myFilterMinorSNPs = theDialog.isRemoveMinorSNPs();
            this.myIsUseAllSiteTypes = theDialog.isAllSiteIncluded();
            this.myDoSlidingHaps = theDialog.isUseSlidingWindow();
            this.myWinSize = theDialog.getWindowSize();
            this.myStepSize = theDialog.getStepSize();
            theDialog.dispose();
        }
        if (this.myStart >= aa.numberOfSites()) {
            throw new IllegalArgumentException("FilterAlignmentPlugin: starting site can't be past end of alignment.");
        }
        if (this.myEnd < 0 || this.myEnd < this.myStart) {
            throw new IllegalArgumentException("FilterAlignmentPlugin: end site can't be less than zero or less that starting site.");
        }
        if (this.myStart < 0) {
            this.myStart = 0;
        }
        if (this.myEnd >= aa.numberOfSites()) {
            this.myEnd = aa.numberOfSites() - 1;
        }
        GenotypeTable naa = aa;
        if (this.myFilterMinorSNPs) {
            naa = GenotypeTableBuilder.getInstanceOnlyMajorMinor(naa);
        }
        if (this.myStart != 0 || this.myEnd < naa.numberOfSites() - 1) {
            naa = GenotypeTableUtils.removeSitesOutsideRange(naa, this.myStart, this.myEnd);
        }
        if (this.myExtractIndels) {
            throw new UnsupportedOperationException();
        }
        naa = GenotypeTableUtils.removeSitesBasedOnFreqIgnoreMissing(naa, this.myMinFreq, this.myMaxFreq, this.myMinCount);
        if (this.myDoSlidingHaps) {
            throw new UnsupportedOperationException();
        }
        StringBuilder builder = new StringBuilder();
        Chromosome[] loci = naa.chromosomes();
        builder.append(inDatum.getName());
        builder.append("_");
        if (loci != null && loci.length != 0) {
            boolean first = true;
            for (int i = 0; i < loci.length; ++i) {
                String name = loci[i].getName();
                if (name == null || name.length() == 0) continue;
                if (first) {
                    builder.append("chr");
                    first = false;
                }
                builder.append(name);
                builder.append("_");
            }
        }
        if (naa.numberOfSites() > 1) {
            builder.append(naa.chromosomalPosition(0));
            builder.append("-");
            builder.append(naa.chromosomalPosition(naa.numberOfSites() - 1));
        }
        String theName = builder.toString();
        String theComment = this.myDoSlidingHaps ? "Sliding Haplotypes.\n" : (this.myExtractIndels ? "Indels\n" : (this.myFilterMinorSNPs ? "Point Poly.\nMinor SNPs Removed\n" : "Point Poly.\n"));
        if (naa.numberOfSites() != 0) {
            myLogger.info((Object)("Resulting Number Sites: " + naa.numberOfSites()));
            return new Datum(theName, naa, theComment);
        }
        if (this.isInteractive()) {
            JOptionPane.showMessageDialog(this.getParentFrame(), "No available SNPs given filter parameters.");
        } else {
            myLogger.warn((Object)"No available SNPs given filter parameters.");
        }
        return null;
    }

    public int getStart() {
        return this.myStart;
    }

    public void setStart(int start) {
        this.myStart = start;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    public int getStartPos() {
        return this.myStartPos;
    }

    public void setStartPos(int start) {
        this.myStartPos = start;
    }

    public int getEndPos() {
        return this.myEndPos;
    }

    public void setEndPos(int end) {
        this.myEndPos = end;
    }

    public String getLocusStr() {
        return this.myLocusStr;
    }

    public void setLocusStr(String name) {
        this.myLocus = null;
        this.myLocusStr = name;
    }

    public Chromosome getLocus() {
        return this.myLocus;
    }

    public void setLocus(Chromosome locus) {
        this.myLocusStr = null;
        this.myLocus = locus;
    }

    public int getMinCount() {
        return this.myMinCount;
    }

    public void setMinCount(int minCount) {
        this.myMinCount = minCount;
    }

    public double getMinFreq() {
        return this.myMinFreq;
    }

    public void setMinFreq(double minFreq) {
        this.myMinFreq = minFreq;
    }

    public double getMaxFreq() {
        return this.myMaxFreq;
    }

    public void setMaxFreq(double maxFreq) {
        this.myMaxFreq = maxFreq;
    }

    public boolean isExtractIndels() {
        return this.myExtractIndels;
    }

    public void setExtractIndels(boolean extractIndels) {
        this.myExtractIndels = extractIndels;
    }

    public boolean isFilterMinorSNPs() {
        return this.myFilterMinorSNPs;
    }

    public void setFilterMinorSNPs(boolean filterMinorSNPs) {
        this.myFilterMinorSNPs = filterMinorSNPs;
    }

    public boolean isUseAllSiteTypes() {
        return this.myIsUseAllSiteTypes;
    }

    public void setUseAllSiteTypes(boolean useAllSiteTypes) {
        this.myIsUseAllSiteTypes = useAllSiteTypes;
    }

    public boolean isDoSlidingHaps() {
        return this.myDoSlidingHaps;
    }

    public void setDoSlidingHaps(boolean doSlidingHaps) {
        this.myDoSlidingHaps = doSlidingHaps;
    }

    public int getWinSize() {
        return this.myWinSize;
    }

    public void setWinSize(int winSize) {
        this.myWinSize = winSize;
    }

    public int getStepSize() {
        return this.myStepSize;
    }

    public void setStepSize(int stepSize) {
        this.myStepSize = stepSize;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterAlignmentPlugin.class.getResource("/net/maizegenetics/analysis/images/Filter.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Sites";
    }

    @Override
    public String getToolTipText() {
        return "Filter and Process Alignment";
    }
}

