/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.maizegenetics.prefs.TasselPrefs;

class FilterTaxaPropertiesDialog
extends JDialog {
    private static final int TEXT_FIELD_WIDTH = 10;
    private JTabbedPane myTabbedPane = new JTabbedPane();
    private JTextField myMinNotMissingField = new JTextField(10);
    private JTextField myMinHeterozygousField = new JTextField(10);
    private JTextField myMaxHeterozygousField = new JTextField(10);
    private double myMinNotMissing = TasselPrefs.getFilterTaxaPropsMinNotMissingFreq();
    private double myMinHeterozygous = TasselPrefs.getFilterTaxaPropsMinHetFreq();
    private double myMaxHeterozygous = TasselPrefs.getFilterTaxaPropsMaxHetFreq();
    private boolean myIsCancel = true;
    private boolean myIsOkToContinue = true;

    public FilterTaxaPropertiesDialog() {
        super((Frame)null, null, true);
        JButton okButton = new JButton();
        okButton.setActionCommand("Ok");
        okButton.setText("Ok");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterTaxaPropertiesDialog.this.myIsOkToContinue) {
                    FilterTaxaPropertiesDialog.this.myIsCancel = false;
                    FilterTaxaPropertiesDialog.this.setVisible(false);
                } else {
                    FilterTaxaPropertiesDialog.this.myIsOkToContinue = true;
                }
            }
        });
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterTaxaPropertiesDialog.this.myIsCancel = true;
                FilterTaxaPropertiesDialog.this.setVisible(false);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.getLine("Min Proportion of Sites Present", this.myMinNotMissingField));
        panel.add(this.getLine("Min Heterozygous Proportion", this.myMinHeterozygousField));
        panel.add(this.getLine("Max Heterozygous Proportion", this.myMaxHeterozygousField));
        this.myMinNotMissingField.setText(String.valueOf(this.myMinNotMissing));
        this.myMinNotMissingField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FilterTaxaPropertiesDialog.this.myMinNotMissing = FilterTaxaPropertiesDialog.this.focusLostParseFreq(FilterTaxaPropertiesDialog.this.myMinNotMissingField, FilterTaxaPropertiesDialog.this.myMinNotMissing);
                TasselPrefs.putFilterTaxaPropsMinNotMissingFreq(FilterTaxaPropertiesDialog.this.myMinNotMissing);
            }
        });
        this.myMinHeterozygousField.setText(String.valueOf(this.myMinHeterozygous));
        this.myMinHeterozygousField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FilterTaxaPropertiesDialog.this.myMinHeterozygous = FilterTaxaPropertiesDialog.this.focusLostParseFreq(FilterTaxaPropertiesDialog.this.myMinHeterozygousField, FilterTaxaPropertiesDialog.this.myMinHeterozygous);
                TasselPrefs.putFilterTaxaPropsMinHetFreq(FilterTaxaPropertiesDialog.this.myMinHeterozygous);
            }
        });
        this.myMaxHeterozygousField.setText(String.valueOf(this.myMaxHeterozygous));
        this.myMaxHeterozygousField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FilterTaxaPropertiesDialog.this.myMaxHeterozygous = FilterTaxaPropertiesDialog.this.focusLostParseFreq(FilterTaxaPropertiesDialog.this.myMaxHeterozygousField, FilterTaxaPropertiesDialog.this.myMaxHeterozygous);
                TasselPrefs.putFilterTaxaPropsMaxHetFreq(FilterTaxaPropertiesDialog.this.myMaxHeterozygous);
            }
        });
        this.myTabbedPane.add((Component)panel, "Filter Taxa by Properties");
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout());
        pnlButtons.add(okButton);
        pnlButtons.add(closeButton);
        this.getContentPane().add((Component)this.myTabbedPane, "Center");
        this.getContentPane().add((Component)pnlButtons, "South");
        this.pack();
    }

    public boolean isCancel() {
        return this.myIsCancel;
    }

    public double getMinNotMissingProportion() {
        return this.myMinNotMissing;
    }

    public double getMinHeterozygousProportion() {
        return this.myMinHeterozygous;
    }

    public double getMaxHeterozygousProportion() {
        return this.myMaxHeterozygous;
    }

    private double focusLostParseFreq(JTextField field, double lastValue) {
        this.myIsOkToContinue = true;
        double freq = -0.1;
        try {
            String input = field.getText().trim();
            if (input != null) {
                freq = Double.parseDouble(input);
            }
            if (freq > 1.0 || freq < 0.0) {
                this.myIsOkToContinue = false;
                JOptionPane.showMessageDialog(this, "Please enter a value between 0.0 and 1.0");
                freq = lastValue;
            }
        }
        catch (NumberFormatException nfe) {
            this.myIsOkToContinue = false;
            JOptionPane.showMessageDialog(this, "Please enter a value between 0.0 and 1.0");
            freq = lastValue;
        }
        field.setText(String.valueOf(freq));
        return freq;
    }

    private JPanel getLine(String label, JTextField ref) {
        JPanel result = new JPanel(new FlowLayout(2));
        result.add(new JLabel(label));
        ref.setEditable(true);
        ref.setHorizontalAlignment(2);
        ref.setAlignmentX(0.5f);
        ref.setAlignmentY(0.5f);
        ref.setMaximumSize(ref.getPreferredSize());
        result.add(ref);
        return result;
    }
}

