/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class CompareGenosBetweenHapMapFilesPlugin
extends AbstractPlugin {
    private final Logger myLogger = Logger.getLogger(CompareGenosBetweenHapMapFilesPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String hmp1FileStr;
    private String hmp2FileStr;
    private int startChr;
    private int endChr;
    private int chr;
    private int position;
    private Multimap<String, String> taxaSynonyms = HashMultimap.create();
    private HashMap<Integer, List<Integer>> taxaRedirect = new HashMap();
    private final String DELIMITER = "\t";
    int nCompared = 0;
    int nSamePosNotComparable;
    static final int NUM_TAXA_POSSIBLE_COMPARISONS = 0;
    static final int NUM_TAXA_MISSING = 1;
    static final int NUM_TAXA_COMPARED = 2;
    static final int NUM_TAXA_DIFFERENT = 3;
    static final int NUM_TAXA_HOMOZYGOUS_COMPARED = 4;
    static final int NUM_TAXA_HOMOZYGOUS_DIFF = 5;
    static final int COMPARE_STATS_LENGTH = 6;
    static final int NUM_SITES_COMPARED = 0;
    static final int NUM_SITES_DIFF = 1;
    static final int NUM_SITES_HOMOZYGOUS_COMPARED = 2;
    static final int NUM_SITES_HOMOZYGOUS_DIFF = 3;
    static final int COMPARE_TAXA_STATS_LENGTH = 4;
    static final int MINOR_ALLELE_FREQ1 = 0;
    static final int MINOR_ALLELE_FREQ2 = 1;
    static final int F_VALUE1 = 2;
    static final int F_VALUE2 = 3;
    static final int summStatsLength = 4;
    File outfile = null;
    DataOutputStream fw = null;
    private int myNumCalculations = 0;
    private List<Integer> myComparisons = new ArrayList<Integer>();
    private List<Double> myErrorRates = new ArrayList<Double>();
    private List<Integer> myHomComparisons = new ArrayList<Integer>();
    private List<Integer> myHomDiff = new ArrayList<Integer>();
    private List<Double> myHomError = new ArrayList<Double>();
    int[][][] myCompareStatsTaxa;

    public CompareGenosBetweenHapMapFilesPlugin() {
        super(null, false);
    }

    public CompareGenosBetweenHapMapFilesPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.myLogger.info((Object)"\n\nThe options for CompareGenosBetweenHapMapFilesPlugin are:\n    -hmp1  First hapmap format genotypic input file (use \"+\" as a wildcard character in place of the chromosome number)\n    -hmp2  Second hapmap format genotypic input file to compare the first one to (use \"+\" as a wildcard character in place of the chromosome number)\n    -sC    Start chromosome\n    -eC    End chromosome\n    -syn   Lookup table file of synonymous full taxon names in hmp1 and hmp2 (header line is ignored)\n    -o     Output file for report (tab-delimited text format)\n\n\n");
    }

    @Override
    public void setParameters(String[] args) {
        File hmp1File;
        this.myLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-hmp1", "--hapmap-file1", true);
            this.myArgsEngine.add("-hmp2", "--hapmap-file2", true);
            this.myArgsEngine.add("-syn", "--synonym-file", true);
            this.myArgsEngine.add("-o", "--output-file", true);
        }
        this.myArgsEngine.parse(args);
        if (this.myArgsEngine.getBoolean("-syn")) {
            String synFileStr = this.myArgsEngine.getString("-syn");
            File synFile = new File(synFileStr);
            if (!synFile.exists() || !synFile.isFile()) {
                this.printUsage();
                throw new IllegalArgumentException("Can't find the file containing the synonym table for full taxon names (-syn option: " + synFileStr + ").");
            }
            if (!this.readTaxaSynonymsFromFile(synFile)) {
                throw new IllegalArgumentException("Problem reading the file containing the synonym table for full taxon names. Progam aborted.");
            }
        } else {
            this.createTaxaSynonymsFromAlignment(this.myArgsEngine.getString("-hmp1"), this.myArgsEngine.getString("-hmp2"));
        }
        if (this.myArgsEngine.getBoolean("-hmp1")) {
            this.hmp1FileStr = this.myArgsEngine.getString("-hmp1");
            hmp1File = new File(this.hmp1FileStr);
            if (!hmp1File.exists() || !hmp1File.isFile()) {
                this.printUsage();
                throw new IllegalArgumentException("Can't find the first hapmap format genotype input file (-hmp1 option: " + this.hmp1FileStr + ").");
            }
        }
        if (this.myArgsEngine.getBoolean("-hmp2")) {
            this.hmp2FileStr = this.myArgsEngine.getString("-hmp2");
            hmp1File = new File(this.hmp1FileStr);
            if (!hmp1File.exists() || !hmp1File.isFile()) {
                this.printUsage();
                throw new IllegalArgumentException("Can't find the first hapmap format genotype input file (-hmp1 option: " + this.hmp2FileStr + ").");
            }
        }
        if (this.myArgsEngine.getBoolean("-o")) {
            String outFileStr = this.myArgsEngine.getString("-o");
            this.outfile = new File(outFileStr);
            try {
                this.fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outfile), 65536));
                this.fw.writeBytes("Chr\tPosition\tAlleles1\tAlleles2\tCompareType\tMAF1\tMAF2\tf1\tf2\tSynonymousTaxaPairs\tMissing\tComparisons\tDiff\tErrorRate\tHomComparisons\tHomDiff\tHomErrorRate\n");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to write to your output report file: " + e);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output report file (inside an existing directory) (option -o).");
        }
    }

    @Override
    public DataSet performFunction(DataSet input) {
        GenotypeTable a2;
        GenotypeTable a1;
        this.myLogger.info((Object)("Comparing: " + this.hmp1FileStr + " to " + this.hmp2FileStr));
        try {
            a1 = ImportUtils.readGuessFormat(this.hmp1FileStr);
        }
        catch (Exception e) {
            this.myLogger.info((Object)("Could not read the first input hapmap file for chr" + this.chr + ":\n\t" + this.hmp2FileStr + "\n\tSkipping..."));
            return null;
        }
        try {
            a2 = ImportUtils.readGuessFormat(this.hmp2FileStr);
        }
        catch (Exception e) {
            this.myLogger.info((Object)("Could not read the second input hapmap file for chr" + this.chr + ":\n\t" + this.hmp2FileStr + "\n\tSkipping..."));
            return null;
        }
        this.populateTaxaRedirect(a1, a2);
        this.myCompareStatsTaxa = new int[this.taxaRedirect.size()][][];
        this.findCommonPositionsAndCompare(a1, a2);
        int[] comparisons = new int[this.myNumCalculations];
        double comparisonMean = 0.0;
        double[] errorRates = new double[this.myNumCalculations];
        double errorRateMean = 0.0;
        int[] homComparisons = new int[this.myNumCalculations];
        double homDiffSum = 0.0;
        double homComparisonSum = 0.0;
        double[] homErrors = new double[this.myNumCalculations];
        double homErrorSum = 0.0;
        for (int i = 0; i < this.myNumCalculations; ++i) {
            comparisons[i] = this.myComparisons.get(i);
            comparisonMean += (double)comparisons[i];
            errorRates[i] = this.myErrorRates.get(i);
            errorRateMean += errorRates[i];
            homComparisons[i] = this.myHomComparisons.get(i);
            homComparisonSum += (double)homComparisons[i];
            homDiffSum += (double)this.myHomDiff.get(i).intValue();
            homErrors[i] = this.myHomError.get(i);
            homErrorSum += homErrors[i];
        }
        double overAllHomoErrorRate = homDiffSum / homComparisonSum;
        comparisonMean /= (double)this.myNumCalculations;
        double comparisonMedian = CompareGenosBetweenHapMapFilesPlugin.getMedian(comparisons);
        errorRateMean /= (double)this.myNumCalculations;
        double errorRateMedian = CompareGenosBetweenHapMapFilesPlugin.getMedian(errorRates);
        double homComparisonMean = homComparisonSum / (double)this.myNumCalculations;
        double homComparisonMedian = CompareGenosBetweenHapMapFilesPlugin.getMedian(homComparisons);
        double homErrorMean = homErrorSum / (double)this.myNumCalculations;
        double homErrorMedian = CompareGenosBetweenHapMapFilesPlugin.getMedian(homErrors);
        this.myLogger.info((Object)"Comparison Mean\tComparison Median\tError Rate Mean\tError Rate Median\tHomozygous Comparison Mean\tHomozygous Comparison Median\tHomozygous Error Mean\tHomozygous Error Median");
        this.myLogger.info((Object)(comparisonMean + "\t" + comparisonMedian + "\t" + errorRateMean + "\t" + errorRateMedian + "\t" + homComparisonMean + "\t" + homComparisonMedian + "\t" + homErrorMean + "\t" + homErrorMedian));
        this.myLogger.info((Object)"Output Filename\tOver All Homo Error Rate\tCoverage");
        this.myLogger.info((Object)(this.outfile.getName() + "\t" + overAllHomoErrorRate + "\t" + (this.nSamePosNotComparable + this.nCompared)));
        this.closeOutputFile();
        return null;
    }

    private static double getMedian(int[] values) {
        Arrays.sort(values);
        int middle = values.length / 2;
        if (values.length % 2 == 1) {
            return (double)(values[middle - 1] + values[middle]) / 2.0;
        }
        return values[middle];
    }

    private static double getMedian(double[] values) {
        Arrays.sort(values);
        int middle = values.length / 2;
        if (values.length % 2 == 1) {
            return (values[middle - 1] + values[middle]) / 2.0;
        }
        return values[middle];
    }

    private boolean readTaxaSynonymsFromFile(File synFile) {
        this.taxaSynonyms.clear();
        String inputLine = "Nothing has been read from the taxon synonym input file yet";
        int nTaxa = 0;
        int nCompareTaxa = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(synFile), 65536);
            inputLine = br.readLine();
            while ((inputLine = br.readLine()) != null) {
                String[] cells = inputLine.split("\t");
                if (!cells[0].equals("NA") && !cells[1].equals("NA")) {
                    this.taxaSynonyms.put((Object)cells[0], (Object)cells[1]);
                    ++nCompareTaxa;
                }
                ++nTaxa;
            }
        }
        catch (Exception e) {
            this.myLogger.error((Object)("Catch in reading taxon synonym input file e=" + e));
            e.printStackTrace();
            this.myLogger.info((Object)inputLine);
            return false;
        }
        this.myLogger.info((Object)(nTaxa + " pairs of taxa full names read from the taxon synonym input file: " + nCompareTaxa + " of these will be compared (if found in the genotype files)"));
        return true;
    }

    private boolean createTaxaSynonymsFromAlignment(String f1, String f2) {
        GenotypeTable a1 = ImportUtils.readGuessFormat(f1);
        GenotypeTable a2 = ImportUtils.readGuessFormat(f1);
        this.taxaSynonyms.clear();
        int nTaxa = 0;
        int nCompareTaxa = 0;
        for (Taxon taxon : a1.taxa()) {
            int t2a = a2.taxa().indexOf(taxon);
            if (t2a >= 0) {
                this.taxaSynonyms.put((Object)taxon.getName(), (Object)a2.taxaName(t2a));
                ++nCompareTaxa;
            }
            ++nTaxa;
        }
        this.myLogger.info((Object)(nTaxa + " pairs of taxa full names read are identical between alignments: " + nCompareTaxa + " of these will be compared (if found in the genotype files)"));
        return true;
    }

    private void populateTaxaRedirect(GenotypeTable a1, GenotypeTable a2) {
        this.taxaRedirect.clear();
        this.myLogger.info((Object)"\n\nMaking list of comparable taxa found in the two hapmap files...\n");
        System.out.println("Taxon1\t\tTaxon2");
        System.out.println("------\t\t------");
        int nTaxaPairs = 0;
        for (int taxon1Index = 0; taxon1Index < a1.numberOfTaxa(); ++taxon1Index) {
            String taxon1 = a1.taxaName(taxon1Index);
            if (!this.taxaSynonyms.containsKey((Object)taxon1)) continue;
            block1: for (String taxon2 : this.taxaSynonyms.get((Object)taxon1)) {
                for (int taxon2Index = 0; taxon2Index < a2.numberOfTaxa(); ++taxon2Index) {
                    if (!taxon2.equals(a2.taxaName(taxon2Index))) continue;
                    List<Integer> synTaxaIndicesForTaxonIndex = this.taxaRedirect.get(taxon1Index);
                    if (synTaxaIndicesForTaxonIndex == null) {
                        synTaxaIndicesForTaxonIndex = new ArrayList<Integer>();
                        this.taxaRedirect.put(taxon1Index, synTaxaIndicesForTaxonIndex);
                    }
                    synTaxaIndicesForTaxonIndex.add(taxon2Index);
                    System.out.println(taxon1 + "\t" + taxon2);
                    ++nTaxaPairs;
                    continue block1;
                }
            }
        }
        this.myLogger.info((Object)("\nHapMap format genotype file1 contains " + a1.numberOfTaxa() + " taxa in total\n"));
        this.myLogger.info((Object)("\nHapMap format genotype file2 contains " + a2.numberOfTaxa() + " taxa in total\n"));
        this.myLogger.info((Object)("\n" + nTaxaPairs + " pairs of comparable taxa found in the two hapmap files\n\n"));
    }

    private void findCommonPositionsAndCompare(GenotypeTable a1, GenotypeTable a2) {
        this.nCompared = 0;
        this.nSamePosNotComparable = 0;
        for (int s1 = 0; s1 < a1.numberOfSites(); ++s1) {
            Position p1 = (Position)a1.positions().get(s1);
            int s2 = a2.siteOfPhysicalPosition(p1.getPosition(), p1.getChromosome());
            if (s2 < 0) continue;
            this.position = a1.chromosomalPosition(s1);
            this.nCompared += this.getCompareTypeAndCompare(s1, a1, s2, a2);
        }
        this.myLogger.info((Object)(this.nCompared + " sites compared on chromosome " + this.chr + "\nAn additional " + this.nSamePosNotComparable + " sites on chromosome " + this.chr + " had the same position but incomparable alleles\n"));
        this.outputTaxaReport(a1, a2);
    }

    private void outputTaxaReport(GenotypeTable a1, GenotypeTable a2) {
        System.out.println("Taxon1\tTaxon2\tNum_Sites_Compared\tNum_Sites_Diff\tNum_Sites_Homo_Compared\tNum_Sites_Homo_Diff");
        int taxon1Count = 0;
        for (Integer taxon1Index : this.taxaRedirect.keySet()) {
            List<Integer> synTaxaIndicesForTaxonIndex = this.taxaRedirect.get(taxon1Index);
            int taxon2Count = 0;
            for (Integer taxon2Index : synTaxaIndicesForTaxonIndex) {
                StringBuilder builder = new StringBuilder();
                builder.append(a1.taxaName(taxon1Index));
                builder.append("\t");
                builder.append(a2.taxaName(taxon2Index));
                builder.append("\t");
                builder.append(this.myCompareStatsTaxa[taxon1Count][taxon2Count][0]);
                builder.append("\t");
                builder.append(this.myCompareStatsTaxa[taxon1Count][taxon2Count][1]);
                builder.append("\t");
                builder.append(this.myCompareStatsTaxa[taxon1Count][taxon2Count][2]);
                builder.append("\t");
                builder.append(this.myCompareStatsTaxa[taxon1Count][taxon2Count][3]);
                System.out.println(builder.toString());
                ++taxon2Count;
            }
            ++taxon1Count;
        }
    }

    private int getCompareTypeAndCompare(int site1, GenotypeTable a1, int site2, GenotypeTable a2) {
        SiteCompareType compareType;
        byte[] alleles1 = a1.alleles(site1);
        byte[] alleles2 = a2.alleles(site2);
        SiteCompareType siteCompareType = compareType = ((Position)a1.positions().get(site1)).getStrand() == ((Position)a2.positions().get(site2)).getStrand() ? SiteCompareType.SAME_STRAND : SiteCompareType.DIFFERENT;
        if (compareType == SiteCompareType.DIFFERENT) {
            ++this.nSamePosNotComparable;
            return 0;
        }
        double[] summStats = new double[]{a1.minorAlleleFrequency(site1), a2.minorAlleleFrequency(site2), this.calculateF(a1, site1), this.calculateF(a2, site2)};
        String alleleString1 = Joiner.on((String)"/").join(GenotypeTableUtils.convertNucleotideGenotypesToStringList(alleles1));
        String alleleString2 = Joiner.on((String)"/").join(GenotypeTableUtils.convertNucleotideGenotypesToStringList(alleles2));
        int[][][] compareTaxaStatsSame = new int[this.taxaRedirect.size()][][];
        int[] compareStatsSame = null;
        int taxon1Count = 0;
        for (Integer taxon1Index : this.taxaRedirect.keySet()) {
            List<Integer> synTaxaIndicesForTaxonIndex = this.taxaRedirect.get(taxon1Index);
            if (this.myCompareStatsTaxa[taxon1Count] == null) {
                this.myCompareStatsTaxa[taxon1Count] = new int[synTaxaIndicesForTaxonIndex.size()][4];
            }
            compareTaxaStatsSame[taxon1Count] = new int[synTaxaIndicesForTaxonIndex.size()][4];
            int taxon2Count = 0;
            for (Integer taxon2Index : synTaxaIndicesForTaxonIndex) {
                if (compareType == SiteCompareType.SAME_STRAND || compareType == SiteCompareType.EITHER_STRAND) {
                    int[] tempStats = this.compareGenotypes(taxon1Index, site1, a1, taxon2Index, site2, a2, true);
                    if (compareStatsSame == null) {
                        compareStatsSame = new int[6];
                    }
                    for (int i = 0; i < 6; ++i) {
                        int n = i;
                        compareStatsSame[n] = compareStatsSame[n] + tempStats[i];
                    }
                    compareTaxaStatsSame[taxon1Count][taxon2Count][0] = 1;
                    compareTaxaStatsSame[taxon1Count][taxon2Count][1] = tempStats[3];
                    compareTaxaStatsSame[taxon1Count][taxon2Count][2] = tempStats[4];
                    compareTaxaStatsSame[taxon1Count][taxon2Count][3] = tempStats[5];
                }
                ++taxon2Count;
            }
            ++taxon1Count;
        }
        int[] compareResults = compareStatsSame;
        this.addTaxaStats(this.myCompareStatsTaxa, compareTaxaStatsSame);
        this.writeCompareStats(compareResults, alleleString1, alleleString2, compareType, summStats);
        return 1;
    }

    private void addTaxaStats(int[][][] totals, int[][][] additions) {
        for (int i = 0; i < totals.length; ++i) {
            for (int j = 0; j < totals[0].length; ++j) {
                for (int k = 0; k < totals[0][0].length; ++k) {
                    int[] nArray = totals[i][j];
                    int n = k;
                    nArray[n] = nArray[n] + additions[i][j][k];
                }
            }
        }
    }

    private double calculateF(GenotypeTable a, int site) {
        byte majAllele = a.majorAllele(site);
        byte minAllele = a.minorAllele(site);
        int majGenoCnt = 0;
        int minGenoCnt = 0;
        int hetGenoCnt = 0;
        int nTaxa = a.numberOfTaxa();
        for (int taxon = 0; taxon < nTaxa; ++taxon) {
            byte[] bases = a.genotypeArray(taxon, site);
            if (bases[0] == majAllele && bases[1] == majAllele) {
                ++majGenoCnt;
                continue;
            }
            if (bases[0] == minAllele && bases[1] == minAllele) {
                ++minGenoCnt;
                continue;
            }
            if (!GenotypeTableUtils.isEqual(bases, new byte[]{majAllele, minAllele})) continue;
            ++hetGenoCnt;
        }
        int nGenos = hetGenoCnt + majGenoCnt + minGenoCnt;
        if (nGenos > 0) {
            double propHets = (double)hetGenoCnt / (double)nGenos;
            double maf = (double)(2 * majGenoCnt + hetGenoCnt) / (double)(2 * nGenos);
            double expHets = 2.0 * maf * (1.0 - maf);
            return 1.0 - propHets / expHets;
        }
        return Double.NaN;
    }

    private int[] compareGenotypes(int taxon1Index, int site1, GenotypeTable a1, int taxon2Index, int site2, GenotypeTable a2, boolean sameStrand) {
        int[] compareStats = new int[6];
        byte base1 = a1.genotype(taxon1Index, site1);
        byte base2 = sameStrand ? a2.genotype(taxon2Index, site2) : NucleotideAlignmentConstants.getNucleotideDiploidComplement(a2.genotype(taxon2Index, site2));
        if (base1 != -1 && base2 != -1) {
            if (!GenotypeTableUtils.isHeterozygous(base1) && !GenotypeTableUtils.isHeterozygous(base2)) {
                if (base1 != base2) {
                    compareStats[3] = compareStats[3] + 1;
                    compareStats[5] = compareStats[5] + 1;
                }
                compareStats[4] = compareStats[4] + 1;
            } else if (!GenotypeTableUtils.isEqual(base1, base2)) {
                compareStats[3] = compareStats[3] + 1;
            }
            compareStats[2] = compareStats[2] + 1;
        } else {
            compareStats[1] = compareStats[1] + 1;
        }
        compareStats[0] = compareStats[0] + 1;
        return compareStats;
    }

    private void writeCompareStats(int[] compareStats, String alleles1, String alleles2, SiteCompareType sct, double[] summStats) {
        double errRate = compareStats[2] > 0 ? (double)compareStats[3] / (double)compareStats[2] : Double.NaN;
        double errRateHom = compareStats[4] > 0 ? (double)compareStats[5] / (double)compareStats[4] : Double.NaN;
        try {
            this.fw.writeBytes(String.valueOf(this.chr));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(this.position));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(alleles1);
            this.fw.writeBytes("\t");
            this.fw.writeBytes(alleles2);
            this.fw.writeBytes("\t");
            this.fw.writeBytes(sct.toString());
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(summStats[0]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(summStats[1]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(summStats[2]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(summStats[3]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(compareStats[0]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(compareStats[1]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(compareStats[2]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(compareStats[3]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(errRate));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(compareStats[4]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(compareStats[5]));
            this.fw.writeBytes("\t");
            this.fw.writeBytes(String.valueOf(errRateHom));
            this.fw.writeBytes("\n");
            ++this.myNumCalculations;
            this.myComparisons.add(compareStats[2]);
            this.myErrorRates.add(errRate);
            this.myHomDiff.add(compareStats[5]);
            this.myHomComparisons.add(compareStats[4]);
            this.myHomError.add(errRateHom);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to write to your output report file: " + e);
        }
    }

    private void closeOutputFile() {
        try {
            this.fw.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to close your output report file: " + e);
        }
    }

    public static SiteCompareType getSiteCompareType(byte[] alleles1, byte[] alleles2) {
        byte diploidValue1 = GenotypeTableUtils.getDiploidValue(alleles1[0], alleles1[1]);
        byte diploidValue2 = GenotypeTableUtils.getDiploidValue(alleles2[0], alleles2[1]);
        String iupac1 = NucleotideAlignmentConstants.getNucleotideIUPAC(diploidValue1);
        String iupac2 = NucleotideAlignmentConstants.getNucleotideIUPAC(diploidValue2);
        if (iupac1 == null || iupac2 == null) {
            return SiteCompareType.DIFFERENT;
        }
        char hetg1 = iupac1.charAt(0);
        char hetg2 = iupac2.charAt(0);
        if (hetg1 == '0' || hetg1 == '-' || hetg1 == '+' || hetg1 == 'N' || hetg2 == '0' || hetg2 == '-' || hetg2 == '+' || hetg2 == 'N') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'K' && hetg2 == 'K') {
            return SiteCompareType.SAME_STRAND;
        }
        if (hetg1 == 'M' && hetg2 == 'M') {
            return SiteCompareType.SAME_STRAND;
        }
        if (hetg1 == 'R' && hetg2 == 'R') {
            return SiteCompareType.SAME_STRAND;
        }
        if (hetg1 == 'Y' && hetg2 == 'Y') {
            return SiteCompareType.SAME_STRAND;
        }
        if (hetg1 == 'S' && hetg2 == 'S') {
            return SiteCompareType.EITHER_STRAND;
        }
        if (hetg1 == 'W' && hetg2 == 'W') {
            return SiteCompareType.EITHER_STRAND;
        }
        if (hetg1 == 'K' && hetg2 == 'M') {
            return SiteCompareType.DIFF_STRAND;
        }
        if (hetg1 == 'M' && hetg2 == 'K') {
            return SiteCompareType.DIFF_STRAND;
        }
        if (hetg1 == 'R' && hetg2 == 'Y') {
            return SiteCompareType.DIFF_STRAND;
        }
        if (hetg1 == 'Y' && hetg2 == 'R') {
            return SiteCompareType.DIFF_STRAND;
        }
        if (hetg1 == 'K' && hetg2 == 'R') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'K' && hetg2 == 'S') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'K' && hetg2 == 'W') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'K' && hetg2 == 'Y') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'M' && hetg2 == 'R') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'M' && hetg2 == 'S') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'M' && hetg2 == 'W') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'M' && hetg2 == 'Y') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'R' && hetg2 == 'K') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'R' && hetg2 == 'M') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'R' && hetg2 == 'S') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'R' && hetg2 == 'W') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'S' && hetg2 == 'K') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'S' && hetg2 == 'M') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'S' && hetg2 == 'R') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'S' && hetg2 == 'W') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'S' && hetg2 == 'Y') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'W' && hetg2 == 'K') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'W' && hetg2 == 'M') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'W' && hetg2 == 'R') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'W' && hetg2 == 'S') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'W' && hetg2 == 'Y') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'Y' && hetg2 == 'K') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'Y' && hetg2 == 'M') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'Y' && hetg2 == 'S') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'Y' && hetg2 == 'W') {
            return SiteCompareType.DIFFERENT;
        }
        if (hetg1 == 'A' || hetg1 == 'C' || hetg1 == 'G' || hetg1 == 'T' || hetg2 == 'A' || hetg2 == 'C' || hetg2 == 'G' || hetg2 == 'T') {
            return SiteCompareType.DIFFERENT;
        }
        return SiteCompareType.DIFFERENT;
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum SiteCompareType {
        SAME_STRAND,
        EITHER_STRAND,
        DIFF_STRAND,
        DIFFERENT;

    }
}

