/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.dna.tag.TagsByTaxaShort;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class FastqToTBTPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FastqToTBTPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String[] myFastqFileS = null;
    private String myKeyFile = null;
    private String myEnzyme = null;
    private String myOutputDir = null;
    private int myMinCount = 1;
    private Tags myMasterTags = null;
    private boolean useTBTByte = false;
    private boolean useTBTShort = false;

    public FastqToTBTPlugin() {
        super(null, false);
    }

    public FastqToTBTPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        FastqToTBTPlugin.matchTagsToTaxa(this.myFastqFileS, this.myKeyFile, this.myEnzyme, this.myMasterTags, this.myOutputDir, this.myMinCount, this.useTBTByte, this.useTBTShort);
        return null;
    }

    private void printUsage() {
        myLogger.info((Object)"\nUsage is as follows:\n-i  Input directory containing .fastq files\n-k  Barcode key file\n-e  Enzyme used to create the GBS library, if it differs from the one listed in the key file.\n-o  Output directory\n-c  Minimum taxa count within a fastq file for a tag to be output (default 1)\n-y  Output to tagsByTaxaByte (tag counts per taxon from 0 to 127) instead of tagsByTaxaBit (0 or 1)\nOne of either:\n    -t  Tag count file, OR A\n    -m  Physical map file containing alignments\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-directory", true);
            this.myArgsEngine.add("-k", "--key-file", true);
            this.myArgsEngine.add("-e", "--enzyme", true);
            this.myArgsEngine.add("-o", "--output-directory", true);
            this.myArgsEngine.add("-c", "--min-count", true);
            this.myArgsEngine.add("-y", "--TBTByte", false);
            this.myArgsEngine.add("-sh", "--TBTShort", false);
            this.myArgsEngine.add("-t", "--tag-count", true);
            this.myArgsEngine.add("-m", "--physical-map", true);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-i");
        if (tempDirectory != null) {
            File fastqDirectory = new File(tempDirectory);
            if (!fastqDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.myFastqFileS = DirectoryCrawler.listFileNames("(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$", fastqDirectory.getAbsolutePath());
            if (this.myFastqFileS.length == 0 || this.myFastqFileS == null) {
                this.printUsage();
                throw new IllegalArgumentException("Couldn't find any files that end with \".fq\", \".fq.gz\", \".fastq\", \"_fastq.txt\", \"_fastq.gz\", \"_fastq.txt.gz\", \"_sequence.txt\", or \"_sequence.txt.gz\" in the supplied directory: " + tempDirectory);
            }
            myLogger.info((Object)"FastqToTBTPlugin: setParameters: Using the following fastq files:");
            for (String filename : this.myFastqFileS) {
                myLogger.info((Object)filename);
            }
        }
        if (!this.myArgsEngine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a key file (option -k).");
        }
        this.myKeyFile = this.myArgsEngine.getString("-k");
        if (this.myArgsEngine.getBoolean("-e")) {
            this.myEnzyme = this.myArgsEngine.getString("-e");
        } else {
            System.out.println("No enzyme specified.  Using enzyme listed in key file.");
        }
        if (this.myArgsEngine.getBoolean("-o")) {
            this.myOutputDir = this.myArgsEngine.getString("-o");
            File outDirectory = new File(this.myOutputDir);
            if (!outDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("The output name you supplied (option -o) is not a directory: " + this.myOutputDir);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output directory (option -o).");
        }
        Object var3_3 = null;
        this.myMinCount = this.myArgsEngine.getBoolean("-c") ? Integer.parseInt(this.myArgsEngine.getString("-c")) : 1;
        if (this.myArgsEngine.getBoolean("-y")) {
            this.useTBTByte = true;
        }
        if (this.myArgsEngine.getBoolean("-y")) {
            if (this.myArgsEngine.getBoolean("-sh")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -y and -sh are mutually exclusive.");
            }
            this.useTBTByte = true;
        } else if (this.myArgsEngine.getBoolean("-sh")) {
            if (this.myArgsEngine.getBoolean("-y")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -y and -sh are mutually exclusive.");
            }
            this.useTBTShort = true;
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify byte format (-y) *OR* short int format (-sh).");
        }
        if (this.myArgsEngine.getBoolean("-t")) {
            if (this.myArgsEngine.getBoolean("-m")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagCounts(this.myArgsEngine.getString("-t"), TagsByTaxa.FilePacking.Byte);
        } else if (this.myArgsEngine.getBoolean("-m")) {
            if (this.myArgsEngine.getBoolean("-t")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagsOnPhysicalMap(this.myArgsEngine.getString("-m"), true);
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a tagCounts file (-t) *OR* a TagsOnPhysicalMap file (-m)");
        }
    }

    public static void matchTagsToTaxa(String[] fastqFileS, String keyFileS, String enzyme, Tags theMasterTags, String outputDir, int minCount, boolean useTBTByte, boolean useTBTShort) {
        for (int laneNum = 0; laneNum < fastqFileS.length; ++laneNum) {
            ParseBarcodeRead thePBR;
            String replaceS;
            HashMap<String, Integer> readsPerSample = new HashMap<String, Integer>();
            HashMap<String, Integer> mappedReadsPerSample = new HashMap<String, Integer>();
            TagsByTaxa.FilePacking outFormat = useTBTByte ? TagsByTaxa.FilePacking.Byte : (useTBTShort ? TagsByTaxa.FilePacking.Short : TagsByTaxa.FilePacking.Byte);
            String outFileS = outputDir + fastqFileS[laneNum].substring(fastqFileS[laneNum].lastIndexOf(File.separator));
            File outfile = new File(outFileS.replaceAll("(?i)\\.fq$|\\.fq\\.gz$|\\.fastq$|_fastq\\.txt$|_fastq\\.gz$|_fastq\\.txt\\.gz$|_sequence\\.txt$|_sequence\\.txt\\.gz$", replaceS = outFormat == TagsByTaxa.FilePacking.Text ? ".tbt.txt" : (outFormat == TagsByTaxa.FilePacking.Byte ? ".tbt.byte" : (outFormat == TagsByTaxa.FilePacking.Short ? ".tbt.shrt" : ".tbt.bin"))));
            if (outfile.isFile()) {
                System.out.println("An output file " + outfile.getName() + "\n" + " already exists in the output directory for file " + fastqFileS[laneNum] + ".  Skipping.");
                continue;
            }
            System.out.println("\nWorking on fastq file: " + fastqFileS[laneNum]);
            AbstractTagsByTaxa theTBT = null;
            System.gc();
            int goodBarcodedReads = 0;
            int allReads = 0;
            int goodMatched = 0;
            File fastqFile = new File(fastqFileS[laneNum]);
            String[] np = fastqFile.getName().split("_");
            if (np.length == 3) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[1]);
            } else if (np.length == 5) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[1], np[3]);
            } else if (np.length == 4) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[2]);
            } else if (np.length == 6) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[1], np[3]);
            } else {
                System.out.println("Error in parsing file name:");
                System.out.println("   The filename does not contain either 3 or 5 underscore-delimited values.");
                System.out.println("   Expect: flowcell_lane_fastq.txt OR code_flowcell_s_lane_fastq.txt");
                System.out.println("   Filename: " + fastqFileS[laneNum]);
                return;
            }
            System.out.println("Total barcodes found in lane:" + thePBR.getBarCodeCount());
            if (thePBR.getBarCodeCount() == 0) {
                System.out.println("No barcodes found.  Skipping this flowcell.");
                continue;
            }
            String[] taxaNames = new String[thePBR.getBarCodeCount()];
            for (int i = 0; i < taxaNames.length; ++i) {
                taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
                if (readsPerSample.get(taxaNames[i]) == null) {
                    readsPerSample.put(taxaNames[i], 0);
                } else {
                    readsPerSample.put(taxaNames[i], (Integer)readsPerSample.get(taxaNames[i]) + 1);
                }
                if (mappedReadsPerSample.get(taxaNames[i]) == null) {
                    mappedReadsPerSample.put(taxaNames[i], 0);
                    continue;
                }
                readsPerSample.put(taxaNames[i], (Integer)readsPerSample.get(taxaNames[i]) + 1);
            }
            if (useTBTByte) {
                theTBT = new TagsByTaxaByte(taxaNames, theMasterTags);
            } else if (useTBTShort) {
                theTBT = new TagsByTaxaShort(taxaNames, theMasterTags);
            }
            String temp = "";
            int currLine = 0;
            goodBarcodedReads = 0;
            allReads = 0;
            goodMatched = 0;
            try {
                BufferedReader br = fastqFileS[laneNum].endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(fastqFileS[laneNum])))) : new BufferedReader(new FileReader(fastqFileS[laneNum]), 65536);
                String sl = "";
                String qualS = "";
                while ((temp = br.readLine()) != null) {
                    if ((++currLine + 2) % 4 == 0) {
                        sl = temp;
                        continue;
                    }
                    if (currLine % 4 != 0) continue;
                    qualS = temp;
                    ++allReads;
                    ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(sl, qualS, true, 0);
                    if (rr != null) {
                        ++goodBarcodedReads;
                        readsPerSample.put(rr.getTaxonName(), (Integer)readsPerSample.get(rr.getTaxonName()) + 1);
                        int t = theTBT.getIndexOfTaxaName(rr.getTaxonName());
                        int h = theTBT.getTagIndex(rr.getRead());
                        if (h > -1) {
                            theTBT.addReadsToTagTaxon(h, t, 1);
                            ++goodMatched;
                            mappedReadsPerSample.put(rr.getTaxonName(), (Integer)mappedReadsPerSample.get(rr.getTaxonName()) + 1);
                        }
                    }
                    if (allReads % 1000000 != 0) continue;
                    System.out.println("Total Reads:" + allReads + " goodReads:" + goodBarcodedReads + " goodMatched:" + goodMatched);
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("Catch testBasicPipeline c=" + goodBarcodedReads + " e=" + e);
                System.out.println(temp);
                e.printStackTrace();
            }
            System.out.println("Timing process (writing TagsByTaxa file)...");
            long timePoint1 = System.currentTimeMillis();
            theTBT.writeDistFile(outfile, outFormat, minCount);
            System.out.println("...process (writing TagsByTaxa file) took " + (System.currentTimeMillis() - timePoint1) + " milliseconds.");
            System.out.println("Total number of reads in lane=" + allReads);
            System.out.println("Total number of good, barcoded reads=" + goodBarcodedReads);
            int filesDone = laneNum + 1;
            System.out.println("Finished reading " + filesDone + " of " + fastqFileS.length + " sequence files: " + fastqFileS[laneNum] + "\n");
            float goodPct = (float)goodBarcodedReads / (float)allReads;
            float goodMappedPct = (float)goodMatched / (float)allReads;
            try {
                String ofname = outfile.getAbsolutePath() + ".log";
                DataOutputStream report = new DataOutputStream(new FileOutputStream(ofname));
                report.writeBytes("File: " + fastqFileS[laneNum] + '\n' + "Total reads: " + allReads + '\n' + "Accepted reads (with barcode and cut site): " + goodBarcodedReads + "(" + goodPct + " of total)" + '\n' + "Accepted reads found in TOPM: " + goodMatched + "(" + goodMappedPct + " of total)" + '\n' + "name" + '\t' + "read count" + '\t' + "fraction of total" + '\t' + "mapped read count" + '\t' + "fraction mapped of total" + '\n');
                for (String name : readsPerSample.keySet()) {
                    int count = (Integer)readsPerSample.get(name);
                    int mappedCount = (Integer)mappedReadsPerSample.get(name);
                    float pct = (float)count / (float)allReads;
                    float mappedPct = (float)mappedCount / (float)allReads;
                    report.writeBytes(name + '\t' + count + '\t' + pct + '\t' + mappedCount + '\t' + mappedPct + '\n');
                }
                report.close();
                continue;
            }
            catch (Exception e) {
                myLogger.warn((Object)("Caught exception while writing report file for lane " + laneNum + ": " + e));
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

